/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.view;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.view.ComposedQuery;
import org.makumba.view.FieldFormatter;
import org.makumba.view.dateFormatter;
import org.makumba.view.intEnumFormatter;
import org.makumba.view.ptrFormatter;
import org.makumba.view.timestampFormatter;

public class RecordFormatter
implements Serializable {
    public DataDefinition dd;
    public String[] expr;
    protected transient FieldFormatter[] formatterArray;
    private static final long serialVersionUID = 1L;

    public RecordFormatter() {
    }

    public RecordFormatter(ComposedQuery composedQuery) {
        this.dd = composedQuery.getResultType();
        this.initFormatters();
        this.expr = new String[this.dd.getFieldNames().size()];
        for (int i = 0; i < this.dd.getFieldNames().size(); ++i) {
            this.expr[i] = composedQuery.getProjectionAt(i);
        }
    }

    public RecordFormatter(DataDefinition dataDefinition, Hashtable hashtable) {
        this.dd = dataDefinition;
        this.initFormatters();
        this.expr = new String[dataDefinition.getFieldNames().size()];
        for (int i = 0; i < dataDefinition.getFieldNames().size(); ++i) {
            this.expr[i] = (String)hashtable.get(dataDefinition.getFieldDefinition(i).getName());
        }
    }

    protected String applyParameters(FieldFormatter fieldFormatter, Dictionary dictionary, String string) {
        return string;
    }

    public String format(int n, Object object, Dictionary dictionary) {
        this.formatterArray[n].checkParams(this, n, dictionary);
        return this.applyParameters(this.formatterArray[n], dictionary, this.formatterArray[n].format(this, n, object, dictionary));
    }

    protected void initFormatters() {
        this.formatterArray = new FieldFormatter[this.dd.getFieldNames().size()];
        block6: for (int i = 0; i < this.dd.getFieldNames().size(); ++i) {
            FieldDefinition fieldDefinition = this.dd.getFieldDefinition(i);
            switch (fieldDefinition.getIntegerType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.formatterArray[i] = ptrFormatter.getInstance();
                    continue block6;
                }
                case 5: {
                    this.formatterArray[i] = intEnumFormatter.getInstance();
                    continue block6;
                }
                case 9: {
                    this.formatterArray[i] = dateFormatter.getInstance();
                    continue block6;
                }
                case 10: 
                case 11: {
                    this.formatterArray[i] = timestampFormatter.getInstance();
                    continue block6;
                }
                default: {
                    this.formatterArray[i] = FieldFormatter.getInstance();
                }
            }
        }
    }
}

