/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.importer;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.makumba.Database;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaSystem;
import org.makumba.abstr.RecordInfo;
import org.makumba.importer.RecordImporter;
import org.makumba.util.HtmlTagEnumerator;

public class HtmlTableImporter {
    RecordImporter imp;
    boolean inRow = false;
    boolean inCell = false;
    String text;
    Vector data;
    String[] fieldOrder;
    String type;
    Database db;

    void endOfCell() {
        if (this.inCell) {
            this.data.addElement(this.text);
        }
        this.text = null;
    }

    void endOfRow() {
        this.endOfCell();
        if (this.data != null && !this.data.isEmpty()) {
            if (this.data.size() != this.fieldOrder.length) {
                MakumbaSystem.getMakumbaLogger("import").severe(this.type + ": invalid HTML table row length: " + this.data.size() + "\r\nin: " + this.data);
            } else {
                try {
                    this.db.insert(this.type, this.importVector());
                }
                catch (InvalidValueException invalidValueException) {
                    MakumbaSystem.getMakumbaLogger("import").warning("record not inserted --> " + invalidValueException.getMessage());
                }
            }
        }
    }

    Dictionary importVector() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.fieldOrder.length) {
            if (this.data.elementAt(n) != null) {
                Object object = this.imp.getValue(this.fieldOrder[n], (String)this.data.elementAt(n), this.db, null);
                if (object != null) {
                    ((Dictionary)hashtable).put(this.fieldOrder[n], object);
                }
                vector.addElement(object);
            }
            ++n;
        }
        MakumbaSystem.getMakumbaLogger("import").finest(vector.toString());
        return hashtable;
    }

    public static void main(String[] stringArray) throws IOException {
        String[] stringArray2 = new String[stringArray.length - 4];
        System.arraycopy(stringArray, 4, stringArray2, 0, stringArray2.length);
        new HtmlTableImporter(MakumbaSystem.getDatabase(stringArray[0]), RecordInfo.getRecordInfo(stringArray[1]), new BufferedReader(new InputStreamReader(new FileInputStream(stringArray[2]))), stringArray[3], stringArray2);
    }

    public HtmlTableImporter(Database database, RecordInfo recordInfo, Reader reader, String string, String[] stringArray) throws IOException {
        this.imp = new RecordImporter(recordInfo, true);
        this.fieldOrder = stringArray;
        this.type = recordInfo.getName();
        this.db = database;
        String[] stringArray2 = new String[]{recordInfo.getName()};
        MakumbaSystem._delete(database.getName(), database.getName(), stringArray2);
        HtmlTagEnumerator htmlTagEnumerator = new HtmlTagEnumerator(reader);
        while (htmlTagEnumerator.next() && !htmlTagEnumerator.getTag().equals(string)) {
        }
        while (htmlTagEnumerator.next()) {
            String string2;
            if (htmlTagEnumerator.getTagType().toLowerCase().equals("tr")) {
                this.endOfRow();
                this.inRow = true;
                this.inCell = false;
                this.data = new Vector();
            } else if (this.inRow && htmlTagEnumerator.getTagType().toLowerCase().equals("td")) {
                this.endOfCell();
                this.inCell = true;
            } else if (this.inCell && (string2 = htmlTagEnumerator.getNonHtml()) != null && string2.length() > 0) {
                this.text = string2;
            }
            if (!htmlTagEnumerator.getTagType().toLowerCase().equals("/table")) continue;
            this.endOfRow();
            MakumbaSystem.getMakumbaLogger("import").severe("end of table encountered");
            return;
        }
        MakumbaSystem.getMakumbaLogger("import").severe("end of table missing");
    }
}

