/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.abstr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.makumba.DataDefinitionParseError;
import org.makumba.MakumbaError;
import org.makumba.abstr.FieldCursor;
import org.makumba.abstr.FieldInfo;
import org.makumba.abstr.FieldParser;
import org.makumba.abstr.OrderedProperties;
import org.makumba.abstr.RecordHandler;
import org.makumba.abstr.RecordInfo;
import org.makumba.util.ClassResource;

public class RecordParser
extends RecordHandler {
    OrderedProperties text;
    OrderedProperties fields = new OrderedProperties();
    OrderedProperties subfields = new OrderedProperties();
    DataDefinitionParseError mpe;
    Properties definedTypes;
    FieldCursor currentRowCursor;

    void parse(RecordInfo recordInfo) {
        this.ri = recordInfo;
        this.text = new OrderedProperties();
        this.mpe = new DataDefinitionParseError();
        try {
            this.read(this.text, recordInfo.origin);
        }
        catch (IOException iOException) {
            throw this.fail(iOException);
        }
        try {
            recordInfo.addStandardFields(recordInfo.name.substring(recordInfo.name.lastIndexOf(46) + 1));
            this.parse();
        }
        catch (RuntimeException runtimeException) {
            throw new MakumbaError(runtimeException, "Internal error in parser while parsing " + recordInfo.getName());
        }
        if (!this.mpe.isSingle() && !recordInfo.isSubtable()) {
            throw this.mpe;
        }
    }

    RecordInfo parse(URL uRL, String string) {
        this.ri = new RecordInfo(uRL, string);
        this.parse(this.ri);
        return this.ri;
    }

    RecordInfo parse(String string) {
        this.ri = new RecordInfo();
        this.text = new OrderedProperties();
        this.mpe = new DataDefinitionParseError();
        try {
            this.read(this.text, string);
        }
        catch (IOException iOException) {
            throw this.fail(iOException);
        }
        try {
            this.ri.addStandardFields(this.ri.name.substring(this.ri.name.lastIndexOf(46) + 1));
            this.parse();
        }
        catch (RuntimeException runtimeException) {
            throw new MakumbaError(runtimeException, "Internal error in parser while parsing " + this.ri.getName());
        }
        if (!this.mpe.isSingle() && !this.ri.isSubtable()) {
            throw this.mpe;
        }
        return this.ri;
    }

    void parse() {
        this.solveIncludes();
        this.separateFields();
        this.setTitle();
        this.readTypes();
        if (this.text.size() != 0) {
            this.mpe.add(this.fail("unrecognized commands", this.text.toString()));
        }
        this.treatMyFields();
        this.configSubfields();
        this.treatSubfields();
    }

    void separateFields() {
        Enumeration enumeration = this.text.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf(33) == 0) continue;
            if (string.indexOf("->") == -1) {
                this.fields.putLast(string, this.text.getOriginal(string), this.text.remove(string));
                continue;
            }
            this.subfields.putLast(string, this.text.getOriginal(string), this.text.remove(string));
        }
    }

    void setTitle() {
        String string = this.text.getOriginal("!title");
        String string2 = (String)this.text.remove("!title");
        String string3 = null;
        if (string2 != null) {
            string3 = string2.trim();
            if (this.fields.get(string3) == null) {
                this.mpe.add(this.fail("no such field for title", RecordParser.makeLine(string, string2)));
                return;
            }
        } else if (this.fields.get("name") != null) {
            string3 = "name";
        } else if (this.fields.size() > 0) {
            string3 = this.fields.keyAt(0);
        }
        this.ri.title = string3;
    }

    static URL getResource(String string) {
        return ClassResource.get(string);
    }

    public static URL findDataDefinition(String string, String string2) {
        String string3 = null;
        URL uRL = null;
        if (string.endsWith(".") || string.endsWith("//")) {
            return null;
        }
        uRL = RecordParser.getResource("metadata.files/" + string.replace('.', '/'));
        if (uRL == null && (uRL = RecordParser.getResource(string.replace('.', '/') + "." + string2)) == null && (uRL = RecordParser.getResource("dataDefinitions/" + string.replace('.', '/') + "." + string2)) == null && (uRL = RecordParser.getResource(string3 = "dataDefinitions/" + string.replace('.', '/'))) == null) {
            string3 = string.replace('.', '/');
            uRL = RecordParser.getResource(string3);
        }
        return uRL;
    }

    void solveIncludes() {
        String string;
        int n = 0;
        Enumeration enumeration = this.text.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.startsWith("!include")) {
                OrderedProperties orderedProperties;
                String string2 = this.text.getOriginal(string);
                String string3 = (String)this.text.remove(string);
                --n;
                String string4 = string3;
                URL uRL = RecordParser.findDataDefinition(string4, "idd");
                String string5 = "." + this.ri.name;
                if (uRL == null) {
                    this.mpe.add(this.fail("could not find include file " + string4, string2 + "=" + string3));
                    return;
                }
                try {
                    orderedProperties = new OrderedProperties();
                    this.read(orderedProperties, uRL);
                }
                catch (IOException iOException) {
                    this.mpe.add(this.fail("could not find include file " + string4 + " " + iOException, string2 + "=" + string3));
                    return;
                }
                Enumeration enumeration2 = orderedProperties.keys();
                while (enumeration2.hasMoreElements()) {
                    String string6 = (String)enumeration2.nextElement();
                    String string7 = this.text.getProperty(string6);
                    if (string7 != null) continue;
                    this.text.putAt(++n, string6, orderedProperties.getOriginal(string6), orderedProperties.getProperty(string6));
                }
            }
            ++n;
        }
        enumeration = this.text.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (((String)this.text.get(string)).trim().length() != 0) continue;
            this.text.remove(string);
        }
    }

    void readTypes() {
        Enumeration enumeration = this.text.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("!type.")) continue;
            String string2 = string.substring(6);
            ((Hashtable)this.definedTypes).put(string2, this.text.remove(string));
        }
    }

    void treatMyFields() {
        int n = 0;
        Enumeration enumeration = this.fields.keys();
        while (enumeration.hasMoreElements()) {
            block3: {
                FieldParser fieldParser;
                String string = (String)enumeration.nextElement();
                FieldInfo fieldInfo = new FieldInfo(this.ri, string);
                this.ri.addField1(fieldInfo);
                try {
                    fieldParser = new FieldParser(fieldInfo).parse(new FieldCursor(this, RecordParser.makeLine(this.fields, string)));
                    this.handlers.put(string, fieldParser);
                }
                catch (DataDefinitionParseError dataDefinitionParseError) {
                    this.mpe.add(dataDefinitionParseError);
                    break block3;
                }
                this.handlerOrder.addElement(fieldParser);
            }
            ++n;
        }
    }

    void configSubfields() {
        Enumeration enumeration = this.subfields.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            String string = (String)enumeration.nextElement();
            FieldParser fieldParser = (FieldParser)this.handlers.get(string.substring(0, n = string.indexOf("->")));
            if (fieldParser == null) {
                this.mpe.add(this.fail("no such field in subfield definition", RecordParser.makeLine(this.subfields, string)));
                continue;
            }
            String string2 = fieldParser.addText(string.substring(n + 2), this.subfields.getOriginal(string), this.subfields.getProperty(string));
            if (string2 == null) continue;
            this.mpe.add(this.fail(string2, RecordParser.makeLine(this.subfields, string)));
        }
    }

    void treatSubfields() {
        try {
            this.callAll(this.getHandlerMethod("parseSubfields"), RecordHandler.noArgs);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
    }

    static String makeLine(String string, String string2) {
        return string + "=" + string2;
    }

    static String makeLine(OrderedProperties orderedProperties, String string) {
        return orderedProperties.getOriginal(string) + "=" + orderedProperties.getProperty(string);
    }

    public static Vector commaString2Vector(String string) {
        Vector<String> vector = new Vector<String>();
        while (true) {
            String string2;
            int n;
            if ((n = string.indexOf(44)) == -1) {
                string2 = string.trim();
                if (string2.length() > 0) {
                    vector.addElement(string2);
                }
                return vector;
            }
            string2 = string.substring(0, n).trim();
            if (string2.length() > 0) {
                vector.addElement(string2);
            }
            string = string.substring(n + 1);
        }
    }

    static String listArguments(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        if (vector != null && vector.size() > 0) {
            stringBuffer.append('(').append(vector.elementAt(0));
            int n = 1;
            while (n < vector.size()) {
                stringBuffer.append(", ").append(vector.elementAt(n));
                ++n;
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    DataDefinitionParseError fail(String string, String string2) {
        return new DataDefinitionParseError(this.ri.getName(), string, string2, string2.length());
    }

    DataDefinitionParseError fail(IOException iOException) {
        return new DataDefinitionParseError(this.ri.getName(), iOException);
    }

    void read(OrderedProperties orderedProperties, String string) throws IOException {
        this.read(orderedProperties, new BufferedReader(new StringReader(string)));
    }

    void read(OrderedProperties orderedProperties, URL uRL) throws IOException {
        this.read(orderedProperties, new BufferedReader(new InputStreamReader((InputStream)uRL.getContent())));
    }

    /*
     * Unable to fully structure code
     */
    void read(OrderedProperties var1_1, BufferedReader var2_2) throws IOException {
        while (true) {
            block5: {
                var3_3 = null;
                var3_3 = var2_2.readLine();
                if (var3_3 == null) break;
                var4_4 = var3_3.trim();
                var5_5 = var3_3.indexOf(61);
                if (var4_4.length() == 0 || var4_4.charAt(0) == '#') continue;
                if (var5_5 == -1) {
                    this.mpe.add(this.fail("non-empty, non-comment line without =", var3_3));
                    continue;
                }
                var6_6 = var3_3.substring(0, var5_5);
                var7_7 = var6_6.trim();
                if (var7_7.length() == 0) {
                    this.mpe.add(this.fail("zero length key", var3_3));
                    continue;
                }
                if (var7_7.charAt(0) == '!' && var7_7.length() == 1) {
                    this.mpe.add(this.fail("zero length command", var3_3));
                    continue;
                }
                if (!var7_7.startsWith("!include")) break block5;
                if (var7_7.length() <= 8) ** GOTO lbl24
                this.mpe.add(this.fail("unknown command: " + var7_7, var3_3));
                continue;
lbl-1000:
                // 1 sources

                {
                    var7_7 = var7_7 + "_";
lbl24:
                    // 2 sources

                    ** while (var1_1.get((Object)var7_7) != null)
                }
            }
            if (var1_1.putLast(var7_7, var6_6, var3_3.substring(var5_5 + 1)) == null) continue;
            this.mpe.add(this.fail("ambiguous key " + var7_7, var3_3));
        }
        var2_2.close();
    }

    RecordParser() {
        this.definedTypes = new Properties();
    }

    RecordParser(RecordInfo recordInfo, RecordParser recordParser) {
        super(recordInfo);
        this.text = new OrderedProperties();
        this.definedTypes = recordParser.definedTypes;
        this.mpe = recordParser.mpe;
    }
}

