/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.StringBufferInputStream;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.makumba.DataDefinition;
import org.makumba.Database;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.OQLAnalyzer;
import org.makumba.OQLParseError;
import org.makumba.abstr.RecordInfo;
import org.makumba.db.sql.oql.OQLLexer;
import org.makumba.db.sql.oql.OQLParser;
import org.makumba.db.sql.oql.QueryAST;
import org.makumba.util.NamedResources;
import org.makumba.util.RuntimeWrappedException;

public class MakumbaSystem {
    public static final Date loadingTime = new Date();
    static String loggingRoot = "org.makumba";
    static int parsedQueries = NamedResources.makeStaticCache("OQL parsed queries", new 1());

    public static Map getCacheInfo() {
        return NamedResources.getCacheInfo();
    }

    public static String getDefaultDatabaseName() {
        return org.makumba.db.Database.findDatabaseName("MakumbaDatabase.properties");
    }

    public static String getDefaultDatabaseName(String string) {
        return org.makumba.db.Database.findDatabaseName(string);
    }

    public static Database getConnectionTo(String string) {
        return org.makumba.db.Database.getDatabase(string).getDBConnection();
    }

    public static Database findDatabase() {
        return MakumbaSystem.getConnectionTo(MakumbaSystem.getDefaultDatabaseName());
    }

    public static Database findDatabase(String string) {
        return MakumbaSystem.getConnectionTo(MakumbaSystem.getDefaultDatabaseName(string));
    }

    public static Database getDatabase(String string) {
        return MakumbaSystem.getConnectionTo(string);
    }

    public static String getDatabaseProperty(String string, String string2) {
        return org.makumba.db.Database.getDatabase(string).getConfiguration(string2);
    }

    public static DataDefinition getDataDefinition(String string) {
        return RecordInfo.getRecordInfo(string);
    }

    public static DataDefinition getResultDataDefinition(String string) {
        return MakumbaSystem.getOQLAnalyzer(string).getProjectionType();
    }

    public static void _delete(String string, String string2, String[] stringArray) {
        org.makumba.db.Database.getDatabase(string).deleteFrom(string2, stringArray);
    }

    public static void _copy(String string, String string2, String[] stringArray) {
        org.makumba.db.Database.getDatabase(string2).copyFrom(string, stringArray);
    }

    public static String getVersion() {
        return "$Name: makumba-0_5_5_22 $".substring(7, "$Name: makumba-0_5_5_22 $".length() - 2);
    }

    public static Logger getMakumbaLogger(String string) {
        return Logger.getLogger(loggingRoot + "." + string);
    }

    public static Logger getLogger(String string) {
        return MakumbaSystem.getMakumbaLogger("apps." + string);
    }

    public static Logger getLogger() {
        return MakumbaSystem.getMakumbaLogger("apps");
    }

    public static void setLoggingRoot(String string) {
        loggingRoot = string;
    }

    public static TimeZone getTimeZone() {
        String string = System.getProperty("makumba.displayTimeZone");
        if (string != null) {
            return TimeZone.getTimeZone(string);
        }
        return TimeZone.getDefault();
    }

    public static Locale getLocale() {
        return Locale.UK;
    }

    public static OQLAnalyzer getOQLAnalyzer(String string) {
        try {
            return (OQLAnalyzer)NamedResources.getStaticCache(parsedQueries).getResource(string);
        }
        catch (RuntimeWrappedException runtimeWrappedException) {
            if (runtimeWrappedException.getReason() instanceof RecognitionException) {
                RecognitionException recognitionException = (RecognitionException)runtimeWrappedException.getReason();
                String string2 = recognitionException.getMessage();
                if (string2.startsWith("line")) {
                    string2 = string2.substring(string2.indexOf(58) + 1);
                }
                throw new OQLParseError(string2 + "\r\nin query:\r\n" + string);
            }
            throw runtimeWrappedException;
        }
    }

    static OQLAnalyzer parseQueryFundamental(String string) throws RecognitionException {
        Date date = new Date();
        OQLLexer oQLLexer = new OQLLexer(new StringBufferInputStream(string));
        OQLParser oQLParser = new OQLParser(oQLLexer);
        QueryAST queryAST = null;
        try {
            oQLParser.setASTNodeClass("org.makumba.db.sql.oql.OQLAST");
            oQLParser.queryProgram();
            queryAST = (QueryAST)oQLParser.getAST();
            queryAST.setOQL(string);
        }
        catch (TokenStreamException tokenStreamException) {
            throw new MakumbaError(tokenStreamException);
        }
        long l = new Date().getTime() - date.getTime();
        MakumbaSystem.getMakumbaLogger("db.query.compilation").fine("OQL to SQL: " + l + " ms: " + string);
        return queryAST;
    }
}

