/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.makumba.ConfigFileError;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.abstr.RecordInfo;
import org.makumba.db.DBConnection;
import org.makumba.db.DBConnectionWrapper;
import org.makumba.db.Database;
import org.makumba.db.Query;
import org.makumba.db.Table;
import org.makumba.db.Update;
import org.makumba.util.ClassResource;
import org.makumba.util.NamedResourceFactory;
import org.makumba.util.NamedResources;
import org.makumba.util.ResourcePool;
import org.makumba.util.RuntimeWrappedException;
import org.makumba.view.dateFormatter;

public abstract class Database {
    static Class[] theProp = new Class[]{class$Ljava$util$Properties != null ? class$Ljava$util$Properties : (class$Ljava$util$Properties = Database.class$("java.util.Properties"))};
    static int dbs = NamedResources.makeStaticCache("Databases open", new 1());
    int nconn = 0;
    ResourcePool connections;
    int dbsv;
    Properties config;
    Class tableclass;
    String configName;
    Hashtable queryCache;
    NamedResources tables;
    NamedResourceFactory tableFactory;
    private static /* synthetic */ Class class$Ljava$util$Properties;

    public String getName() {
        return this.configName;
    }

    public void initConnections() {
        try {
            this.connections.init(10);
        }
        catch (Exception exception) {
            throw new DBError(exception);
        }
    }

    protected void closeConnections() {
    }

    public void close() {
        MakumbaSystem.getMakumbaLogger("db.init").info("closing  " + this.getConfiguration() + "\n\tat " + dateFormatter.debugTime.format(new Date()));
        this.closeConnections();
    }

    public DBConnection getDBConnection() {
        try {
            return new DBConnectionWrapper((DBConnection)this.connections.get());
        }
        catch (Exception exception) {
            throw new DBError(exception);
        }
    }

    protected abstract DBConnection makeDBConnection();

    public int getDbsv() {
        return this.dbsv;
    }

    public abstract Pointer getPointer(String var1, int var2);

    public String getConfiguration() {
        return this.configName;
    }

    public String getConfiguration(String string) {
        return this.config.getProperty(string);
    }

    public static String findDatabaseName(Properties properties) {
        int n;
        String string;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = string.indexOf(35);
            if (n == -1) continue;
            try {
                if (!InetAddress.getByName(string.substring(0, n)).equals(InetAddress.getLocalHost()) || !string.substring(n + 1).equals(System.getProperty("user.dir"))) continue;
                return properties.getProperty(string);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = string.indexOf(35);
            if (n == -1) continue;
            try {
                if (!InetAddress.getByName(string.substring(0, n)).equals(InetAddress.getLocalHost()) || !string.substring(n + 1).equals("default")) continue;
                return properties.getProperty(string);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return properties.getProperty("default");
    }

    public static Database findDatabase(Properties properties) {
        return Database.getDatabase(Database.findDatabaseName(properties));
    }

    public static Database findDatabase(String string) {
        return Database.getDatabase(Database.findDatabaseName(string));
    }

    public static String findDatabaseName(String string) {
        Properties properties = new Properties();
        try {
            properties.load(ClassResource.get(string).openStream());
        }
        catch (Exception exception) {
            throw new ConfigFileError(string);
        }
        return Database.findDatabaseName(properties);
    }

    public static Database getDatabase(String string) {
        try {
            return (Database)NamedResources.getStaticCache(dbs).getResource(string);
        }
        catch (RuntimeWrappedException runtimeWrappedException) {
            if (runtimeWrappedException.getReason() instanceof MakumbaError) {
                throw (MakumbaError)runtimeWrappedException.getReason();
            }
            throw runtimeWrappedException;
        }
    }

    protected Class getTableClassConfigured() {
        return null;
    }

    public abstract String OQLDate(Date var1);

    public Table getTable(String string) {
        int n;
        if (string.indexOf(47) != -1 && (string = string.replace('/', '.')).charAt(0) == '.') {
            string = string.substring(1);
        }
        if ((n = string.indexOf("->")) == -1) {
            return this.getTable(RecordInfo.getRecordInfo(string));
        }
        Table table = this.getTable(string.substring(0, n));
        while ((n = (string = string.substring(n + 2)).indexOf("->")) != -1) {
            table = table.getRelatedTable(string.substring(0, n));
        }
        table = table.getRelatedTable(string);
        return table;
    }

    public Table getTable(RecordInfo recordInfo) {
        return (Table)this.tables.getResource(recordInfo);
    }

    public static String findConfig(Properties properties, String string) {
        String string2 = null;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string.startsWith(string3) || string2 != null && string2.length() >= string3.length()) continue;
            string2 = string3;
        }
        return string2;
    }

    public abstract Query prepareQueryImpl(DBConnection var1, String var2);

    public abstract Update prepareUpdateImpl(DBConnection var1, String var2, String var3, String var4);

    public abstract int getMinPointerValue();

    public abstract int getMaxPointerValue();

    public void deleteFrom(DBConnection dBConnection, String string, DBConnection dBConnection2) {
        DataDefinition dataDefinition = MakumbaSystem.getDataDefinition(string);
        MakumbaSystem.getMakumbaLogger("db.admin.delete").info("deleted " + this.getTable(string).deleteFrom(dBConnection, dBConnection2) + " old objects from " + string);
        Enumeration enumeration = dataDefinition.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            FieldDefinition fieldDefinition = dataDefinition.getFieldDefinition((String)enumeration.nextElement());
            if (!fieldDefinition.getType().startsWith("set") && !fieldDefinition.getType().equals("ptrOne")) continue;
            this.deleteFrom(dBConnection, fieldDefinition.getSubtype().getName(), dBConnection2);
        }
    }

    public void deleteFrom(String string, String string2) {
        String[] stringArray = new String[]{string2};
        this.deleteFrom(string, stringArray);
    }

    public void deleteFrom(String string, String[] stringArray) {
        DBConnection dBConnection = this.getDBConnection();
        DBConnection dBConnection2 = Database.getDatabase(string).getDBConnection();
        try {
            this.deleteFrom(dBConnection, stringArray, dBConnection2);
        }
        finally {
            Object var6_5 = null;
            dBConnection.close();
            dBConnection2.close();
        }
    }

    public void deleteFrom(DBConnection dBConnection, String[] stringArray, DBConnection dBConnection2) {
        int n = 0;
        while (n < stringArray.length) {
            this.deleteFrom(dBConnection, stringArray[n], dBConnection2);
            ++n;
        }
    }

    public void copyFrom(String string, String string2) {
        String[] stringArray = new String[]{string2};
        this.copyFrom(string, stringArray);
    }

    public void copyFrom(String string, String[] stringArray) {
        DBConnection dBConnection = this.getDBConnection();
        DBConnection dBConnection2 = Database.getDatabase(string).getDBConnection();
        try {
            this.copyFrom(dBConnection, stringArray, dBConnection2);
        }
        finally {
            Object var6_5 = null;
            dBConnection.close();
            dBConnection2.close();
        }
    }

    public void copyFrom(DBConnection dBConnection, String[] stringArray, DBConnection dBConnection2) {
        this.deleteFrom(dBConnection, stringArray, dBConnection2);
        int n = 0;
        while (n < stringArray.length) {
            this.copyFrom(dBConnection, stringArray[n], dBConnection2);
            ++n;
        }
    }

    public void copyFrom(DBConnection dBConnection, String string, DBConnection dBConnection2) {
        DataDefinition dataDefinition = MakumbaSystem.getDataDefinition(string);
        this.getTable(string).copyFrom(dBConnection, dBConnection.db.getTable(string), dBConnection2);
        Enumeration enumeration = dataDefinition.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            FieldDefinition fieldDefinition = dataDefinition.getFieldDefinition((String)enumeration.nextElement());
            if (!fieldDefinition.getType().startsWith("set") && !fieldDefinition.getType().equals("ptrOne")) continue;
            this.copyFrom(dBConnection, fieldDefinition.getSubtype().getName(), dBConnection2);
        }
    }

    public void copyFrom(String string) {
        DBConnection dBConnection = this.getDBConnection();
        DBConnection dBConnection2 = Database.findDatabase(string).getDBConnection();
        try {
            Vector vector = dBConnection2.executeQuery("SELECT c.name AS name FROM org.makumba.db.Catalog c", null);
            String[] stringArray = new String[vector.size()];
            int n = 0;
            while (n < stringArray.length) {
                String string2 = (String)((Dictionary)vector.elementAt(n)).get("name");
                MakumbaSystem.getMakumbaLogger("db.admin.copy").info(string2);
                stringArray[n] = string2;
                ++n;
            }
            this.copyFrom(dBConnection, stringArray, dBConnection2);
        }
        finally {
            Object var5_8 = null;
            dBConnection.close();
            dBConnection2.close();
        }
    }

    public void openTables(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            DataDefinition dataDefinition = MakumbaSystem.getDataDefinition(stringArray[n]);
            this.getTable(stringArray[n]);
            Enumeration enumeration = dataDefinition.getFieldNames().elements();
            while (enumeration.hasMoreElements()) {
                FieldDefinition fieldDefinition = dataDefinition.getFieldDefinition((String)enumeration.nextElement());
                if (!fieldDefinition.getType().equals("setComplex") && !fieldDefinition.getType().equals("ptrOne")) continue;
                DataDefinition dataDefinition2 = fieldDefinition.getSubtype();
                this.getTable(dataDefinition2.getName());
            }
            ++n;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    synchronized void addTable(String string) {
        DBConnection dBConnection;
        block2: {
            dBConnection = this.getDBConnection();
            try {
                Enumeration enumeration = dBConnection.executeQuery("SELECT c FROM org.makumba.db.Catalog c WHERE c.name=$1", string).elements();
                if (enumeration.hasMoreElements()) break block2;
                Hashtable<String, String> hashtable = new Hashtable<String, String>(3);
                ((Dictionary)hashtable).put("name", string);
                this.getTable("org.makumba.db.Catalog").insertRecord(dBConnection, hashtable);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                dBConnection.close();
                throw throwable;
            }
        }
        Object var4_5 = null;
        dBConnection.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Database(Properties properties) {
        Database database = this;
        if (database == null) {
            throw null;
        }
        this.connections = new 2(database);
        this.config = null;
        this.queryCache = new Hashtable();
        Database database2 = this;
        if (database2 == null) {
            throw null;
        }
        this.tableFactory = new 3(database2);
        this.config = properties;
        this.configName = properties.getProperty("db.name");
        properties.put("jdbc_connections", "0");
        try {
            this.dbsv = new Integer((String)properties.get("dbsv"));
            this.tableclass = this.getTableClassConfigured();
            properties.put("alter#org.makumba.db.Catalog", "true");
        }
        catch (Exception exception) {
            throw new MakumbaError(exception);
        }
    }
}

