/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.view.jsptaglib;

import java.io.IOException;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.makumba.Attributes;
import org.makumba.InvalidValueException;
import org.makumba.LogicException;
import org.makumba.Pointer;
import org.makumba.abstr.FieldInfo;
import org.makumba.abstr.RecordInfo;
import org.makumba.util.NamedResources;
import org.makumba.view.jsptaglib.FormResponder;
import org.makumba.view.jsptaglib.FormTagBase;
import org.makumba.view.jsptaglib.HttpAttributes;
import org.makumba.view.jsptaglib.RecordEditor;

public abstract class FormResponder
implements Serializable {
    public static final String responderName = "__makumba__responder__";
    public static final String basePointerName = "__makumba__base__";
    static int cache = NamedResources.makeStaticCache("Http controller form responders", new 1());
    int identity;
    String database;
    Object controller;
    RecordInfo dd = new RecordInfo();
    int max = 0;
    RecordEditor editor;
    String subjectLabel;
    String message;
    Hashtable fieldParameters = new Hashtable();
    Hashtable fieldNames = new Hashtable();
    String operation;
    String type;
    String pointerType;
    String formKey;
    boolean simpleForm;
    String handler;
    Hashtable indexes = new Hashtable();

    public void init(FormTagBase formTagBase) throws LogicException {
        this.controller = HttpAttributes.getAttributes((PageContext)formTagBase.getPageContext()).controller;
        this.database = formTagBase.getDatabaseName();
        this.operation = formTagBase.getClass().getName();
        this.message = formTagBase.getMessage();
        this.subjectLabel = formTagBase.getSubjectLabel();
        this.formKey = formTagBase.getFormKey();
        this.handler = formTagBase.handler;
    }

    public void writeInput(JspWriter jspWriter, String string) throws IOException {
        jspWriter.print("<input type=\"hidden\" name=\"" + responderName + "\" value=\"" + this.getIdentity(string) + "\">");
    }

    public String format(String string, Object object, Object object2, Dictionary dictionary) {
        Integer n = (Integer)this.indexes.get(string);
        if (n != null) {
            return this.editor.format(n, object2, dictionary);
        }
        this.indexes.put(string, new Integer(this.max));
        String string2 = "col" + this.max;
        this.fieldNames.put(string2, string);
        this.fieldParameters.put(string2, (Dictionary)((Hashtable)dictionary).clone());
        this.dd.addField(FieldInfo.getFieldInfo(string2, object, true));
        this.editor = new RecordEditor(this.dd, this.fieldNames);
        this.editor.database = this.database;
        this.editor.config();
        return this.editor.format(this.max++, object2, dictionary);
    }

    public String responderKey() {
        return this.operation + this.formKey + this.fieldNames + this.fieldParameters + this.subjectLabel + this.database;
    }

    public int getIdentity(String string) {
        if (string == null && !this.simpleForm) {
            return -1;
        }
        this.type = string;
        return this.getSimpleIdentity();
    }

    public int getSimpleIdentity() {
        return ((FormResponder)NamedResources.getStaticCache((int)FormResponder.cache).getResource((Object)this)).identity;
    }

    public static Integer responseId(PageContext pageContext) {
        String string = (String)HttpAttributes.getParameters(pageContext).getParameter(responderName);
        if (string == null) {
            return null;
        }
        if (!(string instanceof String)) {
            throw new RuntimeException("Multiple responses??? " + string);
        }
        return new Integer(Integer.parseInt(string));
    }

    public static FormResponder getFormResponder(Integer n) {
        FormResponder formResponder = (FormResponder)((Hashtable)NamedResources.getStaticCache(cache).getSupplementary()).get(n);
        if (formResponder == null) {
            throw new InvalidValueException("Form responder cannot be found, probably due to server restart. Please reload the form page.");
        }
        return formResponder;
    }

    public Attributes makeAttributes(PageContext pageContext) throws LogicException {
        return new HttpAttributes(this.controller, pageContext, this.database);
    }

    public Dictionary getHttpData(PageContext pageContext) {
        if (this.editor != null) {
            return this.editor.readFrom(pageContext);
        }
        return new Hashtable(1);
    }

    public void writeBasePointer(JspWriter jspWriter, String string) throws IOException {
        jspWriter.print("<input type=\"hidden\" name=\"" + basePointerName + "\" value=\"" + string + "\">");
    }

    public Pointer getHttpBasePointer(PageContext pageContext) {
        return new Pointer(this.pointerType, (String)HttpAttributes.getParameters(pageContext).getParameter(basePointerName));
    }

    public abstract Object respondTo(PageContext var1) throws LogicException;

    public String getSubjectLabel() {
        return this.subjectLabel;
    }

    public String getMessage() {
        return this.message;
    }
}

