/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.makumba.DBError;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.db.DBConnection;
import org.makumba.db.DBConnectionWrapper;
import org.makumba.db.Query;
import org.makumba.db.Update;
import org.makumba.db.sql.SQLDBConnection;
import org.makumba.db.sql.SQLPointer;
import org.makumba.db.sql.SQLUpdate;
import org.makumba.util.ClassResource;

public class Database
extends org.makumba.db.Database {
    static Properties sqlDrivers = new Properties();
    Properties connectionConfig = new Properties();
    String url;
    String eng;
    Properties types = new Properties();
    boolean addUnderscore = true;
    Hashtable catalog = null;
    private static /* synthetic */ Class class$Lorg$makumba$db$sql$RecordManager;

    public String getEngine() {
        return this.eng;
    }

    public static String getEngineProperty(String string) {
        return sqlDrivers.getProperty(string);
    }

    protected DBConnection makeDBConnection() {
        try {
            return new SQLDBConnection(this);
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException);
            throw new DBError(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readCatalog(SQLDBConnection sQLDBConnection) throws SQLException {
        SQLException sQLException = null;
        Hashtable hashtable = new Hashtable();
        boolean bl = false;
        try {
            ResultSet resultSet = sQLDBConnection.getMetaData().getColumns(null, null, "%", null);
            if (resultSet == null) {
                bl = true;
            } else {
                while (resultSet.next()) {
                    String string = resultSet.getString("TABLE_NAME");
                    Vector<Hashtable<String, Object>> vector = (Vector<Hashtable<String, Object>>)hashtable.get(string);
                    if (vector == null) {
                        vector = new Vector<Hashtable<String, Object>>();
                        hashtable.put(string, vector);
                    }
                    Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>(5);
                    hashtable2.put("COLUMN_NAME", resultSet.getString("COLUMN_NAME"));
                    hashtable2.put("DATA_TYPE", new Integer(resultSet.getInt("DATA_TYPE")));
                    hashtable2.put("TYPE_NAME", resultSet.getString("TYPE_NAME"));
                    hashtable2.put("COLUMN_SIZE", new Integer(resultSet.getInt("COLUMN_SIZE")));
                    vector.addElement(hashtable2);
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException2) {
            bl = true;
            sQLException = sQLException2;
        }
        if (bl) {
            MakumbaSystem.getMakumbaLogger("db.init").severe("failed to read catalog " + sQLException);
            return;
        }
        this.catalog = hashtable;
    }

    protected String getJdbcUrl(Properties properties) {
        String string = "jdbc:";
        this.eng = properties.getProperty("#sqlEngine");
        string = string + this.eng + ":";
        String string2 = Database.getEngineProperty(this.eng + ".localJDBC");
        if (string2 == null || !string2.equals("true")) {
            string = string + "//" + properties.getProperty("#host") + "/";
        }
        return string + properties.getProperty("#database");
    }

    public Query prepareQueryImpl(DBConnection dBConnection, String string) {
        return new org.makumba.db.sql.Query(dBConnection, string);
    }

    public Update prepareUpdateImpl(DBConnection dBConnection, String string, String string2, String string3) {
        return new SQLUpdate((SQLDBConnection)dBConnection, string, string2, string3);
    }

    public int getMinPointerValue() {
        return this.getDbsv() << SQLPointer.getMaskOrder();
    }

    public int getMaxPointerValue() {
        return (this.getDbsv() + 1 << SQLPointer.getMaskOrder()) - 1;
    }

    protected Class getTableClassConfigured() {
        try {
            String string = this.getConfiguration("tableclass");
            if (string != null || (string = sqlDrivers.getProperty(this.getConfiguration("#sqlEngine") + ".tableclass")) != null) {
                return Class.forName(string);
            }
            return this.getTableClass();
        }
        catch (Exception exception) {
            throw new MakumbaError(exception);
        }
    }

    protected Class getTableClass() {
        return class$Lorg$makumba$db$sql$RecordManager != null ? class$Lorg$makumba$db$sql$RecordManager : (class$Lorg$makumba$db$sql$RecordManager = Database.class$("org.makumba.db.sql.RecordManager"));
    }

    /*
     * Unable to fully structure code
     */
    public static String SQLEscape(String var0) {
        var1_1 = new StringBuffer("'");
        var2_2 = var0.length();
        var3_3 = 0;
        while (var3_3 < var2_2) {
            block5: {
                block4: {
                    block3: {
                        var4_4 = var0.charAt(var3_3);
                        if (var4_4 != '\'') break block3;
                        var1_1.append('\\');
                        ** GOTO lbl-1000
                    }
                    if (var4_4 != '\\') break block4;
                    var1_1.append('\\');
                    ** GOTO lbl-1000
                }
                if (var4_4 != '\"') break block5;
                var1_1.append('\\');
                ** GOTO lbl-1000
            }
            if (var4_4 == '\u0000') {
                var1_1.append("\\0");
            } else lbl-1000:
            // 4 sources

            {
                var1_1.append(var4_4);
            }
            ++var3_3;
        }
        var1_1.append('\'');
        return var1_1.toString();
    }

    protected String getTableName(String string) {
        return (this.addUnderscore ? string : "." + string.toLowerCase()).replace('.', '_').replace('(', '_').replace(')', '_').replace('>', '_').replace('-', '_') + (this.addUnderscore ? "_" : "");
    }

    protected String getFieldName(String string) {
        return (this.addUnderscore ? string : (string.startsWith("TS_") ? string : string.substring(0, 1).toLowerCase() + string.substring(1))).replace('.', '_') + (this.addUnderscore ? "_" : "");
    }

    protected void checkState(SQLException sQLException, String string) {
        this.checkState(sQLException, string, null);
    }

    protected void checkState(SQLException sQLException, String string, String string2) {
        string = sqlDrivers.getProperty(this.getConfiguration("#sqlEngine") + "." + string);
        if (string != null && sQLException.getSQLState().equals(string)) {
            return;
        }
        MakumbaSystem.getMakumbaLogger("db.init.tablechecking").log(Level.SEVERE, "" + sQLException.getSQLState(), sQLException);
        throw new DBError(sQLException, string2);
    }

    protected int exec(PreparedStatement preparedStatement) {
        try {
            MakumbaSystem.getMakumbaLogger("db.update.execution").fine(preparedStatement.toString());
            preparedStatement.execute();
            int n = preparedStatement.getUpdateCount();
            return n;
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException);
            throw new DBError(sQLException);
        }
    }

    static void logException(SQLException sQLException) {
        Database.logException(sQLException, null);
    }

    static void logException(SQLException sQLException, DBConnection dBConnection) {
        String string = "";
        if (dBConnection != null) {
            string = dBConnection.toString() + " ";
        }
        SQLException sQLException2 = sQLException;
        while (sQLException2 != null) {
            string = string + sQLException2.getMessage() + " SQL state: " + sQLException2.getSQLState() + " error code :" + sQLException2.getErrorCode() + "\n";
            sQLException2 = sQLException2.getNextException();
        }
        MakumbaSystem.getMakumbaLogger("db.exception").warning("" + string);
    }

    public String OQLDate(Date date) {
        return "date" + "\"" + new Timestamp(date.getTime()) + "\"";
    }

    public Pointer getPointer(String string, int n) {
        return new SQLPointer(string, this.getDbsv(), n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Database(Properties properties) {
        super(properties);
        try {
            String string;
            this.url = this.getJdbcUrl(properties);
            ((Hashtable)properties).put("jdbc_url", this.url);
            Object object = ((Hashtable)properties).keys();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                if (!string.startsWith("sql.")) continue;
                ((Hashtable)this.connectionConfig).put(string.substring(4), properties.getProperty(string).trim());
            }
            if (((Hashtable)this.connectionConfig).get("autoReconnect") == null) {
                this.connectionConfig.setProperty("autoReconnect", "true");
            }
            object = properties.getProperty("sql.driver");
            string = properties.getProperty("addUnderscore");
            if (string != null) {
                this.addUnderscore = string.equals("true");
            }
            if (object == null) {
                object = sqlDrivers.getProperty(this.url.substring(5, this.url.indexOf(58, 6)));
            }
            MakumbaSystem.getMakumbaLogger("db.init").info("$Name: makumba-0_5_5_23 $ ".substring(7) + this.url);
            Class.forName((String)object);
            this.initConnections();
            DBConnectionWrapper dBConnectionWrapper = (DBConnectionWrapper)this.getDBConnection();
            SQLDBConnection sQLDBConnection = (SQLDBConnection)dBConnectionWrapper.getWrapped();
            try {
                ((Hashtable)properties).put("sql_engine.name", sQLDBConnection.getMetaData().getDatabaseProductName().trim());
                ((Hashtable)properties).put("sql_engine.version", sQLDBConnection.getMetaData().getDatabaseProductVersion().trim());
                ((Hashtable)properties).put("jdbc_driver.name", sQLDBConnection.getMetaData().getDriverName().trim());
                ((Hashtable)properties).put("jdbc_driver.version", sQLDBConnection.getMetaData().getDriverVersion().trim());
                MakumbaSystem.getMakumbaLogger("db.init").info("\tconnected to " + ((Hashtable)properties).get("sql_engine.name") + " version: " + ((Hashtable)properties).get("sql_engine.version") + "\n\tusing " + ((Hashtable)properties).get("jdbc_driver.name") + " version: " + ((Hashtable)properties).get("jdbc_driver.version") + "\n\tusing DBSV " + ((Hashtable)properties).get("dbsv"));
                this.readCatalog(sQLDBConnection);
            }
            finally {
                Object var7_7 = null;
                dBConnectionWrapper.close();
            }
        }
        catch (Exception exception) {
            throw new MakumbaError(exception);
        }
    }

    static {
        try {
            sqlDrivers.load(ClassResource.get("org/makumba/db/sql/sqlEngines.properties").openStream());
        }
        catch (Exception exception) {
            throw new MakumbaError(exception);
        }
    }
}

