/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Level;
import org.makumba.MakumbaSystem;
import org.makumba.abstr.RecordParser;
import org.makumba.devel.SourceViewer;
import org.makumba.util.ClassResource;

public class LineViewer
implements SourceViewer {
    String realPath;
    String virtualPath;
    String contextPath;
    Reader reader;
    boolean lineNumbers;
    File dir;
    StringBuffer highlighted;
    int position;
    char current;
    String text;
    String pattern;

    public File getDirectory() {
        if (this.dir != null && this.dir.isDirectory()) {
            return this.dir;
        }
        return null;
    }

    public Reader getReader() {
        return this.reader;
    }

    void readFromURL(URL uRL) throws IOException {
        if (uRL == null) {
            throw new FileNotFoundException(this.virtualPath);
        }
        this.realPath = uRL.getFile();
        this.dir = new File(this.realPath);
        if (!this.dir.isDirectory()) {
            this.reader = new InputStreamReader(new FileInputStream(this.dir));
        }
    }

    public void parseText(PrintWriter printWriter) throws IOException {
        if (this.realPath != null && this.virtualPath != null) {
            printWriter.println("<html><head><title>" + this.virtualPath + " - source</title></head><body bgcolor=white><table width=\"100%\" bgcolor=\"lightblue\"><tr>");
            printWriter.print("<td><font size=+2><a href=\"" + this.virtualPath + "\"><font color=\"darkblue\">" + this.virtualPath + "</font></a></font><br>" + new File(this.realPath).getCanonicalPath() + "</td>");
            this.intro(printWriter);
            printWriter.println("</tr></table>");
        }
        LineNumberReader lineNumberReader = new LineNumberReader(this.reader);
        String string = null;
        while ((string = lineNumberReader.readLine()) != null) {
            this.parseLine(string);
            if (this.lineNumbers) {
                int n = lineNumberReader.getLineNumber();
                printWriter.print("<a name=\"" + n + "\"><font color=\"darkblue\">" + n + ":\t</font>");
            }
            this.printLine(printWriter, string);
        }
        this.footer(printWriter);
        this.reader.close();
    }

    void intro(PrintWriter printWriter) throws IOException {
    }

    void footer(PrintWriter printWriter) throws IOException {
    }

    void printLine(PrintWriter printWriter, String string) throws IOException {
        String string2 = this.getLineTag(string);
        if (string2 != null) {
            printWriter.print("<a name=\"" + string2 + "\">");
        }
        printWriter.print(this.highlighted);
        printWriter.print("<br>");
    }

    String getLineTag(String string) {
        return null;
    }

    void parseLine(String string) {
        this.highlighted = new StringBuffer();
        while (true) {
            int n;
            if ((n = string.indexOf(46)) == -1) {
                this.writeNonMdd(string);
                return;
            }
            int n2 = n;
            int n3 = string.length();
            while (--n2 > 0 && this.isMakumbaTypeChar(string.charAt(n2))) {
            }
            ++n2;
            while (++n < n3 && this.isMakumbaTypeChar(string.charAt(n))) {
            }
            String string2 = string.substring(n2, n);
            if (string2.equals("www.makumba.org")) {
                this.writeNonMdd(string.substring(0, n2));
                this.highlighted.append("<a href=\"http://www.makumba.org\">www.makumba.org</a>");
            } else {
                Class clazz = null;
                String string3 = null;
                URL uRL = null;
                URL uRL2 = null;
                uRL = RecordParser.findDataDefinition(string2, "mdd");
                if (uRL == null && (uRL2 = RecordParser.findDataDefinition(string2, "idd")) == null && (clazz = this.findClass(string2)) == null && (string3 = this.findPage(string2)) == null) {
                    this.writeNonMdd(string.substring(0, n));
                } else {
                    this.writeNonMdd(string.substring(0, n2));
                    if (uRL != null || uRL2 != null) {
                        this.highlighted.append("<a href=\"" + this.contextPath + "/dataDefinitions/").append(string2).append("\">").append(string2).append("</a>");
                    } else if (clazz != null) {
                        this.highlighted.append("<a href=\"" + this.contextPath + "/classes/").append(clazz.getName()).append("\">").append(string2).append("</a>");
                    } else if (string3 != null) {
                        this.highlighted.append("<a href=\"").append(string3);
                        if (string3.endsWith("jsp")) {
                            this.highlighted.append("x");
                        }
                        this.highlighted.append("\">").append(string2).append("</a>");
                    }
                }
            }
            if (n == n3) {
                return;
            }
            string = string.substring(n, n3);
        }
    }

    String findPage(String string) {
        return null;
    }

    Class findClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            return null;
        }
        if (ClassResource.get(clazz.getName().replace('.', '/') + ".java") != null) {
            return clazz;
        }
        return null;
    }

    boolean isMakumbaTypeChar(char c) {
        return c == '.' || Character.isJavaIdentifierPart(c) || c == '/';
    }

    void writeNonMdd(String string) {
        this.text = string;
        this.position = 0;
        while (this.position < string.length()) {
            this.current = this.text.charAt(this.position);
            this.treat();
            ++this.position;
        }
    }

    void treat() {
        this.htmlEscape();
    }

    void htmlEscape() {
        switch (this.current) {
            case '<': {
                this.highlighted.append("&lt;");
                break;
            }
            case '>': {
                this.highlighted.append("&gt;");
                break;
            }
            case '&': {
                this.highlighted.append("&amp;");
                break;
            }
            default: {
                this.highlighted.append(this.current);
            }
        }
    }

    boolean lookup(String string) {
        int n = string.length();
        try {
            if (this.position + n > this.text.length() || !this.text.substring(this.position, this.position + n).equals(string)) {
                return false;
            }
            this.pattern = string;
            return true;
        }
        catch (RuntimeException runtimeException) {
            MakumbaSystem.getMakumbaLogger("devel").log(Level.SEVERE, this.position + " " + n + " " + this.text.length(), runtimeException);
            throw runtimeException;
        }
    }

    void advance() {
        this.position += this.pattern.length() - 1;
    }

    public LineViewer(boolean bl) {
        this.lineNumbers = bl;
    }

    public LineViewer() {
        this(false);
    }

    public LineViewer(Reader reader) {
        this(false);
        this.reader = reader;
    }
}

