/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.makumba.LogicNotFoundException;
import org.makumba.abstr.Logic;
import org.makumba.devel.LineViewer;
import org.makumba.view.jsptaglib.MakumbaTag;

public class jspViewer
extends LineViewer {
    String logicPath;
    boolean hasLogic;
    HttpServlet sv;
    boolean inMak = false;
    boolean inQuotes = false;

    int extraLength() {
        return 1;
    }

    String findPage(String string) {
        if (string.startsWith("/")) {
            File file = new File(this.sv.getServletContext().getRealPath(string));
            if (file.exists()) {
                return this.contextPath + string;
            }
            return null;
        }
        File file = new File(this.realPath.substring(0, this.realPath.lastIndexOf(File.separatorChar)) + File.separatorChar + string.replace('/', File.separatorChar));
        if (file.exists()) {
            return string;
        }
        return null;
    }

    void writeSourceLink(PrintWriter printWriter) throws IOException {
        printWriter.print("<td align=\"center\" bgcolor=\"darkblue\"><font color=\"lightblue\">source</font></td>");
    }

    void writeProgLink(PrintWriter printWriter) throws IOException {
        printWriter.print("<td align=\"center\"><a href=\"" + this.contextPath + this.virtualPath + "xp\"><font color=\"darkblue\">outline</font></a></td>");
    }

    public void intro(PrintWriter printWriter) throws IOException {
        printWriter.print("<td align=\"center\"><a href=\"" + this.contextPath + this.virtualPath + "\"><font color=\"darkblue\">execute</fontmd></a></td>");
        this.writeSourceLink(printWriter);
        printWriter.print("<td align=\"center\"><a href=\"" + this.logicPath + "\"><font color=\"darkblue\">business logic" + (this.hasLogic ? "" : " (none)") + "</font></a></td>");
        String string = MakumbaTag.getLoginPage(this.virtualPath, (ServletConfig)this.sv);
        if (string != null) {
            printWriter.print("<td align=\"center\"><a href=\"" + this.contextPath + string + "x\"><font color=\"darkblue\">login page</font></a></td>");
        }
        this.writeProgLink(printWriter);
    }

    void treat() {
        if (this.lookup("<mak:") || this.lookup("</mak:")) {
            this.advance();
            this.inMak = true;
            this.highlighted.append("<span style=\"background:#eecccc\"><font color=green><b>&lt;" + this.pattern.substring(1));
            return;
        }
        if (this.inMak && this.inQuotes && this.lookup("\\\"")) {
            this.advance();
            this.highlighted.append(this.pattern);
            return;
        }
        switch (this.current) {
            case '\"': {
                if (this.inQuotes) {
                    this.highlighted.append("\"</font>");
                    this.inQuotes = false;
                    break;
                }
                super.treat();
                break;
            }
            case '>': {
                if (this.inMak && !this.inQuotes) {
                    this.inMak = false;
                    this.highlighted.append("&gt;</b></font></span>");
                    break;
                }
                super.treat();
                break;
            }
            default: {
                super.treat();
            }
        }
    }

    public jspViewer(HttpServletRequest httpServletRequest, HttpServlet httpServlet) throws Exception {
        super(true);
        this.sv = httpServlet;
        this.contextPath = httpServletRequest.getContextPath();
        String string = httpServletRequest.getServletPath();
        this.virtualPath = string.substring(0, httpServletRequest.getServletPath().length() - this.extraLength());
        this.realPath = httpServlet.getServletConfig().getServletContext().getRealPath(this.virtualPath);
        this.reader = new FileReader(this.realPath);
        string = string.substring(0, string.indexOf(".")) + ".jsp";
        this.logicPath = this.contextPath + "/logic" + string;
        this.hasLogic = !(Logic.getLogic(string) instanceof LogicNotFoundException);
    }
}

