/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.util.LongData;
import org.makumba.util.RuntimeWrappedException;

public class Text {
    public static int FILE_LIMIT;
    InputStream source;
    int len;
    LongData ld;

    public InputStream toBinaryStream() {
        if (this.source == null) {
            throw new MakumbaError("texts indicated by stream can only be consumed once");
        }
        if (this.ld != null) {
            try {
                return this.ld.getInputStream();
            }
            catch (IOException iOException) {
                throw new RuntimeWrappedException(iOException);
            }
        }
        InputStream inputStream = this.source;
        this.source = null;
        return inputStream;
    }

    public int length() {
        return this.len;
    }

    public static Text getText(Object object) {
        if (object instanceof Text) {
            return (Text)object;
        }
        if (object instanceof InputStream) {
            return new Text((InputStream)object);
        }
        if (object instanceof String) {
            return new Text((String)object);
        }
        if (object instanceof byte[]) {
            return new Text((byte[])object);
        }
        throw new InvalidValueException("unsupported type to make text of " + object.getClass());
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.len < FILE_LIMIT ? this.len : FILE_LIMIT);
        try {
            this.writeTo(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeWrappedException(iOException);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[this.len < FILE_LIMIT ? this.len : FILE_LIMIT];
        InputStream inputStream = this.toBinaryStream();
        try {
            int n;
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            Object var5_5 = null;
            outputStream.close();
            inputStream.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compare(InputStream inputStream) throws IOException {
        boolean bl;
        InputStream inputStream2;
        block5: {
            boolean bl2;
            block4: {
                inputStream2 = this.toBinaryStream();
                try {
                    int n = 0;
                    while (true) {
                        int n2;
                        block6: {
                            if ((n2 = inputStream.read()) != -1) break block6;
                        }
                        int n3 = inputStream2.read();
                        if (n2 != n3) {
                            MakumbaSystem.getMakumbaLogger("debug.abstr").severe(n3 + " " + n2 + " " + n);
                            bl2 = false;
                            Object var4_8 = null;
                            break block4;
                        }
                        ++n;
                    }
                    bl = inputStream2.read() == -1;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_10 = null;
                    inputStream.close();
                    inputStream2.close();
                    throw throwable;
                }
            }
            inputStream.close();
            inputStream2.close();
            return bl2;
        }
        Object var4_9 = null;
        inputStream.close();
        inputStream2.close();
        return bl;
    }

    public Text(InputStream inputStream, int n) {
        this.source = inputStream;
        this.len = n;
    }

    public Text(InputStream inputStream) {
        try {
            this.ld = new LongData();
            this.ld.appendFrom(inputStream);
            this.source = this.ld.getInputStream();
            this.len = this.ld.getLength();
        }
        catch (IOException iOException) {
            throw new RuntimeWrappedException(iOException);
        }
    }

    public Text(String string) {
        this(string.getBytes());
    }

    public Text(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public Text(byte[] byArray, int n, int n2) {
        this.len = n2;
        try {
            this.ld = new LongData();
            this.ld.appendFrom(new ByteArrayInputStream(byArray, n, n2));
            this.source = this.ld.getInputStream();
        }
        catch (IOException iOException) {
            throw new RuntimeWrappedException(iOException);
        }
    }

    static {
        String string = System.getProperty("makumba.long-content");
        FILE_LIMIT = string != null ? Integer.parseInt(string.trim()) : 32768;
    }
}

