///////////////////////////////
//  Makumba, Makumba tag library
//  Copyright (C) 2000-2003  http://www.makumba.org
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//  -------------
//  $Id: MakumbaTag.java,v 1.2 2003/02/27 15:22:37 stefan Exp $
//  $Name: makumba-0_5_5_27 $
/////////////////////////////////////

package org.makumba.view.jsptaglib2;
import org.makumba.util.*;
import java.util.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.servlet.http.*;

/** the ancestor of all makumba tags 
 * sets a framework for executing makumba tags in terms of treating exceptions, responding to forms, defining methods needed for subclasses that implement BodyTag
 * the static method makeTag builds a tag, once the tag name is available
*/
public abstract class MakumbaTag extends TagSupport
{
  /// ################### the main tag methods are implemented here, to do generic tasks such as 
  /// catching and treating exceptions uniformly, responding to forms, etc.

  /** if the makumba form in the previous page was not yet responded to, respond to it
   * then find the prototype of this tag and invoke doStartTag1()
   * if an exception comes up, take care of it
   */
  public int doStartTag() throws JspException
  {
    try{
      formResponse();
      return doStartTag1();
    }catch(Throwable t)
      { treatException(t); return SKIP_PAGE; }
  }

  /** execute doAfterBody1()
   * if an exception comes up, take care of it */
  public int doAfterBody() throws JspException
  {
    try{
      return doAfterBody1();
    }catch(Throwable t)
      { treatException(t); return SKIP_PAGE; }
  }

  /** execute doEndTag1()
   * if an exception comes up, take care of it */
  public int doEndTag() throws JspException
  {
    try{
      return doEndTag1();
    }catch(Throwable t)
      { treatException(t); return SKIP_PAGE; }
  }
  
  /** should be redefined by subclasses to do something meaningful */
  public int doStartTag1() throws JspException { return SKIP_BODY; }
  /** should be redefined by subclasses to do something meaningful */
  public int doAfterBody1() throws JspException { return SKIP_BODY; }
  /** should be redefined by subclasses to do something meaningful */
  public int doEndTag1() throws JspException { return EVAL_PAGE; }

  

  ////################## these will probably move to other classes 
  public void formResponse(){}
  public void treatException(Throwable t){}

  ///################# ---methods needed to implement the BodyTag interface. this class does not implement BodyTag but some of its subclasses will want to
  BodyContent bodyContent;

  /** Only for subclasses implementing BodyTag. init body, not used by MakumbaTags, defined to comply with the BodyTag interface */
  public void doInitBody(){ }

  /** Only for subclasses implementing BodyTag. set the body content */
  public void setBodyContent(BodyContent b) {
    bodyContent=b;
  }

  /**
   * Only for subclasses implementing BodyTag. Get current bodyContent.
   * @return the body content.
   */
  public BodyContent getBodyContent() {
    return bodyContent;
  }

  /**
   * Only for subclasses implementing BodyTag. Get surrounding out JspWriter
   * @return the enclosing JspWriter, from the bodyContent.
   */
  public JspWriter getPreviousOut() {
    return getBodyContent().getEnclosingWriter();
  }

  ///############ page analysis
  /** do analysis during page parsing. some tags may not set a prototype but still 
   * contribute to the page analysis */
  public void analyzeInPage(JspPageData pageData, Map attributes, List parents){}

  /** mark the end of the tag for analysis, especially for body tags */
  public void endAnalysis(JspPageData pageData){}


  /////######## a tag factory, to build tags during page analysis
  static String[][] tagClassesStrings={
    {"list", "QueryTag"},
    {"object", "ObjectTag"},
    {"value", "ValueTag"},
    {"form", "FormTag"},
    {"newForm", "NewTag"},
    {"addForm", "AddTag"},
    {"editForm", "EditTag"},
    {"input", "InputTag"},
    {"attribute", "AttributeTag"},
    {"response", "ResponseTag"},
    {"login", "LoginTag"},
    {"logout", "LogoutTag"}
  };
  
  /* copy tagClassesStrings to the tagClasses map */
  static Map tagClasses= new HashMap();
  static{
    for(int i=0; i<tagClassesStrings.length; i++)
      tagClasses.put(tagClassesStrings[i][0], tagClassesStrings[i][1]); 
  }
  
  /** make a makumba tag from the parsed information */
  static MakumbaTag makeTag(String tag)
  {
    String className= (String) tagClasses.get(tag);
    if(className==null)
      return null;
    MakumbaTag t=null;
    Throwable ex=null;
    try{
      t=(MakumbaTag)Class.forName(className).newInstance();
    }
    catch(InstantiationException e){ex=e;}
    catch(ClassNotFoundException f){ex=f;}
    catch(IllegalAccessException g){ex=g;}
    if(ex!=null)
      throw new RuntimeWrappedException(ex);
    return t;
  }



}
