/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.abstr;

import java.io.Serializable;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.abstr.Enumerator;
import org.makumba.abstr.FieldHandler;
import org.makumba.abstr.RecordInfo;
import org.makumba.abstr.RecordParser;
import org.makumba.abstr.dateHandler;
import org.makumba.abstr.intEnumerator;
import org.makumba.abstr.intType;
import org.makumba.abstr.ptrHandler;
import org.makumba.abstr.ptrIndexHandler;
import org.makumba.abstr.stringType;
import org.makumba.abstr.stringTypeFixed;
import org.makumba.abstr.subtableHandler;

public class FieldInfo
implements Serializable,
FieldDefinition {
    RecordInfo ri;
    String name;
    String type;
    boolean fixed;
    boolean notNull;
    Object defaultValue;
    String description;
    Object extra1;
    Object extra2;
    Object extra3;
    FieldHandler _defa;

    public RecordInfo getRecordInfo() {
        return this.ri;
    }

    public DataDefinition getDataDefinition() {
        return this.getRecordInfo();
    }

    public static FieldInfo getFieldInfo(String string, Object object, boolean bl) {
        if (object instanceof FieldInfo) {
            return new FieldInfo(string, (FieldInfo)object);
        }
        String string2 = ((String)object).trim();
        if (!bl || string2.indexOf(" ") == -1) {
            return new FieldInfo(string, string2);
        }
        string2 = string + "=" + string2;
        return new RecordParser().parse(string2).getField(string);
    }

    public boolean compatible(FieldInfo fieldInfo) {
        return this.defa().compatible(fieldInfo);
    }

    public String toString() {
        return this.defa().toString();
    }

    FieldHandler defa() {
        if (this._defa == null) {
            try {
                Class<?> clazz = Class.forName("org.makumba.abstr." + this.getType() + "Handler");
                this._defa = (FieldHandler)clazz.newInstance();
                this._defa.fi = this;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this._defa;
    }

    public Object checkValue(Object object) {
        return this.defa().checkValue(object);
    }

    public void checkInsert(Dictionary dictionary) {
        this.defa().checkInsert(dictionary);
    }

    public void checkUpdate(Dictionary dictionary) {
        this.defa().checkUpdate(dictionary);
    }

    public Object getEmptyValue() {
        return null;
    }

    public String getName() {
        return this.getDataName();
    }

    public final String getDataName() {
        return this.name;
    }

    public boolean hasDescription() {
        return !this.description.equals(this.name);
    }

    public String getDescription() {
        if (this.description == null) {
            return this.name;
        }
        if (this.description.trim().equals("")) {
            return this.name;
        }
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getDataType() {
        return this.defa().getDataType();
    }

    public Class getJavaType() {
        return this.defa().getJavaType();
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return this.defa().getEmptyValue();
        }
        return this.defaultValue;
    }

    public Enumeration getValues() {
        return ((Enumerator)((Object)this.defa())).getValues();
    }

    public Enumeration getNames() {
        return ((Enumerator)((Object)this.defa())).getNames();
    }

    public int getEnumeratorSize() {
        return ((Enumerator)((Object)this.defa())).getEnumeratorSize();
    }

    public String getStringAt(int n) {
        return ((Enumerator)((Object)this.defa())).getStringAt(n);
    }

    public String getNameFor(int n) {
        return ((Enumerator)((Object)this.defa())).getNameFor(n);
    }

    public String getNameAt(int n) {
        return ((Enumerator)((Object)this.defa())).getNameAt(n);
    }

    public int getDefaultInt() {
        return ((intType)((Object)this.defa())).getDefaultInt();
    }

    public int getIntAt(int n) {
        return ((intEnumerator)((Object)this.defa())).getIntAt(n);
    }

    public String getDefaultString() {
        return ((stringType)((Object)this.defa())).getDefaultString();
    }

    public int getWidth() {
        return ((stringTypeFixed)((Object)this.defa())).getWidth();
    }

    public Date getDefaultDate() {
        return ((dateHandler)this.defa()).getDefaultDate();
    }

    public RecordInfo getForeignTable() {
        return ((ptrIndexHandler)this.defa()).getForeignTable();
    }

    public DataDefinition getRelationType() {
        return this.getForeignTable();
    }

    public RecordInfo getSubtable() {
        return ((subtableHandler)((Object)this.defa())).getSubtable();
    }

    public DataDefinition getSubtype() {
        return this.getSubtable();
    }

    public DataDefinition getPointedType() {
        return ((ptrIndexHandler)this.defa()).getPointedType();
    }

    public String getTitleField() {
        return ((ptrHandler)this.defa()).getTitleField();
    }

    public boolean hasTitleFieldIndicated() {
        return ((ptrHandler)this.defa()).hasTitleFieldIndicated();
    }

    public FieldInfo(RecordInfo recordInfo, String string) {
        this.ri = recordInfo;
        this.name = string;
    }

    public FieldInfo(FieldInfo fieldInfo) {
        this(fieldInfo.ri, fieldInfo.name);
        this.type = fieldInfo.type;
        this.fixed = fieldInfo.fixed;
        this.notNull = fieldInfo.notNull;
        this.defaultValue = fieldInfo.defaultValue;
        this.description = fieldInfo.description;
    }

    public FieldInfo(String string, FieldInfo fieldInfo) {
        this.name = string;
        this.type = fieldInfo.type;
        this.fixed = fieldInfo.fixed;
        this.notNull = fieldInfo.notNull;
        this.defaultValue = fieldInfo.defaultValue;
        this.description = fieldInfo.description;
        this.extra1 = fieldInfo.extra1;
        this.extra2 = fieldInfo.extra2;
        this.extra3 = fieldInfo.extra3;
        if (this.type.equals("ptrIndex")) {
            this.type = "ptr";
            this.extra1 = fieldInfo.getRecordInfo();
        }
    }

    public FieldInfo(String string, String string2) {
        try {
            this.name = string;
            this.type = string2;
            this.fixed = false;
            this.notNull = false;
            if (this.type.equals("char")) {
                this.extra2 = new Integer(255);
            } else if (this.type.startsWith("char")) {
                int n = this.type.indexOf("[");
                int n2 = this.type.indexOf("]");
                if (!this.type.endsWith("]") || this.type.substring(3, n).trim().length() > 1) {
                    throw new InvalidValueException("invalid char type " + this.type);
                }
                this.extra2 = new Integer(Integer.parseInt(this.type.substring(n + 1, n2)));
                this.type = "char";
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new InvalidValueException("bad type " + this.type);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException("bad char[] size " + this.type);
        }
    }
}

