/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.view.jsptaglib;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.view.InvalidValueException;
import org.makumba.view.dateFormatter;
import org.makumba.view.jsptaglib.FieldEditor;
import org.makumba.view.jsptaglib.HttpParameters;

public class dateEditor
extends FieldEditor {
    static String[] params = new String[]{"format"};
    static String[][] paramValues = new String[][]{null};
    static final String recognized = "dMyHms";
    static int[] lowLimits = new int[]{1, 0, -1, 0, 0, 0};
    static int[] hiLimits = new int[]{31, 11, -1, 23, 59, 59};
    static int[] components = new int[]{5, 2, 1, 11, 12, 13};

    public String[] getAcceptedParams() {
        return params;
    }

    public String[][] getAcceptedValue() {
        return paramValues;
    }

    String getNullName() {
        return this.getInputName() + "_null";
    }

    String getComponentName(int n) {
        return this.getInputName() + "_" + n;
    }

    public String format(Object object, Dictionary dictionary) {
        String string = (String)dictionary.get("format");
        if (string == null) {
            string = "dd MMMMM yyyy";
        }
        if (object == Pointer.NullDate) {
            object = null;
        }
        Date date = (Date)object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = "hidden".equals(dictionary.get("type"));
        if (date == null) {
            date = (Date)this.getDefaultValue();
            stringBuffer.append("<input type=hidden name=\"").append(this.getNullName()).append("\">");
        }
        int n = 0;
        while ((n = this.findNextFormatter(stringBuffer, string, n, bl)) != -1) {
            n = this.formatFrom(stringBuffer, date, string, n, bl);
        }
        return stringBuffer.toString();
    }

    void formatComponent(StringBuffer stringBuffer, Date date, String string, int n, boolean bl) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, MakumbaSystem.getLocale());
        simpleDateFormat.setCalendar(dateFormatter.calendar);
        String string2 = this.getComponentName(n);
        if (bl) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(MakumbaSystem.getTimeZone());
            gregorianCalendar.setTime(date);
            stringBuffer.append("<input type=\"hidden\" name=\"").append(string2).append("\" value=\"").append(gregorianCalendar.get(components[n])).append("\">");
        } else {
            String string3 = simpleDateFormat.format(date);
            if (lowLimits[n] == -1) {
                stringBuffer.append("<input type=\"text\" name=\"").append(string2).append("\" value=\"").append(string3).append("\" maxlength=\"").append(string.length()).append("\" size=\"").append(string.length()).append("\">");
            } else {
                stringBuffer.append("<select name=\"").append(string2).append("\">");
                GregorianCalendar gregorianCalendar = new GregorianCalendar(MakumbaSystem.getTimeZone());
                gregorianCalendar.clear();
                gregorianCalendar.set(1900, 0, 1);
                int n2 = lowLimits[n];
                while (n2 <= hiLimits[n]) {
                    gregorianCalendar.set(components[n], n2);
                    String string4 = simpleDateFormat.format(gregorianCalendar.getTime());
                    stringBuffer.append("<option value=\"").append(n2).append("\"");
                    if (string4.equals(string3)) {
                        stringBuffer.append(" selected");
                    }
                    stringBuffer.append(">").append(string4).append("</option>");
                    ++n2;
                }
                stringBuffer.append("</select>");
            }
        }
    }

    public Object readFrom(HttpParameters httpParameters) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(MakumbaSystem.getTimeZone());
        gregorianCalendar.clear();
        int n = 0;
        while (n < components.length) {
            String string = this.getComponentName(n);
            Object object = httpParameters.getParameter(string);
            if (object != null) {
                if (object instanceof Vector) {
                    throw new InvalidValueException(this, "multiple value not allowed for date component " + string);
                }
                int n2 = -1;
                try {
                    n2 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidValueException(this, "non-integer value not allowed for date component " + string + " : " + object);
                }
                gregorianCalendar.set(components[n], n2);
            }
            ++n;
        }
        Date date = gregorianCalendar.getTime();
        if (date.equals(this.getDefaultValue()) && httpParameters.getParameter(this.getNullName()) != null) {
            return null;
        }
        return date;
    }

    int formatFrom(StringBuffer stringBuffer, Date date, String string, int n, boolean bl) {
        int n2 = n;
        char c = string.charAt(n);
        while (++n < string.length() && string.charAt(n) == c) {
        }
        this.formatComponent(stringBuffer, date, string.substring(n2, n), recognized.indexOf(c), bl);
        return n;
    }

    int findNextFormatter(StringBuffer stringBuffer, String string, int n, boolean bl) {
        StringBuffer stringBuffer2 = null;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\'') {
                if (stringBuffer2 != null) {
                    if (stringBuffer2.length() == 0) {
                        if (!bl) {
                            stringBuffer.append('\'');
                        }
                        stringBuffer2 = null;
                    } else {
                        if (!bl) {
                            stringBuffer.append(stringBuffer2.toString());
                        }
                        stringBuffer2 = null;
                    }
                } else {
                    stringBuffer2 = new StringBuffer();
                }
            } else if (stringBuffer2 != null) {
                stringBuffer2.append(c);
            } else if (!Character.isLetter(c)) {
                if (!bl) {
                    stringBuffer.append(c);
                }
            } else {
                if (recognized.indexOf(c) == -1) {
                    throw new InvalidValueException(this, "unrecognized formatting letter '" + c + "' in date format string <" + string + ">");
                }
                return n;
            }
            ++n;
        }
        if (stringBuffer2 != null) {
            throw new InvalidValueException(this, "unterminated single quote in date format string <" + string + ">");
        }
        return -1;
    }
}

