/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.makumba.DBError;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.db.DBConnection;
import org.makumba.db.DBConnectionWrapper;
import org.makumba.db.Query;
import org.makumba.db.Update;
import org.makumba.db.sql.SQLDBConnection;
import org.makumba.db.sql.SQLPointer;
import org.makumba.db.sql.SQLUpdate;
import org.makumba.util.ClassResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Database
extends org.makumba.db.Database {
    static Properties sqlDrivers = new Properties();
    Properties connectionConfig;
    String url;
    String eng;
    Properties types;
    boolean addUnderscore;
    Hashtable catalog;
    static /* synthetic */ Class class$org$makumba$db$sql$RecordManager;

    public String getEngine() {
        return this.eng;
    }

    public static String getEngineProperty(String string) {
        return sqlDrivers.getProperty(string);
    }

    protected DBConnection makeDBConnection() {
        try {
            return new SQLDBConnection(this);
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException);
            throw new DBError(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readCatalog(SQLDBConnection sQLDBConnection) throws SQLException {
        SQLException sQLException = null;
        Hashtable hashtable = new Hashtable();
        boolean bl = false;
        try {
            ResultSet resultSet = sQLDBConnection.getMetaData().getColumns(null, null, "%", null);
            if (resultSet == null) {
                bl = true;
            } else {
                while (resultSet.next()) {
                    String string = resultSet.getString("TABLE_NAME");
                    Vector<Hashtable<String, Object>> vector = (Vector<Hashtable<String, Object>>)hashtable.get(string);
                    if (vector == null) {
                        vector = new Vector<Hashtable<String, Object>>();
                        hashtable.put(string, vector);
                    }
                    Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>(5);
                    hashtable2.put("COLUMN_NAME", resultSet.getString("COLUMN_NAME"));
                    hashtable2.put("DATA_TYPE", new Integer(resultSet.getInt("DATA_TYPE")));
                    hashtable2.put("TYPE_NAME", resultSet.getString("TYPE_NAME"));
                    hashtable2.put("COLUMN_SIZE", new Integer(resultSet.getInt("COLUMN_SIZE")));
                    vector.addElement(hashtable2);
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException2) {
            bl = true;
            sQLException = sQLException2;
        }
        if (bl) {
            MakumbaSystem.getMakumbaLogger("db.init").severe("failed to read catalog " + sQLException);
            return;
        }
        this.catalog = hashtable;
    }

    protected String getJdbcUrl(Properties properties) {
        String string = "jdbc:";
        this.eng = properties.getProperty("#sqlEngine");
        string = string + this.eng + ':';
        String string2 = Database.getEngineProperty(this.eng + ".localJDBC");
        if (string2 == null || !string2.equals("true")) {
            string = string + "//" + properties.getProperty("#host") + '/';
        }
        return string + properties.getProperty("#database");
    }

    public Query prepareQueryImpl(DBConnection dBConnection, String string) {
        return new org.makumba.db.sql.Query(dBConnection, string);
    }

    public Update prepareUpdateImpl(DBConnection dBConnection, String string, String string2, String string3) {
        return new SQLUpdate((SQLDBConnection)dBConnection, string, string2, string3);
    }

    public int getMinPointerValue() {
        return this.getDbsv() << SQLPointer.getMaskOrder();
    }

    public int getMaxPointerValue() {
        return (this.getDbsv() + 1 << SQLPointer.getMaskOrder()) - 1;
    }

    protected Class getTableClassConfigured() {
        try {
            String string = this.getConfiguration("tableclass");
            if (string != null || (string = sqlDrivers.getProperty(this.getConfiguration("#sqlEngine") + ".tableclass")) != null) {
                return Class.forName(string);
            }
            return this.getTableClass();
        }
        catch (Exception exception) {
            throw new MakumbaError(exception);
        }
    }

    protected Class getTableClass() {
        Class clazz = class$org$makumba$db$sql$RecordManager;
        if (clazz == null) {
            clazz = class$org$makumba$db$sql$RecordManager = Database.class$("[Lorg.makumba.db.sql.RecordManager;", false);
        }
        return clazz;
    }

    /*
     * Unable to fully structure code
     */
    public static String SQLEscape(String var0) {
        var1_1 = new StringBuffer("'");
        var2_2 = var0.length();
        var3_3 = 0;
        while (var3_3 < var2_2) {
            block5: {
                block4: {
                    block3: {
                        var4_4 = var0.charAt(var3_3);
                        if (var4_4 != '\'') break block3;
                        var1_1.append('\\');
                        ** GOTO lbl-1000
                    }
                    if (var4_4 != '\\') break block4;
                    var1_1.append('\\');
                    ** GOTO lbl-1000
                }
                if (var4_4 != '\"') break block5;
                var1_1.append('\\');
                ** GOTO lbl-1000
            }
            if (var4_4 == '\u0000') {
                var1_1.append("\\0");
            } else lbl-1000:
            // 4 sources

            {
                var1_1.append(var4_4);
            }
            ++var3_3;
        }
        var1_1.append('\'');
        return var1_1.toString();
    }

    protected String getTableName(String string) {
        return (this.addUnderscore ? string : "." + string.toLowerCase()).replace('.', '_').replace('(', '_').replace(')', '_').replace('>', '_').replace('-', '_') + (this.addUnderscore ? "_" : "");
    }

    protected String getFieldName(String string) {
        return (this.addUnderscore ? string : (string.startsWith("TS_") ? string : string.substring(0, 1).toLowerCase() + string.substring(1))).replace('.', '_') + (this.addUnderscore ? "_" : "");
    }

    protected void checkState(SQLException sQLException, String string) {
        this.checkState(sQLException, string, null);
    }

    protected void checkState(SQLException sQLException, String string, String string2) {
        string = sqlDrivers.getProperty(this.getConfiguration("#sqlEngine") + '.' + string);
        if (string != null && sQLException.getSQLState().equals(string)) {
            return;
        }
        MakumbaSystem.getMakumbaLogger("db.init.tablechecking").log(Level.SEVERE, sQLException.getSQLState(), sQLException);
        throw new DBError(sQLException, string2);
    }

    protected int exec(PreparedStatement preparedStatement) {
        try {
            MakumbaSystem.getMakumbaLogger("db.update.execution").fine(preparedStatement.toString());
            preparedStatement.execute();
            int n = preparedStatement.getUpdateCount();
            return n;
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException);
            throw new DBError(sQLException);
        }
    }

    static void logException(SQLException sQLException) {
        Database.logException(sQLException, null);
    }

    static void logException(SQLException sQLException, DBConnection dBConnection) {
        String string = "";
        if (dBConnection != null) {
            string = dBConnection.toString() + ' ';
        }
        SQLException sQLException2 = sQLException;
        while (sQLException2 != null) {
            string = string + sQLException2.getMessage() + " SQL state: " + sQLException2.getSQLState() + " error code :" + sQLException2.getErrorCode() + '\n';
            sQLException2 = sQLException2.getNextException();
        }
        MakumbaSystem.getMakumbaLogger("db.exception").warning(string);
    }

    public String OQLDate(Date date) {
        return "date\"" + new Timestamp(date.getTime()) + '\"';
    }

    public Pointer getPointer(String string, int n) {
        return new SQLPointer(string, this.getDbsv(), n);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.connectionConfig = new Properties();
        this.types = new Properties();
        this.addUnderscore = true;
        this.catalog = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Database(Properties properties) {
        super(properties);
        this.this();
        try {
            DBConnectionWrapper dBConnectionWrapper;
            this.url = this.getJdbcUrl(properties);
            properties.put("jdbc_url", this.url);
            Object object = properties.keys();
            while (true) {
                String string;
                if (!object.hasMoreElements()) {
                    if (this.connectionConfig.get("autoReconnect") == null) {
                        this.connectionConfig.setProperty("autoReconnect", "true");
                    }
                    object = properties.getProperty("sql.driver");
                    string = properties.getProperty("addUnderscore");
                    if (string != null) {
                        this.addUnderscore = string.equals("true");
                    }
                    if (object == null) {
                        object = sqlDrivers.getProperty(this.url.substring(5, this.url.indexOf(58, 6)));
                    }
                    MakumbaSystem.getMakumbaLogger("db.init").info("Makumba " + MakumbaSystem.getVersion() + " INIT: " + this.url);
                    Class.forName((String)object);
                    this.initConnections();
                    dBConnectionWrapper = (DBConnectionWrapper)this.getDBConnection();
                    SQLDBConnection sQLDBConnection = (SQLDBConnection)dBConnectionWrapper.getWrapped();
                    try {
                        properties.put("sql_engine.name", sQLDBConnection.getMetaData().getDatabaseProductName().trim());
                        properties.put("sql_engine.version", sQLDBConnection.getMetaData().getDatabaseProductVersion().trim());
                        properties.put("jdbc_driver.name", sQLDBConnection.getMetaData().getDriverName().trim());
                        properties.put("jdbc_driver.version", sQLDBConnection.getMetaData().getDriverVersion().trim());
                        MakumbaSystem.getMakumbaLogger("db.init").info("\tconnected to " + properties.get("sql_engine.name") + " version: " + properties.get("sql_engine.version") + "\n\tusing " + properties.get("jdbc_driver.name") + " version: " + properties.get("jdbc_driver.version") + "\n\tusing DBSV " + properties.get("dbsv"));
                        this.readCatalog(sQLDBConnection);
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        dBConnectionWrapper.close();
                        throw throwable;
                    }
                }
                string = (String)object.nextElement();
                if (!string.startsWith("sql.")) continue;
                this.connectionConfig.put(string.substring(4), properties.getProperty(string).trim());
            }
            {
                Object var7_9 = null;
                dBConnectionWrapper.close();
                return;
            }
        }
        catch (Exception exception) {
            throw new MakumbaError(exception);
        }
    }

    static {
        try {
            sqlDrivers.load(ClassResource.get("org/makumba/db/sql/sqlEngines.properties").openStream());
        }
        catch (Exception exception) {
            throw new MakumbaError(exception);
        }
    }
}

