/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Dictionary;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaSystem;
import org.makumba.abstr.FieldHandler;
import org.makumba.db.sql.Database;
import org.makumba.db.sql.RecordManager;
import org.makumba.db.sql.SQLDBConnection;

public abstract class FieldManager
extends FieldHandler {
    String dbname;
    RecordManager rm;

    protected String getDBType(Database database) {
        String string = Database.getEngineProperty(database.getEngine() + '.' + this.getDataType());
        if (string == null) {
            return this.getDBType();
        }
        return string;
    }

    protected String getDBType() {
        throw new RuntimeException(this.getClass() + "should be redefined");
    }

    protected int getSQLType() {
        throw new RuntimeException(this.getClass() + "should be redefined");
    }

    protected boolean unmodified(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        boolean bl = false;
        if (resultSetMetaData.getColumnType(n) == this.getSQLType()) {
            bl = true;
        }
        return bl;
    }

    protected boolean unmodified(int n, int n2, Vector vector, int n3) throws SQLException {
        boolean bl = false;
        if (n == this.getSQLType()) {
            bl = true;
        }
        return bl;
    }

    public String getDBName() {
        return this.dbname;
    }

    public String inCreate(Database database) {
        return this.getDBName() + ' ' + this.getDBType(database);
    }

    public String writeConstant(Object object) {
        if (object == this.getNull()) {
            return "null";
        }
        return this.toSQLObject(object).toString();
    }

    public Object toSQLObject(Object object) {
        return object;
    }

    public String inPreparedInsert() {
        return "?";
    }

    public String inPreparedUpdate() {
        return this.getDBName() + "=?";
    }

    public void setInsertArgument(PreparedStatement preparedStatement, int n, Dictionary dictionary) throws SQLException {
        Object v = dictionary.get(this.getDataName());
        if (v == null || v.equals(this.getNull())) {
            this.setNullArgument(preparedStatement, n);
        } else {
            this.setArgument(preparedStatement, n, v);
        }
    }

    public void setCopyArgument(PreparedStatement preparedStatement, int n, Dictionary dictionary) throws SQLException {
        try {
            Object v = dictionary.get(this.getDataName());
            if (v == null || v.equals(this.getNull())) {
                this.setNullArgument(preparedStatement, n);
            } else {
                this.setArgument(preparedStatement, n, v);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(this.getName() + ' ' + exception.getMessage());
        }
    }

    public void setUpdateArgument(PreparedStatement preparedStatement, int n, Dictionary dictionary) throws SQLException {
        this.setUpdateArgument(preparedStatement, n, dictionary.get(this.getDataName()));
    }

    public void setUpdateArgument(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        if (object == this.getNull()) {
            this.setNullArgument(preparedStatement, n);
        } else {
            try {
                this.setArgument(preparedStatement, n, object);
            }
            catch (SQLException sQLException) {
                MakumbaSystem.getMakumbaLogger("db.update.execution").log(Level.SEVERE, this.getDataName() + "  " + object.getClass(), sQLException);
                throw sQLException;
            }
        }
    }

    public void setArgument(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        preparedStatement.setObject(n, this.toSQLObject(object));
    }

    public void setNullArgument(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setNull(n, this.getSQLType());
    }

    public String inInsert(Dictionary dictionary) {
        try {
            return this.writeConstant(dictionary.get(this.getDataName()));
        }
        catch (NullPointerException nullPointerException) {
            return "null";
        }
    }

    public String inCopy(Dictionary dictionary) {
        return this.inInsert(dictionary);
    }

    public String inUpdate(Dictionary dictionary) {
        return this.getDBName() + '=' + this.writeConstant(dictionary.get(this.getDataName()));
    }

    public String inCondition(Dictionary dictionary, String string) {
        return this.getDBName() + string + this.writeConstant(dictionary.get(this.getDataName()));
    }

    public void onStartup(RecordManager recordManager, Properties properties, SQLDBConnection sQLDBConnection) throws SQLException {
        this.rm = recordManager;
        if (recordManager.alter && this.shouldIndex()) {
            try {
                Statement statement = sQLDBConnection.createStatement();
                statement.executeUpdate("CREATE INDEX " + recordManager.getDBName() + '_' + this.getDBName() + " ON " + recordManager.getDBName() + '(' + this.getDBName() + ')');
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public boolean shouldIndex() {
        return true;
    }

    public void setDBName(RecordManager recordManager, Properties properties) {
        String string = null;
        string = properties.getProperty(recordManager.getRecordInfo().getName() + '#' + this.getName());
        if (string == null) {
            string = recordManager.getSQLDatabase().getFieldName(this.getName());
            while (recordManager.checkDBName(string)) {
                string = string + '_';
            }
        }
        this.dbname = string;
    }

    public void setValue(Dictionary dictionary, ResultSet resultSet, int n) throws SQLException {
        Object object = this.getValue(resultSet, n);
        if (object != null) {
            dictionary.put(this.getDataName(), object);
        } else {
            dictionary.remove(this.getDataName());
        }
    }

    public void setValue(Object[] objectArray, ResultSet resultSet, int n) throws SQLException {
        objectArray[n] = this.getValue(resultSet, n);
    }

    public Object getValue(ResultSet resultSet, int n) throws SQLException {
        Object object = resultSet.getObject(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return object;
    }

    protected void checkCopy(String string) {
        if (!this.rm.admin) {
            throw new InvalidValueException(this.getFieldInfo(), "you cannot insert an " + string + " field unless the type " + this.rm.getRecordInfo().getName() + " has administration approval in the database connection file");
        }
    }
}

