/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaSystem;
import org.makumba.OQLAnalyzer;
import org.makumba.abstr.RecordInfo;
import org.makumba.db.DBConnection;
import org.makumba.db.DBConnectionWrapper;
import org.makumba.db.sql.Database;
import org.makumba.db.sql.ParameterAssigner;
import org.makumba.db.sql.RecordManager;
import org.makumba.db.sql.SQLDBConnection;
import org.makumba.db.sql.oql.QueryAST;
import org.makumba.util.ArrayMap;

public class Query
implements org.makumba.db.Query {
    DBConnection dbc;
    OQLAnalyzer tree;
    String query;
    RecordManager resultHandler;
    String command;
    ParameterAssigner assigner;

    public String getCommand() {
        return this.command;
    }

    public DataDefinition getResultType() {
        return this.tree.getProjectionType();
    }

    public DataDefinition getLabelType(String string) {
        return this.tree.getLabelType(string);
    }

    public Vector execute(Object[] objectArray) {
        PreparedStatement preparedStatement = ((SQLDBConnection)this.dbc).getPreparedStatement(this.command);
        try {
            String string = this.assigner.assignParameters(preparedStatement, objectArray);
            if (string != null) {
                throw new InvalidValueException("Errors while trying to assign arguments to query:\n" + this.command + '\n' + string);
            }
            Database database = (Database)this.dbc.getHostDatabase();
            MakumbaSystem.getMakumbaLogger("db.query.execution").fine("" + preparedStatement);
            Date date = new Date();
            ResultSet resultSet = null;
            try {
                resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException sQLException) {
                Database.logException(sQLException, this.dbc);
                throw new DBError(sQLException, this.command);
            }
            long l = new Date().getTime() - date.getTime();
            MakumbaSystem.getMakumbaLogger("db.query.performance").fine(l + " ms " + this.command);
            return this.goThru(resultSet, this.resultHandler);
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException);
        }
    }

    Vector goThru(ResultSet resultSet, RecordManager recordManager) {
        int n = recordManager.keyIndex.size();
        Vector<ArrayMap> vector = new Vector<ArrayMap>(100, 100);
        try {
            while (resultSet.next()) {
                Object[] objectArray = new Object[n];
                recordManager.fillResult(resultSet, objectArray);
                vector.addElement(new ArrayMap(recordManager.keyIndex, objectArray));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException, recordManager.getRecordInfo().getName());
        }
        return vector;
    }

    public Query(DBConnection dBConnection, String string) {
        this(dBConnection, MakumbaSystem.getOQLAnalyzer(string));
    }

    public Query(DBConnection dBConnection, OQLAnalyzer oQLAnalyzer) {
        this.tree = oQLAnalyzer;
        if (dBConnection instanceof DBConnectionWrapper) {
            dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
        }
        this.command = ((QueryAST)this.tree).writeInSQLQuery(dBConnection.getHostDatabase());
        this.dbc = dBConnection;
        this.resultHandler = (RecordManager)dBConnection.getHostDatabase().getTable((RecordInfo)this.getResultType());
        this.assigner = new ParameterAssigner(dBConnection, this.tree);
    }
}

