/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.makumba.DBError;
import org.makumba.DataTransformer;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.abstr.FieldHandler;
import org.makumba.abstr.RecordHandler;
import org.makumba.abstr.RecordInfo;
import org.makumba.db.DBConnection;
import org.makumba.db.Database;

public abstract class Table
extends RecordHandler {
    static final int BAR = 75;
    Database db;
    Hashtable relatedTables = new Hashtable();
    String selectAllWithDbsv;
    Object[] selectLimits = new Object[2];
    DataTransformer insertHook;

    public Database getDatabase() {
        return this.db;
    }

    protected void setRecordInfo(RecordInfo recordInfo) {
        super.setRecordInfo(recordInfo);
    }

    public Table getRelatedTable(String string) {
        return this.getDatabase().getTable((RecordInfo)this.relatedTables.get(string));
    }

    public Enumeration getRelatedTableFields() {
        return this.relatedTables.keys();
    }

    public abstract boolean canAdmin();

    public abstract boolean exists();

    public abstract int deleteFrom(DBConnection var1, DBConnection var2);

    public abstract boolean exists(String var1);

    void copyFrom(DBConnection dBConnection, Table table, DBConnection dBConnection2) {
        Serializable serializable;
        String string = this.getRecordInfo().getName();
        if (!table.exists() || string.equals("org.makumba.db.Catalog")) {
            return;
        }
        if (this.selectAllWithDbsv == null) {
            serializable = new StringBuffer();
            String string2 = "";
            Object object = this.handlerOrder.elements();
            while (object.hasMoreElements()) {
                ((StringBuffer)serializable).append(string2);
                string2 = ", ";
                String string3 = ((FieldHandler)object.nextElement()).getName();
                ((StringBuffer)serializable).append("t.").append(string3);
            }
            object = this.getRecordInfo().getIndexName();
            this.selectAllWithDbsv = "SELECT " + serializable + " FROM " + string + " t WHERE t." + (String)object + ">=$1 AND t." + (String)object + " <=$2";
            int n = dBConnection2.getHostDatabase().getDbsv();
            Table table2 = this;
            if (table2 == null) {
                throw null;
            }
            this.selectLimits[0] = new Pointer(table2, string, n){
                private final /* synthetic */ Table this$0;
                private final /* synthetic */ String val$nm;
                private final /* synthetic */ int val$dbsv;

                public String getType() {
                    return this.val$nm;
                }

                public long longValue() {
                    return this.val$dbsv << 24;
                }
                {
                    this.val$nm = string;
                    this.val$dbsv = n;
                    this.this$0 = table;
                    this.constructor$0(table);
                }

                private final void constructor$0(Table table) {
                }
            };
            Table table3 = this;
            if (table3 == null) {
                throw null;
            }
            this.selectLimits[1] = new Pointer(table3, string, n){
                private final /* synthetic */ Table this$0;
                private final /* synthetic */ String val$nm;
                private final /* synthetic */ int val$dbsv;

                public String getType() {
                    return this.val$nm;
                }

                public long longValue() {
                    return (this.val$dbsv + 1 << 24) - 1;
                }
                {
                    this.val$nm = string;
                    this.val$dbsv = n;
                    this.this$0 = table;
                    this.constructor$0(table);
                }

                private final void constructor$0(Table table) {
                }
            };
        }
        if (((Vector)(serializable = dBConnection2.executeQuery(this.selectAllWithDbsv, this.selectLimits))).size() == 0) {
            MakumbaSystem.getMakumbaLogger("db.admin.copy").info(string + ": no records to copy");
            return;
        }
        MakumbaSystem.getMakumbaLogger("db.admin.copy").info(string + ": starting copying " + ((Vector)serializable).size() + " records");
        System.out.print("|");
        int n = 0;
        while (n < 75) {
            System.out.print("-");
            ++n;
        }
        System.out.print("|\n ");
        System.out.flush();
        float f = (float)((Vector)serializable).size() / 75.0f;
        int n2 = 0;
        Hashtable hashtable = new Hashtable(23);
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>(23);
        int n3 = 0;
        while (n3 < this.handlerOrder.size()) {
            hashtable2.put("col" + (n3 + 1), ((FieldHandler)this.handlerOrder.elementAt(n3)).getName());
            ++n3;
        }
        n3 = 0;
        while (n3 < ((Vector)serializable).size()) {
            Dictionary dictionary = (Dictionary)((Vector)serializable).elementAt(n3);
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                hashtable.put(hashtable2.get(k), dictionary.get(k));
            }
            dBConnection.insert(this.getRecordInfo().getName(), hashtable);
            hashtable.clear();
            ((Vector)serializable).setElementAt(null, n3);
            int n4 = (int)(((float)n3 + 1.0f) / f);
            while (n4 > n2) {
                System.out.print("*");
                System.out.flush();
                ++n2;
            }
            ++n3;
        }
        System.out.println();
    }

    protected abstract void open(Properties var1);

    void computeInsertHook() {
        String string;
        if (this.insertHook == null && (string = this.getDatabase().getConfiguration("insert#" + this.getRecordInfo().getName())) != null) {
            try {
                this.insertHook = (DataTransformer)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new DBError(exception);
            }
        }
    }

    public Pointer insertRecord(DBConnection dBConnection, Dictionary dictionary) {
        return this.insertRecordImpl(dBConnection, dictionary);
    }

    public abstract Pointer insertRecordImpl(DBConnection var1, Dictionary var2);
}

