/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql.oql;

import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.collections.AST;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.OQLAnalyzer;
import org.makumba.abstr.FieldInfo;
import org.makumba.abstr.RecordInfo;
import org.makumba.db.Database;
import org.makumba.db.sql.FieldManager;
import org.makumba.db.sql.RecordManager;
import org.makumba.db.sql.oql.IdAST;
import org.makumba.db.sql.oql.OQLAST;
import org.makumba.db.sql.oql.ParamAST;
import org.makumba.db.sql.oql.Projection;

public class QueryAST
extends OQLAST
implements OQLAnalyzer {
    String originalQuery;
    AST fromAST;
    AST whereAST;
    AST groupAST;
    AST orderAST;
    AST afterWhereAST;
    AST firstProjection;
    QueryAST superQuery;
    String oneProjectionLabel;
    Vector projections = new Vector();
    Vector projectionLabels;
    Hashtable projectionLabelSearch = new Hashtable();
    Vector parameters = new Vector();
    RecordInfo resultInfo;
    RecordInfo paramInfo;
    Hashtable labels = new Hashtable();
    Hashtable aliases = new Hashtable();
    Vector joins = new Vector();
    Hashtable joinNames = new Hashtable();
    Vector expressions = new Vector();
    Vector expressionIdentifiers = new Vector();

    public void setOQL(String string) {
        this.originalQuery = string;
    }

    public String getOQL() {
        return this.originalQuery;
    }

    public void setFromAST(AST aST) {
        this.fromAST = aST;
    }

    public void setWhereAST(AST aST) {
        this.whereAST = aST;
    }

    public void setGroupAST(AST aST) {
        this.groupAST = aST;
        this.afterWhereAST = aST;
    }

    public void setOrderAST(AST aST) {
        this.orderAST = aST;
        if (this.groupAST == null) {
            this.afterWhereAST = aST;
        }
    }

    public void setSuperQuery(QueryAST queryAST) {
        this.superQuery = queryAST;
    }

    public QueryAST getSuperQuery() {
        return this.superQuery;
    }

    public void addProjection(Projection projection) {
        this.projections.addElement(projection);
        if (projection.as.length() > 0) {
            this.projectionLabelSearch.put(projection.as, projection);
        }
    }

    public void addParameter(ParamAST paramAST) {
        this.parameters.addElement(paramAST);
    }

    public int parameterNumber() {
        return this.parameters.size();
    }

    public int parameterAt(int n) {
        return ((ParamAST)((Object)this.parameters.elementAt((int)n))).number;
    }

    public DataDefinition getProjectionType() {
        if (this.oneProjectionLabel != null) {
            return (RecordInfo)this.labels.get(this.oneProjectionLabel);
        }
        return this.resultInfo;
    }

    public DataDefinition getParameterTypes() {
        return this.paramInfo;
    }

    public DataDefinition getLabelType(String string) {
        String string2 = (String)this.aliases.get(string);
        if (string2 != null) {
            string = string2;
        }
        return (RecordInfo)this.labels.get(string);
    }

    public void setOneProjection(String string) {
        this.oneProjectionLabel = string;
    }

    void computeProjectionTypes() throws RecognitionException {
        if (this.oneProjectionLabel != null) {
            if (this.labels.get(this.oneProjectionLabel) == null) {
                throw new SemanticException("undefined projection label: \"" + this.oneProjectionLabel + "\"");
            }
        } else {
            this.resultInfo = new RecordInfo();
            int n = 0;
            while (n < this.projections.size()) {
                Object object;
                Projection projection = (Projection)this.projections.elementAt(n);
                if (projection.as == null || projection.as.length() == 0) {
                    projection.as = "col" + (n + 1);
                }
                if ((object = projection.expr.getMakumbaType()) == null) {
                    System.out.println("\u0007\n\nno type computed for " + projection.expr.getText() + "\n\n");
                    object = "int";
                }
                if (object.toString().startsWith("set")) {
                    throw new SemanticException("You cannot select a set; projection \"" + projection.as + "\" with expression \"" + (Object)((Object)projection.expr) + "\" has type " + object);
                }
                this.resultInfo.addField(FieldInfo.getFieldInfo(projection.as, object, false));
                ++n;
            }
        }
    }

    public void computeParameterTypes() {
        if (this.parameters.size() == 0) {
            return;
        }
        this.paramInfo = new RecordInfo();
        int n = 0;
        while (n < this.parameters.size()) {
            ParamAST paramAST = (ParamAST)((Object)this.parameters.elementAt(n));
            this.paramInfo.addField(FieldInfo.getFieldInfo("param" + n, paramAST.makumbaType, false));
            ++n;
        }
    }

    String addJoin(String string, String string2, String string3, String string4, RecordInfo recordInfo) {
        QueryAST queryAST = this;
        if (queryAST == null) {
            throw null;
        }
        this.joins.addElement(queryAST.new Join(string, string2, string3, string4));
        this.joinNames.put(string + "." + string2, string3);
        this.labels.put(string3, recordInfo);
        return string3;
    }

    String join(String string, String string2, String string3) throws RecognitionException {
        String string4 = (String)this.joinNames.get(string + "." + string2);
        if (string4 != null) {
            return string4;
        }
        RecordInfo recordInfo = null;
        RecordInfo recordInfo2 = null;
        RecordInfo recordInfo3 = (RecordInfo)this.labels.get(string);
        String string5 = recordInfo3.getIndexName();
        FieldInfo fieldInfo = recordInfo3.getField(string2);
        if (fieldInfo == null) {
            throw new SemanticException("no such field \"" + string2 + "\" in makumba type \"" + recordInfo3.getName() + "\"");
        }
        try {
            recordInfo = fieldInfo.getForeignTable();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            recordInfo2 = fieldInfo.getSubtable();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string6 = string;
        if (string3 != null) {
            string6 = string3;
        }
        while (this.labels.get(string6) != null) {
            string6 = string6 + "x";
        }
        if (fieldInfo.getType().equals("ptr")) {
            return this.addJoin(string, string2, string6, recordInfo.getIndexName(), recordInfo);
        }
        if (fieldInfo.getType().equals("ptrOne")) {
            return this.addJoin(string, string2, string6, recordInfo2.getIndexName(), recordInfo2);
        }
        if (fieldInfo.getType().equals("setComplex") || fieldInfo.getType().equals("setintEnum") || fieldInfo.getType().equals("setcharEnum")) {
            return this.addJoin(string, string5, string6, string5, recordInfo2);
        }
        if (fieldInfo.getType().equals("set")) {
            string6 = string + "x";
            while (this.labels.get(string6) != null) {
                string6 = string6 + "x";
            }
            this.addJoin(string, string5, string6, string5, recordInfo2);
            this.labels.put(string6, recordInfo2);
            String string7 = string;
            if (string3 != null) {
                string7 = string3;
            }
            while (this.labels.get(string7) != null) {
                string7 = string7 + "x";
            }
            return this.addJoin(string6, recordInfo2.getForeignTablePointerName(), string7, recordInfo.getIndexName(), recordInfo);
        }
        throw new RecognitionException("\"" + string2 + "\" is not a set or pointer in makumba type \"" + recordInfo3.getName() + "\"");
    }

    public void addFrom(String string, String string2) throws RecognitionException {
        block10: {
            String string3 = string;
            RecordInfo recordInfo = null;
            try {
                recordInfo = RecordInfo.getRecordInfo(string3);
            }
            catch (DataDefinitionNotFoundError dataDefinitionNotFoundError) {
            }
            catch (DataDefinitionParseError dataDefinitionParseError) {
                throw new RecognitionException(dataDefinitionParseError.getMessage());
            }
            if (recordInfo != null) {
                this.labels.put(string2, recordInfo);
                return;
            }
            int n = string3.indexOf(46);
            if (n > 0) {
                String string4 = string3.substring(0, n);
                while (true) {
                    String string5;
                    if (this.labels.get(string4) == null) {
                        string5 = (String)this.aliases.get(string4);
                        if (string5 == null) {
                            throw new SemanticException("could not find type \"" + string + "\" or label \"" + string4 + "\"");
                        }
                        string4 = string5;
                    }
                    string5 = string3 = string3.substring(n + 1);
                    n = string3.indexOf(46);
                    if (n == -1) {
                        this.join(string4, string5, string2);
                        break block10;
                    }
                    string5 = string3.substring(0, n);
                    string4 = this.join(string4, string5, null);
                }
            }
            if (this.labels.get(string) == null) {
                throw new SemanticException("could not find type \"" + string + "\"");
            }
            this.aliases.put(string2, string);
        }
    }

    public void addExpression(AST aST) {
        this.expressions.addElement(aST);
    }

    void computeExpressionTypes() throws RecognitionException {
        Enumeration enumeration = this.expressions.elements();
        while (enumeration.hasMoreElements()) {
            OQLAST oQLAST = (OQLAST)((Object)enumeration.nextElement());
            oQLAST.getMakumbaType();
        }
    }

    public void addExpressionIdentifier(AST aST) {
        this.expressionIdentifiers.addElement(aST);
    }

    void treatExpressionIdentifiers() throws RecognitionException {
        Enumeration enumeration = this.expressionIdentifiers.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            RecordInfo recordInfo;
            String string2;
            AST aST = (AST)enumeration.nextElement();
            IdAST idAST = (IdAST)aST;
            idAST.query = this;
            String string3 = aST.getText();
            String string4 = null;
            String string5 = string3;
            int n = string3.indexOf(".");
            String string6 = string3;
            if (n != -1) {
                string6 = string3.substring(0, n);
            }
            if ((string2 = (String)this.aliases.get(string6)) != null) {
                string6 = string2;
            }
            if ((recordInfo = (RecordInfo)this.labels.get(string6)) == null) {
                if (n == -1 && this.projectionLabelSearch.get(string6) != null) {
                    boolean bl = true;
                    AST aST2 = aST;
                    while (aST2 != null) {
                        if (aST2 == this.afterWhereAST) {
                            bl = false;
                            break;
                        }
                        aST2 = aST2.getNextSibling();
                    }
                    if (bl) {
                        idAST.projectionLabel = string6;
                        continue;
                    }
                }
                throw new SemanticException("undefined label: \"" + string6 + "\"");
            }
            if (n != -1) {
                while (true) {
                    FieldInfo fieldInfo;
                    string4 = string3 = string3.substring(n + 1);
                    n = string3.indexOf(46);
                    if (n != -1) {
                        string4 = string3.substring(0, n);
                    }
                    if ((fieldInfo = recordInfo.getField(string4)) == null) {
                        throw new SemanticException("no such field \"" + string4 + "\" in makumba type \"" + recordInfo.getName() + "\"");
                    }
                    if ((fieldInfo.getType().equals("set") || fieldInfo.getType().equals("setComplex")) && n != -1) {
                        throw new SemanticException("set joins not allowed outside where clause; \"" + string5 + "\" contains reference to \"" + recordInfo.getName() + "->" + string4 + "\"");
                    }
                    if (n == -1) break;
                    string6 = this.join(string6, string4, null);
                    recordInfo = (RecordInfo)fieldInfo.getPointedType();
                }
            }
            idAST.label = string6;
            idAST.field = string4;
            if (idAST.field == null && recordInfo.isSubtable() && ((string = recordInfo.getMainTable().getField(recordInfo.getFieldName()).getType()).equals("setintEnum") || string.equals("setcharEnum"))) {
                idAST.field = "enum";
            }
            if (idAST.field == null) {
                idAST.field = recordInfo.getIndexName();
            }
            idAST.fieldInfo = recordInfo.getField(idAST.field);
            idAST.makumbaType = idAST.fieldInfo;
        }
    }

    protected void writeDistinct(Database database, StringBuffer stringBuffer) {
        if (this.getFirstChild().getText().toLowerCase().equals("distinct")) {
            stringBuffer.append(" DISTINCT ");
            this.firstProjection = this.getFirstChild().getNextSibling();
        } else {
            this.firstProjection = this.getFirstChild();
        }
    }

    protected void writeProjection(Database database, StringBuffer stringBuffer) {
        if (this.oneProjectionLabel != null) {
            stringBuffer.append(" ").append(this.oneProjectionLabel).append(".*");
        } else {
            AST aST = this.firstProjection;
            while (aST != this.fromAST) {
                stringBuffer.append(((OQLAST)aST).writeInSQLQuery(database));
                aST = aST.getNextSibling();
            }
        }
    }

    protected void writeFrom(Database database, StringBuffer stringBuffer) {
        boolean bl = false;
        Enumeration enumeration = this.labels.keys();
        while (enumeration.hasMoreElements()) {
            if (bl) {
                stringBuffer.append(",");
            }
            bl = true;
            String string = (String)enumeration.nextElement();
            stringBuffer.append(this.getTableName(string, database)).append(" ").append(string);
        }
    }

    protected String getTableName(String string, Database database) {
        RecordInfo recordInfo = (RecordInfo)this.labels.get(string);
        try {
            return ((RecordManager)database.getTable(recordInfo)).getDBName();
        }
        catch (NullPointerException nullPointerException) {
            return recordInfo.getName();
        }
    }

    protected String getFieldName(String string, String string2, Database database) {
        RecordInfo recordInfo = (RecordInfo)this.labels.get(string);
        try {
            return ((FieldManager)((RecordManager)database.getTable(recordInfo)).getFieldHandler(string2)).getDBName();
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    protected void writeJoins(Database database, StringBuffer stringBuffer) {
        boolean bl = false;
        Enumeration enumeration = this.joins.elements();
        while (enumeration.hasMoreElements()) {
            Join join = (Join)enumeration.nextElement();
            if (bl) {
                stringBuffer.append(" AND ");
            }
            bl = true;
            stringBuffer.append(join.label1).append(".").append(this.getFieldName(join.label1, join.field1, database)).append("= ").append(join.label2).append(".").append(this.getFieldName(join.label2, join.field2, database));
        }
    }

    protected void writeConditions(Database database, StringBuffer stringBuffer) {
        stringBuffer.append("(");
        AST aST = this.whereAST.getNextSibling();
        while (aST != this.afterWhereAST) {
            stringBuffer.append(" ").append(((OQLAST)aST).writeInSQLQuery(database));
            aST = aST.getNextSibling();
        }
        stringBuffer.append(")");
    }

    protected void writeAfterWhere(Database database, StringBuffer stringBuffer) {
        AST aST = this.afterWhereAST;
        while (aST != null) {
            stringBuffer.append(" ").append(((OQLAST)aST).writeInSQLQuery(database));
            aST = aST.getNextSibling();
        }
    }

    public void prepare() throws RecognitionException {
        this.treatExpressionIdentifiers();
        this.computeExpressionTypes();
        this.computeProjectionTypes();
        this.computeParameterTypes();
    }

    public String writeInSQLQuery(Database database) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        this.writeDistinct(database, stringBuffer);
        this.writeProjection(database, stringBuffer);
        stringBuffer.append(" FROM ");
        this.writeFrom(database, stringBuffer);
        boolean bl2 = bl = this.joins.size() > 0;
        if (this.whereAST != null || bl) {
            stringBuffer.append(" WHERE ");
            if (bl) {
                this.writeJoins(database, stringBuffer);
            }
            if (this.whereAST != null) {
                if (bl) {
                    stringBuffer.append(" AND ");
                }
                this.writeConditions(database, stringBuffer);
            }
        }
        this.writeAfterWhere(database, stringBuffer);
        return stringBuffer.toString();
    }

    public QueryAST() {
    }

    public QueryAST(Token token) {
        super(token);
    }

    class Join {
        String label1;
        String field1;
        String label2;
        String field2;

        public String toString() {
            return this.label1 + "." + this.field1 + " JOIN " + this.label2 + "." + this.field2;
        }

        public Join(String string, String string2, String string3, String string4) {
            this.label1 = string;
            this.label2 = string3;
            this.field1 = string2;
            this.field2 = string4;
        }
    }
}

