///////////////////////////////
//  Makumba, Makumba tag library
//  Copyright (C) 2000-2003  http://www.makumba.org
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//  -------------
//  $Id: SoftNamedResources.java,v 2.0 2003/05/20 23:00:06 cristi Exp $
//  $Name: makumba-0_5_9_16 $
/////////////////////////////////////

package org.makumba.util;
import java.util.*;
import java.lang.ref.SoftReference;

/** A NamedResources that keeps its resources as soft references
 *@see org.makumba.util.NamedResources
*/
public class SoftNamedResources extends NamedResources
{
  public SoftNamedResources(String name, NamedResourceFactory f)
    { super(name, f); }

  protected NameValue getNameValue(Object name, Object hash)
  {
    NameValue nv=null;
    SoftReference sr=(SoftReference)values.get(hash);
    final Object h= hash;
    if(sr==null || (nv=(NameValue)sr.get())==null)
      values.put(hash, new SoftReference(nv=new NameValue(name, hash, f))
		 {
		   // possible improvement: rather redefine get(), 
		   // if it returns null, re-make the resource?
		   public void clear()
		     { 
		       super.clear();
		       values.remove(h);
		     }
		 }); 
    return nv;
  }
}
