/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.abstr;

import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.abstr.Enumerator;
import org.makumba.abstr.FieldInfo;
import org.makumba.abstr.RecordHandler;
import org.makumba.abstr.RecordInfo;
import org.makumba.abstr.dateHandler;
import org.makumba.abstr.intEnumerator;
import org.makumba.abstr.intType;
import org.makumba.abstr.ptrHandler;
import org.makumba.abstr.ptrIndexHandler;
import org.makumba.abstr.ptrRelHandler;
import org.makumba.abstr.stringType;
import org.makumba.abstr.stringTypeFixed;
import org.makumba.abstr.subtableHandler;

public abstract class FieldHandler {
    FieldInfo fi;
    FieldHandler defa;

    public FieldInfo getFieldInfo() {
        return this.fi;
    }

    public void setFieldInfo(FieldInfo fieldInfo) {
        try {
            this.fi = fieldInfo;
            Class<?> clazz = Class.forName("org.makumba.abstr." + this.getType() + "Handler");
            if (clazz.isInstance(this)) {
                this.defa = this;
                return;
            }
            this.defa = (FieldHandler)clazz.newInstance();
            this.defa.fi = fieldInfo;
            this.defa.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void init() {
    }

    public boolean isAssignableFrom(FieldInfo fieldInfo) {
        boolean bl = false;
        if (fieldInfo.getType().equals("nil") || this.getType().equals(fieldInfo.getType())) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.getType();
    }

    public Object checkValue(Object object) {
        if (!object.equals(this.getNull())) {
            return this.checkValueImpl(object);
        }
        return object;
    }

    public Object checkValueImpl(Object object) {
        return this.defa.checkValueImpl(object);
    }

    protected Object normalCheck(Object object) {
        if (!this.getJavaType().isInstance(object)) {
            throw new InvalidValueException((FieldDefinition)this.getFieldInfo(), this.getJavaType(), object);
        }
        return object;
    }

    public void checkInsert(Dictionary dictionary) {
        Object v = dictionary.get(this.getName());
        if (this.isNotNull() && (v == null || v.equals(this.getNull()))) {
            throw new InvalidValueException(this.getFieldInfo(), "A non-null value is needed for notnull fields");
        }
        if (v != null) {
            dictionary.put(this.getName(), this.checkValue(v));
        }
    }

    public void checkUpdate(Dictionary dictionary) {
        Object v = dictionary.get(this.getName());
        if (v == null) {
            return;
        }
        if (this.isFixed()) {
            throw new InvalidValueException(this.getFieldInfo(), "You cannot update a fixed field");
        }
        dictionary.put(this.getName(), this.checkValue(v));
    }

    Object getEmptyValue() {
        return null;
    }

    public Object replaceIn(RecordHandler recordHandler) {
        return this;
    }

    public String getName() {
        return this.getDataName();
    }

    public final String getDataName() {
        return this.fi.name;
    }

    public boolean hasDescription() {
        return this.fi.description.equals(this.fi.name) ^ true;
    }

    public String getDescription() {
        return this.fi.description;
    }

    public String getType() {
        return this.fi.type;
    }

    public String getDataType() {
        return this.defa.getDataType();
    }

    public Class getJavaType() {
        return this.defa.getJavaType();
    }

    public Object getNull() {
        return this.defa.getNull();
    }

    public boolean isFixed() {
        return this.fi.fixed;
    }

    public boolean isNotNull() {
        return this.fi.notNull;
    }

    public boolean isUnique() {
        return this.fi.unique;
    }

    public Object getDefaultValue() {
        if (this.fi.defaultValue == null) {
            return this.defa.getEmptyValue();
        }
        return this.fi.defaultValue;
    }

    public Enumeration getValues() {
        return ((Enumerator)((Object)this.defa)).getValues();
    }

    public Vector getDeprecatedValues() {
        return ((Enumerator)((Object)this.defa)).getDeprecatedValues();
    }

    public Enumeration getNames() {
        return ((Enumerator)((Object)this.defa)).getNames();
    }

    public int getEnumeratorSize() {
        return ((Enumerator)((Object)this.defa)).getEnumeratorSize();
    }

    public String getStringAt(int n) {
        return ((Enumerator)((Object)this.defa)).getStringAt(n);
    }

    public String getNameAt(int n) {
        return ((Enumerator)((Object)this.defa)).getNameAt(n);
    }

    public String getNameFor(int n) {
        return ((Enumerator)((Object)this.defa)).getNameFor(n);
    }

    public int getDefaultInt() {
        return ((intType)((Object)this.defa)).getDefaultInt();
    }

    public int getIntAt(int n) {
        return ((intEnumerator)((Object)this.defa)).getIntAt(n);
    }

    public String getDefaultString() {
        return ((stringType)((Object)this.defa)).getDefaultString();
    }

    public int getWidth() {
        return ((stringTypeFixed)((Object)this.defa)).getWidth();
    }

    public Date getDefaultDate() {
        return ((dateHandler)this.defa).getDefaultDate();
    }

    public RecordInfo getForeignTable() {
        return ((ptrRelHandler)this.defa).getForeignTable();
    }

    public RecordInfo getSubtable() {
        return ((subtableHandler)((Object)this.defa)).getSubtable();
    }

    public RecordInfo getPointedType() {
        return ((ptrIndexHandler)this.defa).getPointedType();
    }

    public String getTitleField() {
        return ((ptrHandler)this.defa).getTitleField();
    }

    public boolean hasTitleFieldIndicated() {
        return ((ptrHandler)this.defa).hasTitleFieldIndicated();
    }
}

