/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import org.makumba.DBError;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.OQLAnalyzer;
import org.makumba.OQLParseError;
import org.makumba.db.DBConnection;
import org.makumba.db.Update;
import org.makumba.db.sql.Database;
import org.makumba.db.sql.ParameterAssigner;
import org.makumba.db.sql.SQLDBConnection;
import org.makumba.db.sql.oql.QueryAST;

public class SQLUpdate
implements Update {
    ParameterAssigner assigner;
    String debugString;
    DBConnection dbc;
    String updateCommand;

    public int execute(Object[] objectArray) {
        PreparedStatement preparedStatement = ((SQLDBConnection)this.dbc).getPreparedStatement(this.updateCommand);
        try {
            int n;
            String string = this.assigner.assignParameters(preparedStatement, objectArray);
            if (string != null) {
                throw new InvalidValueException("Errors while trying to assign arguments to update:\n" + this.debugString + '\n' + string);
            }
            Database database = (Database)this.dbc.getHostDatabase();
            MakumbaSystem.getMakumbaLogger("db.update.execution").fine("" + preparedStatement);
            Date date = new Date();
            try {
                n = preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                Database.logException(sQLException);
                throw new DBError(sQLException, this.debugString);
            }
            long l = new Date().getTime() - date.getTime();
            MakumbaSystem.getMakumbaLogger("db.update.performance").fine(l + " ms " + this.debugString);
            return n;
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException);
        }
    }

    SQLUpdate(SQLDBConnection sQLDBConnection, String string, String string2, String string3) {
        int n;
        String string4;
        OQLAnalyzer oQLAnalyzer;
        String string5;
        this.debugString = (string2 == null ? "delete" : "update") + " on type: <" + string + '>' + (string2 == null ? " " : " setting: <" + string2 + '>') + " where: <" + string3 + '>';
        this.dbc = sQLDBConnection;
        if (string2 != null && string2.trim().length() == 0) {
            throw new OQLParseError("Invalid empty update 'set' section in " + this.debugString);
        }
        if (string3 != null && string3.trim().length() == 0) {
            string3 = null;
        }
        try {
            string5 = string.substring(string.trim().indexOf(32) + 1).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new OQLParseError("Invalid delete/update 'type' section: " + string);
        }
        String string6 = "SELECT " + (string2 == null ? string5 : string2) + " FROM " + string;
        if (string3 != null) {
            string6 = string6 + " WHERE " + string3;
        }
        try {
            oQLAnalyzer = MakumbaSystem.getOQLAnalyzer(string6);
            this.assigner = new ParameterAssigner(sQLDBConnection, oQLAnalyzer);
        }
        catch (OQLParseError oQLParseError) {
            throw new OQLParseError(oQLParseError.getMessage() + "\r\nin " + this.debugString + '\n' + string6, oQLParseError);
        }
        try {
            string4 = ((QueryAST)oQLAnalyzer).writeInSQLQuery(sQLDBConnection.getHostDatabase());
        }
        catch (RuntimeException runtimeException) {
            throw new MakumbaError(this.debugString + '\n' + string6);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (true) {
            n = ++n2;
            if ((n2 = string4.indexOf(string5, n2)) == -1) break;
            stringBuffer.append(string4.substring(n, n2));
            if (string4.charAt(n2 += string5.length()) != '.') continue;
        }
        stringBuffer.append(string4.substring(n));
        string4 = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(string2 == null ? "DELETE FROM" : "UPDATE");
        stringBuffer2.append(string4.substring(string4.indexOf("FROM") + 4, string4.indexOf("WHERE")));
        if (string2 != null) {
            String string7 = string4.substring(string4.indexOf("SELECT") + 6, string4.indexOf("FROM"));
            n2 = 0;
            while ((n2 = string7.indexOf("is null", n2)) != -1) {
                string7 = string7.substring(0, n2) + " = null" + string7.substring(n2 + 7);
            }
            stringBuffer2.append("SET ").append(string7);
        }
        if (string3 != null) {
            stringBuffer2.append(string4.substring(string4.indexOf("WHERE")));
        }
        this.debugString = this.debugString + "\n generated SQL: " + stringBuffer2;
        this.updateCommand = stringBuffer2.toString();
    }
}

