/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Dictionary;
import java.util.Properties;
import org.makumba.InvalidValueException;
import org.makumba.Pointer;
import org.makumba.db.sql.RecordManager;
import org.makumba.db.sql.SQLDBConnection;
import org.makumba.db.sql.SQLPointer;
import org.makumba.db.sql.ptrDBManager;

public class ptrIndexJavaManager
extends ptrDBManager {
    long n;
    int dbsv;

    protected void reset() {
        this.n = this.rm.getSQLDatabase().getMinPointerValue();
    }

    protected String getPtrType() {
        return this.getFieldInfo().getRecordInfo().getName();
    }

    public void onStartup(RecordManager recordManager, Properties properties, SQLDBConnection sQLDBConnection) throws SQLException {
        super.onStartup(recordManager, properties, sQLDBConnection);
        this.dbsv = recordManager.getSQLDatabase().getDbsv();
        Statement statement = sQLDBConnection.createStatement();
        this.reset();
        ResultSet resultSet = statement.executeQuery("SELECT MAX(" + this.getDBName() + "), COUNT(" + this.getDBName() + ") FROM " + recordManager.tbname + " WHERE " + this.getDBName() + ">=" + this.n + " AND " + this.getDBName() + "<=" + recordManager.getSQLDatabase().getMaxPointerValue());
        resultSet.next();
        if (resultSet.getLong(2) > 0L) {
            this.n = resultSet.getLong(1);
        }
        resultSet.close();
        statement.close();
    }

    SQLPointer nxt(Dictionary dictionary) {
        SQLPointer sQLPointer = new SQLPointer(this.getPtrType(), this.nextId());
        dictionary.put(this.getName(), sQLPointer);
        return sQLPointer;
    }

    public void checkInsert(Dictionary dictionary) {
        Object v = dictionary.get(this.getName());
        if (v != null) {
            this.checkCopy("index");
            dictionary.put(this.getName(), this.checkValue(v));
        }
    }

    public void checkUpdate(Dictionary dictionary) {
        Object v = dictionary.get(this.getName());
        if (v != null) {
            throw new InvalidValueException(this.getFieldInfo(), "you cannot update an index pointer");
        }
    }

    public void setInsertArgument(PreparedStatement preparedStatement, int n, Dictionary dictionary) throws SQLException {
        Pointer pointer = (Pointer)dictionary.get(this.getName());
        if (pointer != null) {
            super.setInsertArgument(preparedStatement, n, dictionary);
            if (pointer.getDbsv() == this.dbsv && pointer.longValue() > this.n) {
                this.n = pointer.longValue();
            }
            return;
        }
        preparedStatement.setInt(n, (int)this.nxt(dictionary).longValue());
    }

    public String inInsert(Dictionary dictionary) {
        Pointer pointer = (Pointer)dictionary.get(this.getName());
        if (pointer != null) {
            if (pointer.getDbsv() == this.dbsv && pointer.longValue() > this.n) {
                this.n = pointer.longValue();
            }
            return super.inInsert(dictionary);
        }
        return "" + this.nxt(dictionary).longValue();
    }

    public void setCopyArgument(PreparedStatement preparedStatement, int n, Dictionary dictionary) throws SQLException {
        super.setCopyArgument(preparedStatement, n, dictionary);
    }

    public String inCopy(Dictionary dictionary) {
        return super.inInsert(dictionary);
    }

    public String inUpdate(Dictionary dictionary) {
        throw new RuntimeException("shouldn't be called");
    }

    public void setUpdateArgument(PreparedStatement preparedStatement, int n, Dictionary dictionary) {
        throw new RuntimeException("shouldn't be called");
    }

    protected synchronized long nextId() {
        return ++this.n;
    }
}

