/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.util;

public abstract class SyntaxPoint
implements Comparable {
    int position;
    boolean begin;
    int line;
    int column;

    public int getPosition() {
        return this.position;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean isBegin() {
        return this.begin;
    }

    public abstract String getType();

    public Object getOtherInfo() {
        return null;
    }

    public static SyntaxPoint makeEnd(SyntaxPoint syntaxPoint, int n) {
        return new End(syntaxPoint, n);
    }

    public int compareTo(Object object) {
        SyntaxPoint syntaxPoint = (SyntaxPoint)object;
        int n = this.position - syntaxPoint.position;
        if (n != 0) {
            return n;
        }
        if (this.begin == syntaxPoint.begin) {
            if (syntaxPoint.getType().equals("TextLine")) {
                return syntaxPoint.begin ? 1 : -1;
            }
            if (this.getType().equals("TextLine")) {
                return this.begin ? -1 : 1;
            }
            return this.getType().compareTo(syntaxPoint.getType());
        }
        return this.begin ? 1 : -1;
    }

    public boolean equals(Object object) {
        SyntaxPoint syntaxPoint = (SyntaxPoint)object;
        boolean bl = false;
        if (syntaxPoint != null && this.position == syntaxPoint.position && this.begin == syntaxPoint.begin && this.getType() == syntaxPoint.getType()) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.position * this.getType().hashCode() * (this.begin ? 1 : -1);
    }

    public String toString() {
        return "" + this.position + ':' + (this.begin ? "<" + this.getType() : this.getType() + '>');
    }

    public SyntaxPoint(int n, boolean bl) {
        this.position = n;
        this.begin = bl;
    }

    public SyntaxPoint(int n) {
        this.position = n;
        this.begin = true;
    }

    public static class End
    extends SyntaxPoint {
        SyntaxPoint begin;

        public Object getOtherInfo() {
            return this.begin;
        }

        public String getType() {
            return this.begin.getType();
        }

        public End(SyntaxPoint syntaxPoint, int n) {
            super(n, false);
            this.begin = syntaxPoint;
        }
    }
}

