///////////////////////////////
//  Makumba, Makumba tag library
//  Copyright (C) 2000-2003  http://www.makumba.org
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//  -------------
//  $Id: intEnumPrinter.java,v 2.2 2003/10/11 04:19:34 stefan Exp $
//  $Name: makumba-0_5_9_18 $
/////////////////////////////////////

package org.makumba.abstr.printer;

public class intEnumPrinter extends FieldPrinter
{
   public String valueToString()
   { 
      String ret= super.valueToString() +" {";
      for(java.util.Enumeration e= getValues(), f= getNames()
      ; e.hasMoreElements(); )
      {
	Integer val=(Integer)e.nextElement();
        ret+= " \""+f.nextElement()+"\"="
	   +val
	   +(getDeprecatedValues().contains(val)?" deprecated":"")
	   +(e.hasMoreElements()?",":"");
      }        
      return ret+"}";
   }
}
