/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.makumba.DBError;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.abstr.FieldHandler;
import org.makumba.db.DBConnection;
import org.makumba.db.DBConnectionWrapper;
import org.makumba.db.Table;
import org.makumba.db.sql.Database;
import org.makumba.db.sql.FieldManager;
import org.makumba.db.sql.SQLDBConnection;
import org.makumba.db.sql.ptrIndexJavaManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RecordManager
extends Table {
    protected String tbname;
    protected String handlerList;
    protected String indexDBField;
    protected String indexField;
    boolean alter;
    boolean exists_;
    Hashtable handlerExist;
    Dictionary keyIndex;
    String preparedInsertString;
    String preparedDeleteString;
    String preparedDeleteFromString;
    boolean admin;

    public boolean exists() {
        return this.exists_;
    }

    public boolean exists(String string) {
        boolean bl = false;
        if (this.handlerExist.get(string) != null) {
            bl = true;
        }
        return bl;
    }

    public String getDBName() {
        return this.tbname;
    }

    protected Database getSQLDatabase() {
        return (Database)this.getDatabase();
    }

    protected boolean usesHidden() {
        return true;
    }

    protected String getTmpName() {
        return "tmp" + this.tbname;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void open(Properties properties) {
        this.setTableAndFieldNames(properties);
        if (this.getRecordInfo().isTemporary()) {
            this.keyIndex = this.getRecordInfo().getKeyIndex();
            return;
        }
        DBConnectionWrapper dBConnectionWrapper = (DBConnectionWrapper)this.getSQLDatabase().getDBConnection();
        SQLDBConnection sQLDBConnection = (SQLDBConnection)dBConnectionWrapper.getWrapped();
        try {
            this.checkStructure(sQLDBConnection, properties);
            this.initFields(sQLDBConnection, properties);
            this.preparedInsertString = this.prepareInsert();
            this.preparedDeleteString = this.prepareDelete();
            this.preparedDeleteFromString = "DELETE FROM " + this.getDBName() + " WHERE " + this.indexDBField + " >= ? AND " + this.indexDBField + " <= ?";
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dBConnectionWrapper.close();
            throw throwable;
        }
        {
            Object var5_6 = null;
            dBConnectionWrapper.close();
            return;
        }
    }

    protected void setTableAndFieldNames(Properties properties) {
        Object[] objectArray = new Object[]{this, properties};
        this.tbname = properties.getProperty(this.getRecordInfo().getName());
        if (this.tbname == null) {
            String string = Database.findConfig(properties, this.getRecordInfo().getName());
            String string2 = this.getRecordInfo().getName();
            if (string != null) {
                string2 = properties.getProperty(string) + this.getRecordInfo().getName().substring(string.length());
            }
            this.tbname = this.getSQLDatabase().getTableName(string2);
        } else if (this.tbname.indexOf(46) != -1) {
            this.tbname = this.getSQLDatabase().getTableName(this.tbname);
        }
        try {
            this.callAll(this.getHandlerMethod("setDBName"), objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MakumbaError(invocationTargetException.getTargetException());
        }
    }

    public boolean canAdmin() {
        return this.admin;
    }

    protected void checkStructure(SQLDBConnection sQLDBConnection, Properties properties) {
        String string = Database.findConfig(properties, "admin#" + this.getRecordInfo().getName());
        boolean bl = false;
        if (string != null && properties.getProperty(string).trim().equals("true")) {
            bl = true;
        }
        this.admin = bl;
        string = Database.findConfig(properties, "alter#" + this.getRecordInfo().getName());
        boolean bl2 = false;
        if (string != null && properties.getProperty(string).trim().equals("true")) {
            bl2 = true;
        }
        this.alter = bl2;
        MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info(this.getDatabase().getConfiguration() + ": checking " + this.getRecordInfo().getName() + " as " + this.tbname);
        try {
            Statement statement = sQLDBConnection.createStatement();
            CatalogChecker catalogChecker = null;
            if (this.getSQLDatabase().catalog == null) {
                throw new MakumbaError(this.getDatabase().getName() + ": could not open catalog");
            }
            catalogChecker = new CatalogChecker(this.getSQLDatabase().catalog);
            if (catalogChecker.shouldCreate()) {
                this.create(statement, this.tbname, this.alter);
                this.exists_ = this.alter;
                properties.put("makumba.wasCreated", "");
                this.keyIndex = this.getRecordInfo().getKeyIndex();
            } else {
                this.exists_ = true;
                this.alter(statement, catalogChecker);
            }
            catalogChecker.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new DBError(sQLException);
        }
    }

    protected void initFields(SQLDBConnection sQLDBConnection, Properties properties) {
        Object[] objectArray = new Object[]{this, properties, sQLDBConnection};
        try {
            this.callAll(this.getHandlerMethod("onStartup"), objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (this.alter) {
                throw new MakumbaError(invocationTargetException.getTargetException());
            }
            MakumbaSystem.getMakumbaLogger("db.init.tablechecking").severe("unusable table: " + this.getRecordInfo().getName());
        }
        StringBuffer stringBuffer = new StringBuffer();
        RecordManager.fieldList(stringBuffer, this.handlerOrder.elements());
        this.handlerList = stringBuffer.toString();
        this.indexField = this.getRecordInfo().getIndexName();
        this.indexDBField = ((FieldManager)this.handlers.get(this.indexField)).getDBName();
    }

    public int deleteFrom(DBConnection dBConnection, DBConnection dBConnection2) {
        if (!this.exists()) {
            return 0;
        }
        if (!this.canAdmin()) {
            throw new MakumbaError("no administration approval for " + this.getRecordInfo().getName());
        }
        if (dBConnection instanceof DBConnectionWrapper) {
            dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
        }
        PreparedStatement preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(this.preparedDeleteFromString);
        try {
            preparedStatement.setInt(1, dBConnection2.getHostDatabase().getMinPointerValue());
            preparedStatement.setInt(2, dBConnection2.getHostDatabase().getMaxPointerValue());
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException);
            throw new DBError(sQLException);
        }
        int n = this.getSQLDatabase().exec(preparedStatement);
        ((ptrIndexJavaManager)this.handlers.get(this.indexField)).reset();
        return n;
    }

    protected void alter(Statement statement, CheckingStrategy checkingStrategy) throws SQLException {
        Object object;
        Object object2;
        Vector<FieldManager> vector = new Vector<FieldManager>();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<FieldManager> vector3 = new Vector<FieldManager>();
        Vector<Object> vector4 = new Vector<Object>();
        Object object3 = new Object();
        while (checkingStrategy.hasMoreColumns()) {
            object2 = checkingStrategy.columnName();
            boolean bl = false;
            object = this.handlerOrder.elements();
            while (object.hasMoreElements()) {
                FieldManager fieldManager = (FieldManager)object.nextElement();
                if (!fieldManager.getDBName().toLowerCase().equals(((String)object2).toLowerCase())) continue;
                this.handlerExist.put(fieldManager.getName(), object3);
                vector.addElement(fieldManager);
                if (!(checkingStrategy.checkColumn(fieldManager) || this.alter && this.alter(statement, fieldManager, "MODIFY"))) {
                    MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("should modify: " + fieldManager.getDataName() + ' ' + fieldManager.getDBName() + ' ' + fieldManager.getDBType() + ' ' + checkingStrategy.columnType() + ' ' + checkingStrategy.columnName());
                    vector3.addElement(fieldManager);
                }
                bl = true;
            }
            if (bl) continue;
            vector4.addElement(object2);
            MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("extra field: " + checkingStrategy.columnName() + ' ' + checkingStrategy.columnType() + ' ' + checkingStrategy.columnTypeName());
        }
        object2 = new Vector();
        this.keyIndex = new Hashtable();
        Enumeration enumeration = this.handlerOrder.elements();
        while (enumeration.hasMoreElements()) {
            object = (FieldManager)enumeration.nextElement();
            if (!(this.handlerExist.get(((FieldHandler)object).getName()) != null || this.alter && this.alter(statement, (FieldManager)object, "ADD"))) {
                vector2.addElement(object);
                MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("should add " + ((FieldHandler)object).getDataName() + ' ' + ((FieldManager)object).getDBName() + ' ' + ((FieldManager)object).getDBType());
                continue;
            }
            this.keyIndex.put(((FieldHandler)object).getName(), new Integer(((Vector)object2).size()));
            ((Vector)object2).addElement(object);
        }
        this.handlerOrder = object2;
        this.doAlter(statement, vector4, vector, vector2, vector3);
    }

    boolean alter(Statement statement, FieldManager fieldManager, String string) throws SQLException {
        String string2 = "ALTER TABLE " + this.getDBName() + ' ' + string + ' ' + fieldManager.inCreate(this.getSQLDatabase());
        MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info(this.getSQLDatabase().getConfiguration() + ": " + string2);
        try {
            statement.executeUpdate("DROP INDEX " + this.getDBName() + '_' + fieldManager.getDBName() + " ON " + this.getDBName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.executeUpdate(string2);
        this.handlerExist.put(fieldManager.getName(), "");
        return true;
    }

    protected void doAlter(Statement statement, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws SQLException {
        if (vector3.size() == 0 && vector4.size() == 0) {
            return;
        }
        if (vector2.size() == 0) {
            this.create(statement, this.tbname, this.alter);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cp(Statement statement, String string, String string2, String string3, Vector vector) throws SQLException {
        DBConnectionWrapper dBConnectionWrapper = (DBConnectionWrapper)this.getSQLDatabase().getDBConnection();
        SQLDBConnection sQLDBConnection = (SQLDBConnection)dBConnectionWrapper.getWrapped();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT " + string3 + " FROM " + string);
            Statement statement2 = sQLDBConnection.createStatement();
            int n = resultSet.getMetaData().getColumnCount() + 1;
            block8: while (true) {
                block11: {
                    if (resultSet.next()) break block11;
                    statement2.close();
                    resultSet.close();
                    break;
                }
                StringBuffer stringBuffer = new StringBuffer().append("INSERT INTO ").append(string2).append("(").append(string3).append(") VALUES (");
                String string4 = null;
                int n2 = 1;
                while (true) {
                    if (n2 >= n) {
                        stringBuffer.append(")");
                        MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info(stringBuffer.toString());
                        statement2.executeUpdate(stringBuffer.toString());
                        continue block8;
                    }
                    try {
                        stringBuffer.append(string4.toString());
                    }
                    catch (NullPointerException nullPointerException) {
                        string4 = ", ";
                    }
                    try {
                        FieldManager fieldManager = (FieldManager)vector.elementAt(n2 - 1);
                        stringBuffer.append(fieldManager.writeConstant(fieldManager.getValue(resultSet, n2)));
                    }
                    catch (NullPointerException nullPointerException) {
                        stringBuffer.append("null");
                    }
                    catch (ClassCastException classCastException) {
                        stringBuffer.append("null");
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var9_19 = null;
            dBConnectionWrapper.close();
            throw throwable;
        }
        {
            Object var9_20 = null;
            dBConnectionWrapper.close();
            return;
        }
    }

    protected void create(Statement statement, String string, boolean bl) throws SQLException {
        Object[] objectArray = new Object[]{this.getSQLDatabase()};
        if (bl) {
            try {
                statement.executeUpdate("DROP TABLE " + string);
            }
            catch (SQLException sQLException) {
                this.getSQLDatabase().checkState(sQLException, "tableMissing");
            }
        }
        try {
            String string2 = "CREATE TABLE " + string + '(' + this.concatAll(this.getHandlerMethod("inCreate"), objectArray, ",") + ')';
            if (!bl) {
                MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("would be:\n" + string2);
                return;
            }
            MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info(string2);
            statement.executeUpdate(string2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DBError(invocationTargetException.getTargetException());
        }
    }

    protected static void fieldList(StringBuffer stringBuffer, Enumeration enumeration) {
        String string = "";
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(((FieldManager)enumeration.nextElement()).getDBName());
        }
    }

    boolean checkDBName(String string) {
        Enumeration enumeration = this.handlerOrder.elements();
        while (enumeration.hasMoreElements()) {
            FieldManager fieldManager = (FieldManager)enumeration.nextElement();
            if (fieldManager.getDBName() == null || !fieldManager.getDBName().toLowerCase().equals(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected String prepareInsert() {
        Object[] objectArray = new Object[]{};
        try {
            return "INSERT INTO " + this.tbname + " (" + this.handlerList + ") VALUES (" + this.concatAll(this.getHandlerMethod("inPreparedInsert"), objectArray, ",") + ')';
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MakumbaError(invocationTargetException.getTargetException());
        }
    }

    public Pointer insertRecordImpl(DBConnection dBConnection, Dictionary dictionary) {
        boolean bl = false;
        if (dictionary.get(this.indexField) != null) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (dictionary.get("TS_create") != null) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if (dictionary.get("TS_create") != null) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        try {
            if (dBConnection instanceof DBConnectionWrapper) {
                dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
            }
            PreparedStatement preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(this.preparedInsertString);
            int n = 0;
            Object object = this.handlerOrder.elements();
            while (object.hasMoreElements()) {
                ++n;
                FieldManager fieldManager = (FieldManager)object.nextElement();
                try {
                    fieldManager.setInsertArgument(preparedStatement, n, dictionary);
                }
                catch (Throwable throwable) {
                    throw new DBError(throwable, "insert into " + this.getRecordInfo().getName() + " at field " + fieldManager.getName() + " could not assign value \"" + dictionary.get(fieldManager.getName()) + "\" of type " + dictionary.get(fieldManager.getName()) != null ? dictionary.get(fieldManager.getName()).getClass().getName() : "");
                }
            }
            this.getSQLDatabase().exec(preparedStatement);
            object = (Pointer)dictionary.get(this.indexField);
            if (!bl2) {
                dictionary.remove(this.indexField);
            }
            if (!bl4) {
                dictionary.remove("TS_create");
            }
            if (!bl6) {
                dictionary.remove("TS_modify");
            }
            return object;
        }
        catch (Throwable throwable) {
            throw new DBError(throwable);
        }
    }

    protected String prepareDelete() {
        return "DELETE FROM " + this.tbname + " WHERE " + ((FieldManager)this.handlers.get(this.indexField)).inPreparedUpdate();
    }

    public void deleteRecord(DBConnection dBConnection, Pointer pointer) {
        if (dBConnection instanceof DBConnectionWrapper) {
            dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
        }
        PreparedStatement preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(this.preparedDeleteString);
        try {
            ((FieldManager)this.handlers.get(this.indexField)).setUpdateArgument(preparedStatement, 1, pointer);
            this.getSQLDatabase().exec(preparedStatement);
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException);
            throw new DBError(sQLException);
        }
    }

    public void updateRecord(DBConnection dBConnection, Pointer pointer, Dictionary dictionary) {
        Object object;
        if (dBConnection instanceof DBConnectionWrapper) {
            dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
        }
        dictionary.remove(this.indexField);
        dictionary.remove("TS_create");
        dictionary.put("TS_modify", new Date());
        StringBuffer stringBuffer = new StringBuffer("UPDATE ").append(this.tbname).append(" SET ");
        String string = "";
        Object object2 = dictionary.keys();
        while (object2.hasMoreElements()) {
            Object k;
            if (string.length() > 0) {
                stringBuffer.append(",");
            }
            if ((object = (FieldManager)this.handlers.get(k = object2.nextElement())) == null) {
                throw new DBError(new Exception("no such field " + k + " in " + this.getRecordInfo().getName()));
            }
            string = ((FieldManager)object).inPreparedUpdate();
            stringBuffer.append(string);
        }
        stringBuffer.append(" WHERE " + ((FieldManager)this.handlers.get(this.indexField)).inPreparedUpdate());
        try {
            object2 = ((SQLDBConnection)dBConnection).getPreparedStatement(stringBuffer.toString());
            int n = 1;
            object = dictionary.keys();
            while (object.hasMoreElements()) {
                ((FieldManager)this.handlers.get(object.nextElement())).setUpdateArgument((PreparedStatement)object2, n, dictionary);
                ++n;
            }
            ((FieldManager)this.handlers.get(this.indexField)).setUpdateArgument((PreparedStatement)object2, n, pointer);
            this.getSQLDatabase().exec((PreparedStatement)object2);
            return;
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException);
        }
    }

    protected void fillResult(ResultSet resultSet, Dictionary dictionary) throws SQLException {
        int n = this.handlerOrder.size();
        int n2 = 0;
        while (n2 < n) {
            ((FieldManager)this.handlerOrder.elementAt(n2)).setValue(dictionary, resultSet, ++n2);
        }
    }

    protected void fillResult(ResultSet resultSet, Object[] objectArray) throws SQLException {
        int n = this.handlerOrder.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                objectArray[n2] = ((FieldManager)this.handlerOrder.elementAt(n2)).getValue(resultSet, n2 + 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                MakumbaSystem.getMakumbaLogger("db.query.execution").log(Level.SEVERE, "" + n2 + ' ' + this.getRecordInfo().getName() + ' ' + this.getRecordInfo().getKeyIndex() + ' ' + this.handlerOrder, arrayIndexOutOfBoundsException);
                throw arrayIndexOutOfBoundsException;
            }
            ++n2;
        }
    }

    public Object getValue(ResultSet resultSet, String string, int n) {
        try {
            return ((FieldManager)this.getFieldHandler(string)).getValue(resultSet, n);
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException);
        }
    }

    private final /* synthetic */ void this() {
        this.handlerExist = new Hashtable();
    }

    public RecordManager() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CatalogChecker
    implements CheckingStrategy {
        Vector columns;
        Hashtable column;
        int i;

        public boolean shouldCreate() {
            boolean bl = false;
            if (this.columns == null) {
                bl = true;
            }
            return bl;
        }

        public boolean hasMoreColumns() throws SQLException {
            if (this.i < this.columns.size()) {
                this.column = (Hashtable)this.columns.elementAt(this.i);
                ++this.i;
                return true;
            }
            return false;
        }

        public String columnName() throws SQLException {
            return (String)this.column.get("COLUMN_NAME");
        }

        public int columnType() throws SQLException {
            return (Integer)this.column.get("DATA_TYPE");
        }

        public int columnSize() throws SQLException {
            return (Integer)this.column.get("COLUMN_SIZE");
        }

        public String columnTypeName() throws SQLException {
            return (String)this.column.get("TYPE_NAME");
        }

        public boolean checkColumn(FieldManager fieldManager) throws SQLException {
            return fieldManager.unmodified(this.columnType(), this.columnSize(), this.columns, this.i);
        }

        public void close() {
        }

        private final /* synthetic */ void this() {
            this.i = 0;
        }

        CatalogChecker(Hashtable hashtable) throws SQLException {
            this.this();
            this.columns = (Vector)hashtable.get(RecordManager.this.tbname);
            if (this.columns == null) {
                this.columns = (Vector)hashtable.get(RecordManager.this.tbname.toLowerCase());
                if (this.columns == null) {
                    this.columns = (Vector)hashtable.get(RecordManager.this.tbname.toUpperCase());
                    if (this.columns != null) {
                        RecordManager.this.tbname = RecordManager.this.tbname.toUpperCase();
                    }
                } else {
                    RecordManager.this.tbname = RecordManager.this.tbname.toLowerCase();
                }
            }
        }
    }

    static interface CheckingStrategy {
        public void close() throws SQLException;

        public boolean hasMoreColumns() throws SQLException;

        public String columnName() throws SQLException;

        public int columnType() throws SQLException;

        public String columnTypeName() throws SQLException;

        public boolean checkColumn(FieldManager var1) throws SQLException;

        public boolean shouldCreate() throws SQLException;
    }
}

