/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller.http;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.makumba.MakumbaError;
import org.makumba.UnauthorizedException;
import org.makumba.controller.http.AllowedException;
import org.makumba.controller.http.RequestAttributes;
import org.makumba.controller.http.Responder;

public class ControllerFilter
implements Filter {
    public static final String ORIGINAL_REQUEST = "org.makumba.originalRequest";
    static FilterConfig conf;

    public void init(FilterConfig filterConfig) {
        conf = filterConfig;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        boolean bl = this.shouldFilter((HttpServletRequest)servletRequest);
        if (bl) {
            try {
                RequestAttributes.getAttributes((HttpServletRequest)servletRequest);
            }
            catch (Throwable throwable) {
                ControllerFilter.treatException(throwable, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
                return;
            }
            Responder.response((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            if (ControllerFilter.wasException((HttpServletRequest)servletRequest)) {
                return;
            }
        }
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (AllowedException allowedException) {
            // empty catch block
        }
    }

    public boolean shouldFilter(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI();
        if (string.startsWith("/dataDefinitions") || string.startsWith("/logic") || string.startsWith("/classes")) {
            return false;
        }
        String string2 = null;
        try {
            string2 = new URL(httpServletRequest.getRequestURL().toString()).getFile();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (string2.endsWith(".jsp") || string2.endsWith(".html")) {
            return true;
        }
        if (string2.endsWith(".jspx")) {
            return false;
        }
        File file = new File(conf.getServletContext().getRealPath(httpServletRequest.getRequestURI()));
        if (file.isDirectory()) {
            return true;
        }
        return !file.exists();
    }

    public void destroy() {
    }

    public static void treatException(Throwable throwable, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType("text/html");
        httpServletRequest.setAttribute("javax.servlet.jsp.jspException", (Object)throwable);
        if (!(httpServletRequest.getAttribute("org.makumba.exceptionTreated") != null || throwable instanceof UnauthorizedException && ControllerFilter.login(httpServletRequest, httpServletResponse))) {
            try {
                httpServletRequest.getRequestDispatcher("/servlet/org.makumba.devel.TagExceptionServlet").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
                throw new MakumbaError(throwable2);
            }
        }
        ControllerFilter.setWasException(httpServletRequest);
        httpServletRequest.setAttribute("org.makumba.exceptionTreated", (Object)"yes");
    }

    public static void setWasException(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("org.makumba.wasException", (Object)"yes");
    }

    public static boolean wasException(HttpServletRequest httpServletRequest) {
        return "yes".equals(httpServletRequest.getAttribute("org.makumba.wasException"));
    }

    public static String getLoginPage(String string) {
        String string2 = conf.getServletContext().getRealPath("/");
        String string3 = "/";
        String string4 = "/login.jsp";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            if (new File(string2 + "login.jsp").exists()) {
                string4 = string3 + "login.jsp";
            }
            String string5 = stringTokenizer.nextToken() + "/";
            string2 = string2 + string5;
            string3 = string3 + string5;
        }
        if (new File(string2 + "login.jsp").exists()) {
            string4 = string3 + "login.jsp";
        }
        return string4;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean login(HttpServletRequest var0, HttpServletResponse var1_1) {
        var2_2 = ControllerFilter.getLoginPage(var0.getServletPath());
        if (var2_2 != null) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            var0 = (HttpServletRequest)((HttpServletRequestWrapper)var0).getRequest();
lbl5:
            // 2 sources

            ** while (var0 instanceof HttpServletRequestWrapper)
        }
lbl6:
        // 1 sources

        var0.setAttribute("org.makumba.originalRequest", (Object)var0);
        try {
            var0.getRequestDispatcher(var2_2).forward((ServletRequest)var0, (ServletResponse)var1_1);
        }
        catch (Throwable var3_3) {
            var3_3.printStackTrace();
            return false;
        }
        return true;
    }
}

