/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.importer;

import java.io.File;
import java.io.FileReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.makumba.Database;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.abstr.FieldHandler;
import org.makumba.abstr.RecordHandler;
import org.makumba.abstr.RecordInfo;
import org.makumba.importer.FieldImporter;
import org.makumba.util.ClassResource;

public class RecordImporter
extends RecordHandler {
    Properties markers = new Properties();
    boolean noMarkers = false;

    public String getMarker(String string) {
        return this.markers.getProperty(string);
    }

    Object getValue(String string, String string2, Database database, Pointer[] pointerArray) {
        FieldImporter fieldImporter = (FieldImporter)this.handlers.get(string);
        if (fieldImporter.isIgnored()) {
            return null;
        }
        return fieldImporter.getValue(fieldImporter.replace(string2), database, pointerArray);
    }

    protected boolean isMarked(FieldImporter fieldImporter) {
        if (fieldImporter.isMarked()) {
            return true;
        }
        if (this.noMarkers) {
            String string = fieldImporter.begin;
            fieldImporter.begin = "x";
            boolean bl = fieldImporter.isMarked();
            fieldImporter.begin = string;
            return bl;
        }
        return false;
    }

    protected boolean usesHidden() {
        return true;
    }

    public Dictionary importFrom(String string, Database database, Pointer[] pointerArray) {
        Object[] objectArray = new Object[]{new Hashtable(), string, database, pointerArray};
        Method method = this.getHandlerMethod("importTo");
        try {
            this.callAll(method, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
        }
        return (Dictionary)objectArray[0];
    }

    public static void main(String[] stringArray) throws Throwable {
        RecordImporter recordImporter = new RecordImporter(RecordInfo.getRecordInfo(stringArray[0]));
        File file = new File(stringArray[1]);
        String[] stringArray2 = file.list();
        char[] cArray = new char[8196];
        int n = 0;
        while (n < stringArray2.length) {
            int n2;
            MakumbaSystem.getMakumbaLogger("import").finest(stringArray2[n]);
            FileReader fileReader = new FileReader(new File(file, stringArray2[n]));
            StringWriter stringWriter = new StringWriter();
            while ((n2 = fileReader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n2);
            }
            String string = stringWriter.toString().toString();
            MakumbaSystem.getMakumbaLogger("import").finest(recordImporter.importFrom(string, null, null).toString());
            ++n;
        }
    }

    public RecordImporter(RecordInfo recordInfo) {
        this(recordInfo, false);
    }

    public RecordImporter(RecordInfo recordInfo, boolean bl) {
        super(recordInfo);
        Object object;
        this.noMarkers = bl;
        String string = recordInfo.getName().replace('.', '/') + ".mark";
        URL uRL = null;
        try {
            uRL = ClassResource.get("dataDefinitions/" + string);
            this.markers.load(uRL.openStream());
        }
        catch (Exception exception) {
            try {
                uRL = ClassResource.get(string);
                this.markers.load(uRL.openStream());
            }
            catch (Exception exception2) {
                throw new MakumbaError(exception2);
            }
        }
        Method method = this.getHandlerMethod("configure");
        Object[] objectArray = new Object[]{this.markers};
        try {
            this.callAll(method, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.handlerOrder.elements();
        while (enumeration.hasMoreElements()) {
            object = (FieldImporter)enumeration.nextElement();
            if (this.isMarked((FieldImporter)object) || ((FieldImporter)object).isIgnored()) continue;
            vector.addElement(((FieldHandler)object).getName());
        }
        if (vector.size() > 0) {
            MakumbaSystem.getMakumbaLogger("import").warning("marker file " + uRL + " does not contain markers for:\n " + vector + "\nUse \"<fieldname>.ignore=true\" in the marked file if you are shure you don't want the field to be imported");
        }
        boolean bl2 = false;
        object = this.handlerOrder.elements();
        while (object.hasMoreElements()) {
            FieldImporter fieldImporter = (FieldImporter)object.nextElement();
            if (fieldImporter.configError == null || fieldImporter.isIgnored()) continue;
            if (!bl2) {
                bl2 = true;
                MakumbaSystem.getMakumbaLogger("import").warning("marker file " + uRL + " contains errors. Erroneous fields will be ignored.");
            }
            fieldImporter.ignored = true;
            MakumbaSystem.getMakumbaLogger("import").severe(fieldImporter.configError.toString());
        }
    }
}

