/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.abstr;

import java.io.Serializable;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.NoSuchFieldException;
import org.makumba.abstr.FieldInfo;
import org.makumba.abstr.RecordInfo;
import org.makumba.util.NamedResources;
import org.makumba.util.RuntimeWrappedException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RecordInfo
implements Serializable,
DataDefinition {
    static final String createName = "TS_create";
    static final String modifyName = "TS_modify";
    static int infos = NamedResources.makeStaticCache("Data definitions parsed", new 1());
    URL origin;
    String name;
    Properties templateValues;
    Vector fieldOrder;
    String title;
    String indexName;
    String mainPtr;
    String foreignPtr;
    int relations;
    Hashtable fields;
    Hashtable fieldIndexes;
    String subfield;
    String ptrSubfield;
    String subfieldPtr;
    RecordInfo papa;

    void addStandardFields(String string) {
        this.indexName = string;
        FieldInfo fieldInfo = new FieldInfo(this, this.indexName);
        fieldInfo.type = "ptrIndex";
        fieldInfo.description = "Unique index";
        fieldInfo.fixed = true;
        fieldInfo.notNull = true;
        this.addField1(fieldInfo);
        fieldInfo = new FieldInfo(this, modifyName);
        fieldInfo.type = "dateModify";
        fieldInfo.notNull = true;
        fieldInfo.description = "Last modification date";
        this.addField1(fieldInfo);
        fieldInfo = new FieldInfo(this, createName);
        fieldInfo.type = "dateCreate";
        fieldInfo.description = "Creation date";
        fieldInfo.fixed = true;
        fieldInfo.notNull = true;
        this.addField1(fieldInfo);
    }

    public Dictionary getKeyIndex() {
        if (this.fieldIndexes == null) {
            this.fieldIndexes = new Hashtable();
            int n = 0;
            Enumeration enumeration = this.fieldOrder.elements();
            while (enumeration.hasMoreElements()) {
                FieldInfo fieldInfo = (FieldInfo)this.fields.get(enumeration.nextElement());
                if (fieldInfo.type.startsWith("set")) continue;
                this.fieldIndexes.put(fieldInfo.name, new Integer(n++));
            }
        }
        return this.fieldIndexes;
    }

    public URL getOrigin() {
        return this.origin;
    }

    public boolean isTemporary() {
        boolean bl = false;
        if (this.origin == null) {
            bl = true;
        }
        return bl;
    }

    protected void addField1(FieldInfo fieldInfo) {
        this.fieldOrder.addElement(fieldInfo.name);
        this.fields.put(fieldInfo.name, fieldInfo);
        fieldInfo.ri = this;
    }

    public void addField(FieldInfo fieldInfo) {
        if (!this.isTemporary()) {
            throw new RuntimeException("can't add field to non-temporary type");
        }
        this.addField1(fieldInfo);
        if (this.fieldIndexes == null) {
            this.fieldIndexes = new Hashtable();
        }
        this.fieldIndexes.put(fieldInfo.name, new Integer(this.fieldIndexes.size()));
    }

    public int getDataSize() {
        return this.fieldIndexes.size();
    }

    public boolean isSubtable() {
        boolean bl = false;
        if (this.papa != null) {
            bl = true;
        }
        return bl;
    }

    public RecordInfo getMainTable() {
        return this.papa;
    }

    public String getFieldName() {
        return this.subfield;
    }

    public static RecordInfo getRecordInfo(String string) {
        int n = string.indexOf("->");
        if (n == -1) {
            try {
                return RecordInfo.getSimpleRecordInfo(string);
            }
            catch (DataDefinitionNotFoundError dataDefinitionNotFoundError) {
                n = string.lastIndexOf(".");
                if (n == -1) {
                    throw dataDefinitionNotFoundError;
                }
                try {
                    return RecordInfo.getRecordInfo(string.substring(0, n) + "->" + string.substring(n + 1));
                }
                catch (DataDefinitionParseError dataDefinitionParseError) {
                    throw dataDefinitionNotFoundError;
                }
            }
        }
        RecordInfo recordInfo = RecordInfo.getRecordInfo(string.substring(0, n));
        while ((n = (string = string.substring(n + 2)).indexOf("->")) != -1) {
            recordInfo = recordInfo.getField(string.substring(0, n)).getSubtable();
        }
        recordInfo = recordInfo.getField(string).getSubtable();
        return recordInfo;
    }

    public static synchronized RecordInfo getSimpleRecordInfo(String string) {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '.') {
                if (bl) {
                    throw new DataDefinitionParseError("two consecutive dots not allowed in type name");
                }
                bl = true;
            } else {
                bl = false;
            }
            ++n;
        }
        if (string.indexOf(47) != -1 && (string = string.replace('/', '.')).charAt(0) == '.') {
            string = string.substring(1);
        }
        RecordInfo recordInfo = null;
        try {
            recordInfo = (RecordInfo)NamedResources.getStaticCache(infos).getResource(string);
        }
        catch (RuntimeWrappedException runtimeWrappedException) {
            if (runtimeWrappedException.getReason() instanceof DataDefinitionParseError) {
                throw (DataDefinitionParseError)runtimeWrappedException.getReason();
            }
            if (runtimeWrappedException.getReason() instanceof MakumbaError) {
                throw (MakumbaError)runtimeWrappedException.getReason();
            }
            throw runtimeWrappedException;
        }
        if (string.indexOf("./") == -1) {
            recordInfo.name = string;
        } else {
            MakumbaSystem.getMakumbaLogger("debug.abstr").severe("shit happens: " + string);
        }
        return recordInfo;
    }

    public Vector getFieldNames() {
        return (Vector)this.fieldOrder.clone();
    }

    public Enumeration getDeclaredFields() {
        Enumeration enumeration = this.fieldOrder.elements();
        enumeration.nextElement();
        enumeration.nextElement();
        enumeration.nextElement();
        return enumeration;
    }

    public FieldInfo getField(String string) {
        return (FieldInfo)this.fields.get(string);
    }

    public FieldDefinition getFieldDefinition(String string) {
        return this.getField(string);
    }

    public FieldDefinition getFieldDefinition(int n) {
        if (n < 0 || n >= this.fieldOrder.size()) {
            return null;
        }
        return this.getField((String)this.fieldOrder.elementAt(n));
    }

    public String getName() {
        return this.name + this.ptrSubfield;
    }

    public String getBaseName() {
        return this.name;
    }

    public String getTitleField() {
        return this.title;
    }

    public String fieldPrefix() {
        return this.subfieldPtr;
    }

    public int getRelations() {
        return this.relations;
    }

    RecordInfo makeSubtable(String string) {
        return new RecordInfo(this, string);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getCreateName() {
        return createName;
    }

    public String getModifyName() {
        return modifyName;
    }

    public String getMainTablePointerName() {
        return this.mainPtr;
    }

    public String getForeignTablePointerName() {
        return this.foreignPtr;
    }

    public String getTitleFieldName() {
        return this.getTitleField();
    }

    public String getIndexPointerFieldName() {
        return this.getIndexName();
    }

    public String getCreationDateFieldName() {
        return this.getCreateName();
    }

    public String getLastModificationDateFieldName() {
        return this.getModifyName();
    }

    public FieldDefinition getParentField() {
        RecordInfo recordInfo = this.getMainTable();
        if (recordInfo == null) {
            return null;
        }
        return recordInfo.getField(this.getFieldName());
    }

    public String getSetMemberFieldName() {
        return this.foreignPtr;
    }

    public String checkFieldName(Object object) {
        if (!(object instanceof String)) {
            throw new NoSuchFieldException(this, "Dictionaries passed to makumba DB operations should have String keys. Key <" + object + "> is of type " + object.getClass() + this.getName());
        }
        if (this.getField((String)object) == null) {
            throw new NoSuchFieldException(this, (String)object);
        }
        return (String)object;
    }

    public void checkFieldNames(Dictionary dictionary) {
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            this.checkFieldName(enumeration.nextElement());
        }
    }

    private final /* synthetic */ void this() {
        this.fieldOrder = new Vector();
        this.relations = 0;
        this.fields = new Hashtable();
        this.fieldIndexes = null;
        this.ptrSubfield = "";
        this.subfieldPtr = "";
    }

    public RecordInfo() {
        this.this();
        this.name = "temp" + this.hashCode();
        this.origin = null;
    }

    RecordInfo(URL uRL, String string) {
        this.this();
        this.name = string;
        this.origin = uRL;
    }

    RecordInfo(RecordInfo recordInfo, String string) {
        this.this();
        this.name = recordInfo.name;
        this.origin = recordInfo.origin;
        this.subfield = string;
        this.papa = recordInfo;
        this.ptrSubfield = this.papa.ptrSubfield + "->" + string;
        this.subfieldPtr = this.papa.subfieldPtr + string + "->";
    }
}

