/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.makumba.Attributes;
import org.makumba.Database;
import org.makumba.LogicException;
import org.makumba.LogicInvocationError;
import org.makumba.LogicNotFoundException;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.ProgrammerError;
import org.makumba.Transaction;
import org.makumba.util.ClassResource;
import org.makumba.util.DbConnectionProvider;
import org.makumba.util.NamedResourceFactory;
import org.makumba.util.NamedResources;
import org.makumba.util.RuntimeWrappedException;

public class Logic {
    static Properties controllerConfig;
    static URL controllerURL;
    static HashMap nameToObject;
    static int logix;
    static String[] separators;
    static Class[] argDb;
    static Class[] editArgs;
    static Class[] opArgs;
    static Class[] noClassArgs;
    static Object[] noObjectArgs;
    static Class[] deleteArgs;
    static Class[] newArgs;

    public static String getSearchMessage(String string) {
        return (String)((Hashtable)NamedResources.getStaticCache(logix).getSupplementary()).get(string);
    }

    public static Object getController(String string) {
        if (nameToObject.get(string) == null) {
            try {
                Object obj = Class.forName(string).newInstance();
                nameToObject.put(string, obj);
                return obj;
            }
            catch (ClassNotFoundException classNotFoundException) {
                MakumbaSystem.getMakumbaLogger("controller").log(Level.SEVERE, "Error while trying to load controller class " + string, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                MakumbaSystem.getMakumbaLogger("controller").log(Level.SEVERE, "Error while trying to load controller class " + string, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                MakumbaSystem.getMakumbaLogger("controller").log(Level.SEVERE, "Error while trying to load controller class " + string, illegalAccessException);
            }
        }
        return nameToObject.get(string);
    }

    static String upperCase(String string) {
        String string2 = "";
        while (true) {
            int n = string.length();
            int n2 = -1;
            for (int i = 0; i < separators.length; ++i) {
                int n3 = string.indexOf(separators[i]);
                if (n3 == -1 || n3 >= n) continue;
                n = n3;
                n2 = i;
            }
            string2 = string2 + Logic.firstUpper(string.substring(0, n));
            if (n2 == -1) {
                return string2;
            }
            string = string.substring(n + separators[n2].length());
        }
    }

    static String firstUpper(String string) {
        char c = Character.toUpperCase(string.charAt(0));
        if (string.length() > 1) {
            return c + string.substring(1);
        }
        return "" + c;
    }

    public static Object getLogic(String string) {
        return NamedResources.getStaticCache(logix).getResource(string);
    }

    public static Object getAttribute(Object object, String string, Attributes attributes, String string2, DbConnectionProvider dbConnectionProvider) throws NoSuchMethodException, LogicException {
        if (object instanceof LogicNotFoundException) {
            throw new NoSuchMethodException("no controller=> no attribute method");
        }
        Transaction transaction = dbConnectionProvider.getConnectionTo(string2);
        Object[] objectArray = new Object[]{attributes, transaction};
        try {
            return object.getClass().getMethod("find" + Logic.firstUpper(string), argDb).invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchMethodException(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            transaction.rollback();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof LogicException) {
                throw (LogicException)throwable;
            }
            throw new LogicInvocationError(throwable);
        }
    }

    public static String getControllerFile(Object object) {
        String string = object.getClass().getName();
        URL uRL = ClassResource.get(string.replace('.', '/') + ".java");
        if (uRL != null) {
            return Logic.getFilePath(uRL);
        }
        return ClassResource.get(string.replace('.', '/') + ".class").toString();
    }

    public static String getFilePath(URL uRL) {
        try {
            return new File(uRL.getFile()).getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new RuntimeWrappedException(iOException);
        }
    }

    public static Method getMethod(String string, Class[] classArray, Object object) {
        try {
            Method method = object.getClass().getMethod(string, classArray);
            if (!Modifier.isPublic(method.getModifiers())) {
                return null;
            }
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static void doInit(Object object, Attributes attributes, String string, DbConnectionProvider dbConnectionProvider) throws LogicException {
        if (object instanceof LogicNotFoundException) {
            return;
        }
        Transaction transaction = dbConnectionProvider.getConnectionTo(string);
        Method method = Logic.getMethod("checkAttributes", argDb, object);
        Method method2 = Logic.getMethod("requiredAttributes", noClassArgs, object);
        if (method == null && method2 == null) {
            return;
        }
        if (method != null) {
            Object[] objectArray = new Object[]{attributes, transaction};
            try {
                method.invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new LogicInvocationError(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                transaction.rollback();
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof LogicException) {
                    throw (LogicException)throwable;
                }
                throw new LogicInvocationError(throwable);
            }
        }
        MakumbaSystem.getMakumbaLogger("controller").warning("requiredAttributes() is deprecated. Use checkAttributes(Attributes a, Database db) instead");
        Object object2 = null;
        try {
            object2 = method2.invoke(object, noObjectArgs);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LogicInvocationError(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            transaction.rollback();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof LogicException) {
                throw (LogicException)throwable;
            }
            throw new LogicInvocationError(throwable);
        }
        if (object2 == null) {
            return;
        }
        if (object2 instanceof String) {
            attributes.getAttribute((String)object2);
            return;
        }
        if (object2 instanceof String[]) {
            for (int i = 0; i < ((String[])object2).length; ++i) {
                attributes.getAttribute(((String[])object2)[i]);
            }
            return;
        }
        return;
    }

    public static Object doOp(Object object, String string, Dictionary dictionary, Attributes attributes, String string2, DbConnectionProvider dbConnectionProvider) throws LogicException {
        if (string == null) {
            return null;
        }
        if (object instanceof LogicNotFoundException) {
            throw new ProgrammerError("there is no controller object to look for the Form handler method " + string);
        }
        Transaction transaction = dbConnectionProvider.getConnectionTo(string2);
        Object[] objectArray = new Object[]{dictionary, attributes, transaction};
        Method method = null;
        method = Logic.getMethod(string, opArgs, object);
        if (method == null) {
            throw new ProgrammerError("Class " + object.getClass().getName() + " (" + Logic.getControllerFile(object) + ")\n" + "does not define the method\n" + string + "(Dictionary, Attributes, Database)\n" + "The method is declared as a makumba form handler, so it has to be defined");
        }
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LogicInvocationError(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            transaction.rollback();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof LogicException) {
                throw (LogicException)throwable;
            }
            throw new LogicInvocationError(throwable);
        }
    }

    public static Pointer doEdit(Object object, String string, Pointer pointer, Dictionary dictionary, Attributes attributes, String string2, DbConnectionProvider dbConnectionProvider) throws LogicException {
        Transaction transaction = dbConnectionProvider.getConnectionTo(string2);
        Object[] objectArray = new Object[]{pointer, dictionary, attributes, transaction};
        Method method = null;
        String string3 = Logic.upperCase(string);
        if (!(object instanceof LogicNotFoundException) && (method = Logic.getMethod("on_edit" + string3, editArgs, object)) == null) {
            throw new ProgrammerError("Class " + object.getClass().getName() + " (" + Logic.getControllerFile(object) + ")\n" + "does not define the method\n" + "on_edit" + string3 + "(Pointer, Dictionary, Attributes, Database)\n" + "so it does not allow EDIT operations on the type " + string + "\nDefine that method (even with an empty body) to allow such operations.");
        }
        try {
            if (method != null) {
                method.invoke(object, objectArray);
            }
            transaction.update(pointer, dictionary);
            return pointer;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LogicInvocationError(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            transaction.rollback();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof LogicException) {
                throw (LogicException)throwable;
            }
            throw new LogicInvocationError(throwable);
        }
    }

    public static Pointer doDelete(Object object, String string, Pointer pointer, Attributes attributes, String string2, DbConnectionProvider dbConnectionProvider) throws LogicException {
        Transaction transaction = dbConnectionProvider.getConnectionTo(string2);
        Object[] objectArray = new Object[]{pointer, attributes, transaction};
        Method method = null;
        String string3 = Logic.upperCase(string);
        if (!(object instanceof LogicNotFoundException) && (method = Logic.getMethod("on_delete" + string3, deleteArgs, object)) == null) {
            throw new ProgrammerError("Class " + object.getClass().getName() + " (" + Logic.getControllerFile(object) + ")\n" + "does not define the method\n" + "on_delete" + string3 + "(Pointer, Attributes, Database)\n" + "so it does not allow DELETE operations on the type " + string + "\nDefine that method (even with an empty body) to allow such operations.");
        }
        try {
            if (method != null) {
                method.invoke(object, objectArray);
            }
            transaction.delete(pointer);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LogicInvocationError(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            transaction.rollback();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof LogicException) {
                throw (LogicException)throwable;
            }
            throw new LogicInvocationError(throwable);
        }
    }

    public static Pointer doAdd(Object object, String string, Pointer pointer, Dictionary dictionary, Attributes attributes, String string2, DbConnectionProvider dbConnectionProvider) throws LogicException {
        Transaction transaction = dbConnectionProvider.getConnectionTo(string2);
        Object[] objectArray = new Object[]{pointer, dictionary, attributes, transaction};
        Method method = null;
        Method method2 = null;
        String string3 = Logic.upperCase(string);
        int n = string.lastIndexOf("->");
        String string4 = string.substring(n + 2);
        string = string.substring(0, n);
        if (!(object instanceof LogicNotFoundException)) {
            method = Logic.getMethod("on_add" + string3, editArgs, object);
            method2 = Logic.getMethod("after_add" + string3, editArgs, object);
            if (method == null && method2 == null) {
                throw new ProgrammerError("Class " + object.getClass().getName() + " (" + Logic.getControllerFile(object) + ")\n" + "does not define neither of the methods\n" + "on_add" + string3 + "(Pointer, Dictionary, Attributes, Database)\n" + "after_add" + string3 + "(Pointer, Dictionary, Attributes, Database)\n" + "so it does not allow ADD operations on the type " + string + ", field " + string4 + "\nDefine any of the methods (even with an empty body) to allow such operations.");
            }
        }
        try {
            if (method != null) {
                method.invoke(object, objectArray);
            }
            objectArray[0] = transaction.insert(pointer, string4, dictionary);
            if (method2 != null) {
                method2.invoke(object, objectArray);
            }
            return (Pointer)objectArray[0];
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LogicInvocationError(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            transaction.rollback();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof LogicException) {
                throw (LogicException)throwable;
            }
            throw new LogicInvocationError(throwable);
        }
    }

    public static Pointer doNew(Object object, String string, Dictionary dictionary, Attributes attributes, String string2, DbConnectionProvider dbConnectionProvider) throws LogicException {
        Transaction transaction = dbConnectionProvider.getConnectionTo(string2);
        Object[] objectArray = new Object[]{dictionary, attributes, transaction};
        Object[] objectArray2 = new Object[]{null, dictionary, attributes, transaction};
        Method method = null;
        Method method2 = null;
        String string3 = Logic.upperCase(string);
        if (!(object instanceof LogicNotFoundException)) {
            method = Logic.getMethod("on_new" + string3, newArgs, object);
            method2 = Logic.getMethod("after_new" + string3, editArgs, object);
            if (method == null && method2 == null) {
                throw new ProgrammerError("Class " + object.getClass().getName() + " (" + Logic.getControllerFile(object) + ")\n" + "does not define neither of the methods\n" + "on_new" + string3 + "(Dictionary, Attributes, Database)\n" + "after_new" + string3 + "(Pointer, Dictionary, Attributes, Database)\n" + "so it does not allow NEW operations on the type " + string + ".\nDefine any of the methods (even with an empty body) to allow such operations.");
            }
        }
        try {
            if (method != null) {
                method.invoke(object, objectArray);
            }
            objectArray2[0] = transaction.insert(string, dictionary);
            if (method2 != null) {
                method2.invoke(object, objectArray2);
            }
            return (Pointer)objectArray2[0];
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LogicInvocationError(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            transaction.rollback();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof LogicException) {
                throw (LogicException)throwable;
            }
            throw new LogicInvocationError(throwable);
        }
    }

    static {
        nameToObject = new HashMap();
        controllerConfig = new Properties();
        try {
            controllerURL = ClassResource.get("MakumbaController.properties");
            controllerConfig.load(controllerURL.openStream());
        }
        catch (Exception exception) {
            controllerConfig = null;
        }
        logix = NamedResources.makeStaticCache("Business logic classes", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;
            {
                this.supplementary = new Hashtable();
            }

            protected Object makeResource(Object object) {
                String string;
                Object object2;
                StringTokenizer stringTokenizer;
                String string2 = (String)object;
                String string3 = "Searching for business logic for " + string2 + ":";
                String string4 = "";
                int n = string2.lastIndexOf(".");
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                String string5 = "";
                String string6 = "";
                if (controllerConfig != null) {
                    string3 = string3 + "\nfollowing rules from MakumbaController.properties found at:\n\t" + Logic.getFilePath(controllerURL);
                    stringTokenizer = controllerConfig.keys();
                    while (stringTokenizer.hasMoreElements()) {
                        object2 = (String)stringTokenizer.nextElement();
                        if (((String)object2).equals("default") && string6.length() == 0) {
                            string5 = controllerConfig.getProperty((String)object2);
                            continue;
                        }
                        if (!string2.startsWith((String)object2) || ((String)object2).length() <= string6.length()) continue;
                        string6 = object2;
                        string4 = controllerConfig.getProperty((String)object2);
                        if (string4.length() <= 0 || string4.lastIndexOf(".") == string4.length() - 1) continue;
                        string4 = string4 + ".";
                    }
                    if (string6.length() == 0 && string5.length() > 0) {
                        string3 = string3 + "\nfollowing default rule from MakumbaController.properties";
                        string4 = string5 + ".";
                    } else if (string6.length() > 0) {
                        string3 = string3 + "\nfollowing rule based on longest matching key from MakumbaController.properties\n\tkey is: \"" + string6 + "\"";
                    }
                    string2 = string2.substring(string6.length());
                } else {
                    string3 = string3 + "\ncould not find MakumbaController.properties in CLASSPATH";
                }
                string3 = string3 + "\ndetermined base: \"" + string4 + "\"";
                stringTokenizer = new StringTokenizer(string2, "/");
                object2 = null;
                String string7 = " ";
                block5: while (true) {
                    string = string4;
                    for (int i = 1; i <= string7.length(); ++i) {
                        if (i != string7.length() && !Character.isUpperCase(string7.charAt(i))) continue;
                        string4 = string + string7.substring(0, i).trim();
                        try {
                            string3 = string3 + "\ntrying \"" + string4 + "Logic\"";
                            object2 = Class.forName(string4 + "Logic").newInstance();
                            string3 = string3 + "... found.";
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            string3 = string3 + "... not found";
                            continue;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            string3 = string3 + "... no public constructor";
                            continue;
                        }
                        catch (InstantiationException instantiationException) {
                            string3 = string3 + "... abstract class";
                        }
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        string7 = stringTokenizer.nextToken();
                        if (string7.length() == 0) continue;
                        string7 = Logic.firstUpper(string7);
                        continue block5;
                    }
                    break;
                }
                if (object2 == null) {
                    string3 = string3 + "\nNo matching class found for " + object + "!";
                    object2 = new LogicNotFoundException(string3);
                } else {
                    string3 = string3 + "\nFound class " + object2.getClass().getName();
                }
                MakumbaSystem.getMakumbaLogger("controller").info(string3);
                ((Hashtable)this.supplementary).put(object, string3);
                string = nameToObject.get(object2.getClass().getName());
                if (string != null) {
                    return string;
                }
                return object2;
            }
        }, true);
        separators = new String[]{".", "->"};
        argDb = new Class[]{Attributes.class, Database.class};
        editArgs = new Class[]{Pointer.class, Dictionary.class, Attributes.class, Database.class};
        opArgs = new Class[]{Dictionary.class, Attributes.class, Database.class};
        noClassArgs = new Class[0];
        noObjectArgs = new Object[0];
        deleteArgs = new Class[]{Pointer.class, Attributes.class, Database.class};
        newArgs = new Class[]{Dictionary.class, Attributes.class, Database.class};
    }
}

