/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller.html;

import java.util.Dictionary;
import org.makumba.ProgrammerError;
import org.makumba.controller.http.HttpParameters;
import org.makumba.view.FieldFormatter;
import org.makumba.view.InvalidValueException;
import org.makumba.view.RecordFormatter;

public class FieldEditor
extends FieldFormatter {
    static String[] params = new String[]{"default", "empty", "type"};
    static String[][] paramValues = new String[][]{null, null, {"hidden"}};
    static final String suffixName = "org.makumba.editorSuffix";
    public static final String extraFormattingParam = "makumba.extraFormatting";

    protected FieldEditor() {
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    public String[] getAcceptedParams() {
        return params;
    }

    public String[][] getAcceptedValue() {
        return paramValues;
    }

    public static String getSuffix(RecordFormatter recordFormatter, int n, Dictionary dictionary) {
        return (String)dictionary.get(suffixName);
    }

    public static void setSuffix(Dictionary dictionary, String string) {
        dictionary.put(suffixName, string);
    }

    public void checkParam(RecordFormatter recordFormatter, int n, String string, String string2) {
        if (string.equals(extraFormattingParam)) {
            return;
        }
        if (string.equals("type") && string2.equals("hidden")) {
            return;
        }
        super.checkParam(recordFormatter, n, string, string2);
    }

    public String format(RecordFormatter recordFormatter, int n, Object object, Dictionary dictionary) {
        String string = (String)dictionary.get("type");
        if (string != null && string.equals("hidden")) {
            return this.formatHidden(recordFormatter, n, object, dictionary);
        }
        return this.formatShow(recordFormatter, n, object, dictionary);
    }

    public String formatShow(RecordFormatter recordFormatter, int n, Object object, Dictionary dictionary) {
        return super.format(recordFormatter, n, object, dictionary);
    }

    public String formatHidden(RecordFormatter recordFormatter, int n, Object object, Dictionary dictionary) {
        return "<input type=\"hidden\" name=\"" + this.getInputName(recordFormatter, n, dictionary) + "\" value=\"" + this.formatHiddenValue(recordFormatter, n, object, dictionary) + "\" " + FieldEditor.getExtraFormatting(recordFormatter, n, dictionary) + ">";
    }

    public String formatHiddenValue(RecordFormatter recordFormatter, int n, Object object, Dictionary dictionary) {
        return this.formatValue(recordFormatter, n, object, dictionary);
    }

    public String formatValue(RecordFormatter recordFormatter, int n, Object object, Dictionary dictionary) {
        throw new ProgrammerError("If this method is needed, overload it in the inheriting class");
    }

    public void onStartup(RecordFormatter recordFormatter, int n) {
    }

    public String getInputName(RecordFormatter recordFormatter, int n, Dictionary dictionary) {
        return this.getInputName(recordFormatter, n, FieldEditor.getSuffix(recordFormatter, n, dictionary));
    }

    public String getInputName(RecordFormatter recordFormatter, int n, String string) {
        return recordFormatter.expr[n] + string;
    }

    public static String getExtraFormatting(RecordFormatter recordFormatter, int n, Dictionary dictionary) {
        return (String)dictionary.get(extraFormattingParam);
    }

    public static void setExtraFormatting(Dictionary dictionary, String string) {
        dictionary.put(extraFormattingParam, string);
    }

    public Object readFrom(RecordFormatter recordFormatter, int n, HttpParameters httpParameters, String string) {
        return httpParameters.getParameter(this.getInputName(recordFormatter, n, string));
    }

    protected Integer toInt(RecordFormatter recordFormatter, int n, Object object) {
        if (object == null) {
            return null;
        }
        String string = ("" + object).trim();
        if (string.length() == 0) {
            return null;
        }
        try {
            return new Integer(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException(recordFormatter.expr[n], "invalid integer: " + object);
        }
    }

    protected Double toReal(RecordFormatter recordFormatter, int n, Object object) {
        if (object == null) {
            return null;
        }
        String string = ("" + object).trim();
        if (string.length() == 0) {
            return null;
        }
        try {
            return new Double(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new Double(Double.parseDouble(string.replace(',', '.')));
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return new Double(Double.parseDouble(string.replace('.', ',')));
                }
                catch (NumberFormatException numberFormatException3) {
                    throw new InvalidValueException(recordFormatter.expr[n], "invalid real: " + object);
                }
            }
        }
    }

    private static final class SingletonHolder {
        static final FieldEditor singleton = new FieldEditor();

        private SingletonHolder() {
        }
    }
}

