/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller.html;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.controller.html.FieldEditor;
import org.makumba.controller.http.HttpParameters;
import org.makumba.view.FieldFormatter;
import org.makumba.view.InvalidValueException;
import org.makumba.view.RecordFormatter;
import org.makumba.view.dateFormatter;

public class dateEditor
extends FieldEditor {
    static String[] _params = new String[]{"format"};
    static String[][] _paramValues = new String[][]{null};
    static final String recognized = "dMyHms";
    static int[] lowLimits = new int[]{1, 0, -1, 0, 0, 0};
    static int[] hiLimits = new int[]{31, 11, -1, 23, 59, 59};
    static int[] components = new int[]{5, 2, 1, 11, 12, 13};

    private dateEditor() {
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    public String[] getAcceptedParams() {
        return _params;
    }

    public String[][] getAcceptedValue() {
        return _paramValues;
    }

    String getNullName(RecordFormatter recordFormatter, int n, Dictionary dictionary) {
        return this.getNullName(recordFormatter, n, dateEditor.getSuffix(recordFormatter, n, dictionary));
    }

    String getNullName(RecordFormatter recordFormatter, int n, String string) {
        return this.getInputName(recordFormatter, n, string) + "_null";
    }

    String getComponentName(RecordFormatter recordFormatter, int n, int n2, String string) {
        return this.getInputName(recordFormatter, n, string) + "_" + n2;
    }

    String getComponentName(RecordFormatter recordFormatter, int n, int n2, Dictionary dictionary) {
        return this.getComponentName(recordFormatter, n, n2, dateEditor.getSuffix(recordFormatter, n, dictionary));
    }

    public String format(RecordFormatter recordFormatter, int n, Object object, Dictionary dictionary) {
        String string = (String)dictionary.get("format");
        if (string == null) {
            string = "dd MMMMM yyyy";
        }
        if (object == Pointer.NullDate) {
            object = null;
        }
        Date date = (Date)object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = "hidden".equals(dictionary.get("type"));
        if (date == null) {
            date = (Date)recordFormatter.dd.getFieldDefinition(n).getDefaultValue();
            stringBuffer.append("<input type=\"hidden\" name=\"").append(this.getNullName(recordFormatter, n, dictionary)).append("\">");
        }
        int n2 = 0;
        while ((n2 = this.findNextFormatter(recordFormatter, n, stringBuffer, string, n2, bl)) != -1) {
            n2 = this.formatFrom(recordFormatter, n, stringBuffer, date, string, n2, bl, dictionary);
        }
        return stringBuffer.toString();
    }

    void formatComponent(RecordFormatter recordFormatter, int n, StringBuffer stringBuffer, Date date, String string, int n2, boolean bl, Dictionary dictionary) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, MakumbaSystem.getLocale());
        simpleDateFormat.setCalendar(dateFormatter.calendar);
        String string2 = this.getComponentName(recordFormatter, n, n2, dictionary);
        if (bl) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(MakumbaSystem.getTimeZone());
            gregorianCalendar.setTime(date);
            stringBuffer.append("<input type=\"hidden\" name=\"").append(string2).append("\" value=\"").append(gregorianCalendar.get(components[n2])).append("\">");
        } else {
            String string3 = simpleDateFormat.format(date);
            if (lowLimits[n2] == -1) {
                stringBuffer.append("<input type=\"text\" name=\"").append(string2).append("\" value=\"").append(string3).append("\" maxlength=\"").append(string.length()).append("\" size=\"").append(string.length()).append("\"").append(dateEditor.getExtraFormatting(recordFormatter, n, dictionary)).append(">");
            } else {
                stringBuffer.append("<select name=\"").append(string2).append("\"").append(dateEditor.getExtraFormatting(recordFormatter, n, dictionary)).append(">");
                GregorianCalendar gregorianCalendar = new GregorianCalendar(MakumbaSystem.getTimeZone());
                gregorianCalendar.clear();
                gregorianCalendar.set(1900, 0, 1);
                for (int i = lowLimits[n2]; i <= hiLimits[n2]; ++i) {
                    gregorianCalendar.set(components[n2], i);
                    String string4 = simpleDateFormat.format(gregorianCalendar.getTime());
                    stringBuffer.append("<option value=\"").append(i).append("\"");
                    if (string4.equals(string3)) {
                        stringBuffer.append(" selected");
                    }
                    stringBuffer.append(">").append(string4).append("</option>");
                }
                stringBuffer.append("</select>");
            }
        }
    }

    public Object readFrom(RecordFormatter recordFormatter, int n, HttpParameters httpParameters, String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(MakumbaSystem.getTimeZone());
        gregorianCalendar.clear();
        for (int i = 0; i < components.length; ++i) {
            String string2 = this.getComponentName(recordFormatter, n, i, string);
            Object object = httpParameters.getParameter(string2);
            if (object == null) continue;
            if (object instanceof Vector) {
                throw new InvalidValueException(recordFormatter.expr[n], "multiple value not allowed for date component " + string2);
            }
            int n2 = -1;
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidValueException(recordFormatter.expr[n], "non-integer value not allowed for date component " + string2 + " : " + object);
            }
            gregorianCalendar.set(components[i], n2);
        }
        Date date = gregorianCalendar.getTime();
        if (date.equals(recordFormatter.dd.getFieldDefinition(n).getDefaultValue()) && httpParameters.getParameter(this.getNullName(recordFormatter, n, string)) != null) {
            return null;
        }
        return date;
    }

    int formatFrom(RecordFormatter recordFormatter, int n, StringBuffer stringBuffer, Date date, String string, int n2, boolean bl, Dictionary dictionary) {
        int n3 = n2;
        char c = string.charAt(n2);
        while (++n2 < string.length() && string.charAt(n2) == c) {
        }
        this.formatComponent(recordFormatter, n, stringBuffer, date, string.substring(n3, n2), recognized.indexOf(c), bl, dictionary);
        return n2;
    }

    int findNextFormatter(RecordFormatter recordFormatter, int n, StringBuffer stringBuffer, String string, int n2, boolean bl) {
        StringBuffer stringBuffer2 = null;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '\'') {
                if (stringBuffer2 != null) {
                    if (stringBuffer2.length() == 0) {
                        if (!bl) {
                            stringBuffer.append('\'');
                        }
                        stringBuffer2 = null;
                    } else {
                        if (!bl) {
                            stringBuffer.append(stringBuffer2.toString());
                        }
                        stringBuffer2 = null;
                    }
                } else {
                    stringBuffer2 = new StringBuffer();
                }
            } else if (stringBuffer2 != null) {
                stringBuffer2.append(c);
            } else if (!Character.isLetter(c)) {
                if (!bl) {
                    stringBuffer.append(c);
                }
            } else {
                if (recognized.indexOf(c) == -1) {
                    throw new InvalidValueException(recordFormatter.expr[n], "unrecognized formatting letter '" + c + "' in date format string <" + string + ">");
                }
                return n2;
            }
            ++n2;
        }
        if (stringBuffer2 != null) {
            throw new InvalidValueException(recordFormatter.expr[n], "unterminated single quote in date format string <" + string + ">");
        }
        return -1;
    }

    private static final class SingletonHolder {
        static final FieldEditor singleton = new dateEditor();

        private SingletonHolder() {
        }
    }
}

