/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidFieldTypeException;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.NoSuchFieldException;
import org.makumba.Pointer;
import org.makumba.ProgrammerError;
import org.makumba.Transaction;
import org.makumba.db.DataHolder;
import org.makumba.db.Database;
import org.makumba.db.Query;
import org.makumba.db.Table;
import org.makumba.db.Update;

public abstract class DBConnection
implements Transaction {
    protected Database db;
    Map locks = new HashMap(13);
    Hashtable lockRecord = new Hashtable(5);

    protected DBConnection() {
    }

    public DBConnection(Database database) {
        this.db = database;
    }

    public Database getHostDatabase() {
        return this.db;
    }

    public String getName() {
        return this.db.getName();
    }

    public abstract void close();

    public abstract void commit();

    public abstract void rollback();

    public void lock(String string) {
        this.lockRecord.clear();
        this.lockRecord.put("name", string);
        this.locks.put(string, this.insert("org.makumba.db.Lock", this.lockRecord));
    }

    public void unlock(String string) {
        Pointer pointer = (Pointer)this.locks.get(string);
        if (pointer == null) {
            throw new ProgrammerError(string + " not locked in connection " + this);
        }
        this.deleteLock(string);
    }

    protected void deleteLock(String string) {
        this.locks.remove(string);
        this.delete("org.makumba.db.Lock l", "l.name=$1", string);
    }

    protected void unlockAll() {
        Iterator iterator = this.locks.keySet().iterator();
        while (iterator.hasNext()) {
            this.deleteLock((String)iterator.next());
        }
    }

    public void update(Pointer pointer, Dictionary dictionary) {
        DataHolder dataHolder = new DataHolder(this, dictionary, pointer.getType());
        dataHolder.checkUpdate();
        dataHolder.update(pointer);
    }

    public Dictionary read(Pointer pointer, Object object) {
        Object object2;
        Object object3;
        Object[] objectArray;
        Object object4;
        Vector<String> vector;
        Enumeration enumeration = null;
        if (object == null) {
            vector = MakumbaSystem.getDataDefinition(pointer.getType());
            object4 = new Vector();
            objectArray = vector.getFieldNames().elements();
            while (objectArray.hasMoreElements()) {
                object3 = (String)objectArray.nextElement();
                if (vector.getFieldDefinition((String)object3).getType().startsWith("set")) continue;
                ((Vector)object4).addElement(object3);
            }
            enumeration = ((Vector)object4).elements();
        } else if (object instanceof Vector) {
            enumeration = ((Vector)object).elements();
        } else if (object instanceof Enumeration) {
            enumeration = (Enumeration)object;
        } else if (object instanceof String[]) {
            vector = new Vector<String>();
            object4 = (String[])object;
            for (int i = 0; i < ((String[])object4).length; ++i) {
                vector.addElement(object4[i]);
            }
            enumeration = vector.elements();
        } else {
            throw new InvalidValueException("read() argument must be Enumeration, Vector, String[] or null");
        }
        vector = new StringBuffer();
        ((StringBuffer)((Object)vector)).append("SELECT ");
        object4 = "";
        while (enumeration.hasMoreElements()) {
            objectArray = enumeration.nextElement();
            object3 = MakumbaSystem.getDataDefinition(pointer.getType());
            if (!(objectArray instanceof String)) {
                throw new NoSuchFieldException((DataDefinition)object3, "Dictionaries passed to makumba DB operations should have String keys. Key <" + objectArray + "> is of type " + objectArray.getClass() + object3.getName());
            }
            if (object3.getFieldDefinition((String)objectArray) == null) {
                throw new NoSuchFieldException((DataDefinition)object3, (String)objectArray);
            }
            object2 = (String)objectArray;
            ((StringBuffer)((Object)vector)).append((String)object4).append("p.").append((String)object2).append(" as ").append((String)object2);
            object4 = ",";
        }
        ((StringBuffer)((Object)vector)).append(" FROM " + pointer.getType() + " p WHERE p=$1");
        objectArray = new Object[]{pointer};
        object3 = this.executeQuery(((StringBuffer)((Object)vector)).toString(), objectArray);
        if (((Vector)object3).size() == 0) {
            return null;
        }
        if (((Vector)object3).size() > 1) {
            throw new MakumbaError("MAKUMBA DATABASE INCOSISTENT: Pointer not unique: " + pointer);
        }
        object2 = (Dictionary)((Vector)object3).elementAt(0);
        Hashtable hashtable = new Hashtable(13);
        Enumeration enumeration2 = ((Dictionary)object2).keys();
        while (enumeration2.hasMoreElements()) {
            Object k = enumeration2.nextElement();
            hashtable.put(k, ((Dictionary)object2).get(k));
        }
        return hashtable;
    }

    public Pointer insert(String string, Dictionary object) {
        Object object2;
        Table table = this.db.getTable(string);
        table.computeInsertHook();
        if (table.insertHook != null) {
            object2 = new Hashtable();
            Enumeration enumeration = ((Dictionary)object).keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                ((Hashtable)object2).put(k, ((Dictionary)object).get(k));
            }
            object = object2;
        }
        if (table.insertHook == null || table.insertHook.transform((Dictionary)object, this)) {
            object2 = new DataHolder(this, (Dictionary)object, string);
            ((DataHolder)object2).checkInsert();
            return ((DataHolder)object2).insert();
        }
        return null;
    }

    Object[] treatParam(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    public Vector executeQuery(String string, Object object, int n, int n2) {
        Object[] objectArray = new Object[]{string, ""};
        return ((Query)this.getHostDatabase().queries.getResource(objectArray)).execute(this.treatParam(object), this, n, n2);
    }

    public int insertFromQuery(String string, String string2, Object object) {
        Object[] objectArray = new Object[]{string2, string};
        return ((Query)this.getHostDatabase().queries.getResource(objectArray)).insert(this.treatParam(object), this);
    }

    public Vector executeQuery(String string, Object object) {
        return this.executeQuery(string, object, 0, -1);
    }

    public int executeUpdate(String string, String string2, String string3, Object object) {
        Object[] objectArray = new Object[]{string, string2, string3};
        return ((Update)this.getHostDatabase().updates.getResource(objectArray)).execute(this, this.treatParam(object));
    }

    public Pointer insert(Pointer pointer, String string, Dictionary dictionary) {
        FieldDefinition fieldDefinition = MakumbaSystem.getDataDefinition(pointer.getType()).getFieldDefinition(string);
        if (fieldDefinition.getType().equals("setComplex")) {
            dictionary.put(fieldDefinition.getSubtable().getSetOwnerFieldName(), pointer);
            return this.insert(fieldDefinition.getSubtable().getName(), dictionary);
        }
        throw new InvalidFieldTypeException(fieldDefinition, "subset");
    }

    public void delete(Pointer pointer) {
        DataDefinition dataDefinition = MakumbaSystem.getDataDefinition(pointer.getType());
        FieldDefinition fieldDefinition = dataDefinition.getParentField();
        if (fieldDefinition != null && fieldDefinition.getType().equals("ptrOne")) {
            this.executeUpdate(fieldDefinition.getDataDefinition().getName() + " this", "this." + fieldDefinition.getName() + "=nil", "this." + fieldDefinition.getName() + "=$1", pointer);
        }
        this.delete1(pointer);
    }

    void delete1(Pointer pointer) {
        Object object;
        DataDefinition dataDefinition = MakumbaSystem.getDataDefinition(pointer.getType());
        Object[] objectArray = new Object[]{pointer};
        Vector<Object> vector = new Vector<Object>();
        Object object2 = dataDefinition.getFieldNames().elements();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            if (!dataDefinition.getFieldDefinition((String)object).getType().equals("ptrOne")) continue;
            vector.addElement(object);
        }
        if (vector.size() > 0) {
            object2 = this.read(pointer, vector);
            object = ((Dictionary)object2).elements();
            while (object.hasMoreElements()) {
                this.delete1((Pointer)object.nextElement());
            }
        }
        object2 = dataDefinition.getFieldNames().elements();
        while (object2.hasMoreElements()) {
            object = dataDefinition.getFieldDefinition((String)object2.nextElement());
            if (!object.getType().startsWith("set")) continue;
            if (object.getType().equals("setComplex")) {
                this.executeUpdate(object.getSubtable().getName() + " this", null, "this." + object.getSubtable().getFieldDefinition(3).getName() + "= $1", objectArray);
                continue;
            }
            this.deleteSet(pointer, (FieldDefinition)object);
        }
        this.executeUpdate(pointer.getType() + " this", null, "this." + MakumbaSystem.getDataDefinition(pointer.getType()).getIndexPointerFieldName() + "=$1", pointer);
    }

    void deleteSet(Pointer pointer, FieldDefinition fieldDefinition) {
        this.executeUpdate(fieldDefinition.getSubtable().getName() + " this", null, "this." + fieldDefinition.getSubtable().getSetOwnerFieldName() + "=$1", pointer);
    }

    void updateSet(Pointer pointer, String string, Object object) {
        FieldDefinition fieldDefinition = MakumbaSystem.getDataDefinition(pointer.getType()).getFieldDefinition(string);
        if (!(fieldDefinition.getType().equals("set") || fieldDefinition.getType().equals("setintEnum") || fieldDefinition.getType().equals("setcharEnum"))) {
            throw new InvalidFieldTypeException(fieldDefinition, "set");
        }
        this.deleteSet(pointer, fieldDefinition);
        if (object == null || object == Pointer.NullSet || ((Vector)object).size() == 0) {
            return;
        }
        Vector vector = (Vector)object;
        Hashtable<String, Pointer> hashtable = new Hashtable<String, Pointer>(10);
        ((Dictionary)hashtable).put(fieldDefinition.getSubtable().getSetOwnerFieldName(), pointer);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Dictionary)hashtable).put(fieldDefinition.getSubtable().getSetMemberFieldName(), (Pointer)enumeration.nextElement());
            this.db.getTable(fieldDefinition.getSubtable()).insertRecord(this, hashtable);
        }
    }

    public int update(String string, String string2, String string3, Object object) {
        return this.executeUpdate(string, string2, string3, object);
    }

    public int delete(String string, String string2, Object object) {
        return this.executeUpdate(string, null, string2, object);
    }
}

