/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.hibernate.hql;

import antlr.ASTPair;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import antlr.collections.impl.ASTArray;
import antlr.collections.impl.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.makumba.db.hibernate.hql.ExprTypeAST;
import org.makumba.db.hibernate.hql.HqlAnalyzeTokenTypes;
import org.makumba.db.hibernate.hql.ObjectType;
import org.makumba.db.hibernate.hql.ObjectTypeAST;

public class HqlAnalyzeBaseWalker
extends TreeParser
implements HqlAnalyzeTokenTypes {
    ObjectType typeComputer;
    Map aliasTypes = new HashMap();
    Stack stackAliases = new Stack();
    private int level = 0;
    private boolean inSelect = false;
    private boolean inFunctionCall = false;
    private boolean inCase = false;
    private boolean inFrom = false;
    private int statementType;
    private String statementTypeName;
    private int currentClauseType;
    private int currentTopLevelClauseType;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "ALL", "ANY", "AND", "AS", "ASCENDING", "AVG", "BETWEEN", "CLASS", "COUNT", "DELETE", "DESCENDING", "DOT", "DISTINCT", "ELEMENTS", "ESCAPE", "EXISTS", "FALSE", "FETCH", "FROM", "FULL", "GROUP", "HAVING", "IN", "INDICES", "INNER", "IS", "JOIN", "LEFT", "LIKE", "MAX", "MIN", "NEW", "NOT", "NULL", "OR", "ORDER", "OUTER", "PROPERTIES", "RIGHT", "SELECT", "SET", "SOME", "SUM", "TRUE", "UNION", "UPDATE", "WHERE", "CASE", "END", "ELSE", "THEN", "WHEN", "ON", "BOTH", "EMPTY", "LEADING", "MEMBER", "OBJECT", "OF", "TRAILING", "AGGREGATE", "ALIAS", "CONSTRUCTOR", "CASE2", "EXPR_LIST", "FILTER_ENTITY", "IN_LIST", "INDEX_OP", "IS_NOT_NULL", "IS_NULL", "METHOD_CALL", "NOT_BETWEEN", "NOT_IN", "NOT_LIKE", "ORDER_ELEMENT", "QUERY", "RANGE", "ROW_STAR", "SELECT_FROM", "UNARY_MINUS", "UNARY_PLUS", "VECTOR_EXPR", "WEIRD_IDENT", "CONSTANT", "NUM_DOUBLE", "NUM_FLOAT", "NUM_LONG", "COMMA", "EQ", "OPEN", "CLOSE", "LITERAL_by", "LITERAL_ascending", "LITERAL_descending", "NE", "SQL_NE", "LT", "GT", "LE", "GE", "CONCAT", "PLUS", "MINUS", "STAR", "DIV", "OPEN_BRACKET", "CLOSE_BRACKET", "COLON", "PARAM", "NUM_INT", "QUOTED_STRING", "IDENT", "ESCqs", "WS", "HEX_DIGIT", "EXPONENT", "FLOAT_SUFFIX", "FROM_FRAGMENT", "IMPLIED_FROM", "JOIN_FRAGMENT", "SELECT_CLAUSE", "LEFT_OUTER", "RIGHT_OUTER", "ALIAS_REF", "PROPERTY_REF", "SQL_TOKEN", "SELECT_COLUMNS", "SELECT_EXPR", "THETA_JOINS", "FILTERS", "METHOD_NAME", "NAMED_PARAM", "BOGUS", "VERSIONED", "INSERT", "INTO", "WITH"};
    public static final BitSet _tokenSet_0 = new BitSet(HqlAnalyzeBaseWalker.mk_tokenSet_0());

    AST deriveArithmethicExpr(AST aST) throws RecognitionException {
        return aST;
    }

    AST deriveLogicalExpr(AST aST) throws RecognitionException {
        return aST;
    }

    AST deriveParamExpr(AST aST) throws RecognitionException {
        return aST;
    }

    AST deriveFunctionCallExpr(AST aST, AST aST2) throws RecognitionException {
        return aST;
    }

    void setAliasType(AST aST, String string) throws RecognitionException {
    }

    void getReturnTypes(AST aST, Stack stack) throws RecognitionException {
    }

    public final boolean isSubQuery() {
        return this.level > 1;
    }

    public final boolean isInFrom() {
        return this.inFrom;
    }

    public final boolean isInFunctionCall() {
        return this.inFunctionCall;
    }

    public final boolean isInSelect() {
        return this.inSelect;
    }

    public final boolean isInCase() {
        return this.inCase;
    }

    public final int getStatementType() {
        return this.statementType;
    }

    public final int getCurrentClauseType() {
        return this.currentClauseType;
    }

    public final int getCurrentTopLevelClauseType() {
        return this.currentTopLevelClauseType;
    }

    public final boolean isComparativeExpressionClause() {
        return this.getCurrentClauseType() == 50 || this.getCurrentClauseType() == 140 || this.isInCase();
    }

    public final boolean isSelectStatement() {
        return this.statementType == 43;
    }

    void beforeStatement(String string, int n) {
        this.inFunctionCall = false;
        ++this.level;
        if (this.level == 1) {
            this.statementTypeName = string;
            this.statementType = n;
        }
    }

    private void beforeStatementCompletion(String string) {
    }

    void afterStatementCompletion(String string) {
        --this.level;
    }

    private void handleClauseStart(int n) {
        this.currentClauseType = n;
        if (this.level == 1) {
            this.currentTopLevelClauseType = n;
        }
    }

    protected void setAlias(AST aST, AST aST2) {
    }

    public HqlAnalyzeBaseWalker() {
        this.tokenNames = _tokenNames;
    }

    public final void statement(AST aST) throws RecognitionException {
        AST aST2;
        block9: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 79: {
                        this.selectStatement(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 49: {
                        this.updateStatement(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 13: {
                        this.deleteStatement(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 138: {
                        this.insertStatement(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block9;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void selectStatement(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                this.query(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void updateStatement(AST aST) throws RecognitionException {
        AST aST2;
        block12: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            AST aST12 = null;
            AST aST13 = null;
            try {
                AST aST14 = aST;
                aST4 = aST == ASTNULL ? null : aST;
                Object var16_17 = null;
                aST5 = this.astFactory.create(aST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 49);
                aST = aST.getFirstChild();
                this.beforeStatement("update", 49);
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 137: {
                        aST6 = aST;
                        Object var18_19 = null;
                        aST7 = this.astFactory.create(aST6);
                        this.match(aST, 137);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 22: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aST9 = aST == ASTNULL ? null : aST;
                this.fromClause(aST);
                aST = this._retTree;
                aST8 = this.returnAST;
                aST11 = aST == ASTNULL ? null : aST;
                this.setClause(aST);
                aST = this._retTree;
                aST10 = this.returnAST;
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 50: {
                        aST13 = aST == ASTNULL ? null : aST;
                        this.whereClause(aST);
                        aST = this._retTree;
                        aST12 = this.returnAST;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST14;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                aSTPair.root = aST2 = this.astFactory.make(new ASTArray(4).add(aST5).add(aST8).add(aST10).add(aST12));
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block12;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void deleteStatement(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 13);
                aST = aST.getFirstChild();
                this.beforeStatement("delete", 13);
                this.fromClause(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 50: {
                        this.whereClause(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void insertStatement(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 138);
                aST = aST.getFirstChild();
                this.beforeStatement("insert", 138);
                this.intoClause(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                this.query(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void query(AST aST) throws RecognitionException {
        AST aST2;
        block22: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            AST aST12 = null;
            AST aST13 = null;
            try {
                AST aST14 = aST;
                AST aST15 = null;
                AST aST16 = null;
                aST15 = this.astFactory.create(aST);
                aST16 = aST;
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 79);
                aST = aST.getFirstChild();
                this.beforeStatement("select", 43);
                AST aST17 = aST;
                AST aST18 = null;
                AST aST19 = null;
                aST18 = this.astFactory.create(aST);
                aST19 = aST;
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 82);
                aST = aST.getFirstChild();
                aST5 = aST == ASTNULL ? null : aST;
                this.fromClause(aST);
                aST = this._retTree;
                aST4 = this.returnAST;
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 43: {
                        aST7 = aST == ASTNULL ? null : aST;
                        this.selectClause(aST);
                        aST = this._retTree;
                        aST6 = this.returnAST;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair3;
                aST = aST17;
                aST = aST.getNextSibling();
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 50: {
                        aST9 = aST == ASTNULL ? null : aST;
                        this.whereClause(aST);
                        aST = this._retTree;
                        aST8 = this.returnAST;
                        break;
                    }
                    case 3: 
                    case 24: 
                    case 39: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 24: {
                        aST11 = aST == ASTNULL ? null : aST;
                        this.groupClause(aST);
                        aST = this._retTree;
                        aST10 = this.returnAST;
                        break;
                    }
                    case 3: 
                    case 39: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 39: {
                        aST13 = aST == ASTNULL ? null : aST;
                        this.orderClause(aST);
                        aST = this._retTree;
                        aST12 = this.returnAST;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST14;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                aSTPair.root = aST2 = this.astFactory.make(new ASTArray(6).add(this.astFactory.create(43, "SELECT")).add(aST6).add(aST4).add(aST8).add(aST10).add(aST12));
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block22;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void fromClause(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            try {
                AST aST6 = aST;
                aST4 = aST == ASTNULL ? null : aST;
                Object var8_9 = null;
                aST5 = this.astFactory.create(aST4);
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 22);
                aST = aST.getFirstChild();
                this.fromElementList(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST6;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void setClause(AST aST) throws RecognitionException {
        AST aST2;
        block4: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 44);
                aST = aST.getFirstChild();
                this.handleClauseStart(44);
                while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    if (aST.getType() != 92) break;
                    this.assignment(aST);
                    aST = this._retTree;
                    this.astFactory.addASTChild(aSTPair, this.returnAST);
                }
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block4;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void whereClause(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            try {
                AST aST8 = aST;
                aST4 = aST == ASTNULL ? null : aST;
                Object var10_11 = null;
                aST5 = this.astFactory.create(aST4);
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 50);
                aST = aST.getFirstChild();
                this.handleClauseStart(50);
                aST7 = aST == ASTNULL ? null : aST;
                this.logicalExpr(aST);
                aST = this._retTree;
                aST6 = this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST8;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                aSTPair.root = aST2 = this.astFactory.make(new ASTArray(2).add(aST5).add(aST6));
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void intoClause(AST aST) throws RecognitionException {
        Object var4_4;
        block2: {
            AST aST2 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            var4_4 = null;
            AST aST3 = null;
            AST aST4 = null;
            String string = null;
            try {
                AST aST5 = aST;
                AST aST6 = null;
                AST aST7 = null;
                aST6 = this.astFactory.create(aST);
                aST7 = aST;
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 139);
                aST = aST.getFirstChild();
                this.handleClauseStart(139);
                string = this.path(aST);
                aST = this._retTree;
                aST4 = aST == ASTNULL ? null : aST;
                this.insertablePropertySpec(aST);
                aST = this._retTree;
                aST3 = this.returnAST;
                aSTPair = aSTPair2;
                aST = aST5;
                aST = aST.getNextSibling();
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = var4_4;
        this._retTree = aST;
    }

    public final String path(AST aST) throws RecognitionException {
        String string;
        AST aST2;
        block7: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            string = "???";
            String string2 = "?x?";
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 86: 
                    case 115: {
                        aST5 = aST == ASTNULL ? null : aST;
                        this.identifier(aST);
                        aST = this._retTree;
                        aST4 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        string = aST5.getText();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 15: {
                        AST aST8 = aST;
                        AST aST9 = null;
                        AST aST10 = null;
                        aST9 = this.astFactory.create(aST);
                        aST10 = aST;
                        this.astFactory.addASTChild(aSTPair, aST9);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 15);
                        aST = aST.getFirstChild();
                        string2 = this.path(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST7 = aST == ASTNULL ? null : aST;
                        this.identifier(aST);
                        aST = this._retTree;
                        aST6 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST8;
                        aST = aST.getNextSibling();
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(string2).append(".").append(aST7.getText());
                        string = stringBuffer.toString();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
        return string;
    }

    public final void insertablePropertySpec(AST aST) throws RecognitionException {
        AST aST2;
        block5: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 80);
                aST = aST.getFirstChild();
                int n = 0;
                while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    if (aST.getType() != 115) {
                        if (n >= 1) break;
                        throw new NoViableAltException(aST);
                    }
                    AST aST7 = null;
                    AST aST8 = null;
                    aST7 = this.astFactory.create(aST);
                    aST8 = aST;
                    this.astFactory.addASTChild(aSTPair, aST7);
                    this.match(aST, 115);
                    aST = aST.getNextSibling();
                    ++n;
                }
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block5;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void assignment(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            try {
                AST aST6 = aST;
                AST aST7 = null;
                AST aST8 = null;
                aST7 = this.astFactory.create(aST);
                aST8 = aST;
                this.astFactory.addASTChild(aSTPair, aST7);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 92);
                aST = aST.getFirstChild();
                aST5 = aST == ASTNULL ? null : aST;
                this.propertyRef(aST);
                aST = this._retTree;
                aST4 = this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                this.newValue(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST6;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void propertyRef(AST aST) throws RecognitionException {
        Object object;
        block7: {
            AST aST2 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            object = null;
            AST aST3 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 15: {
                        AST aST9 = aST;
                        AST aST10 = null;
                        AST aST11 = null;
                        aST10 = this.astFactory.create(aST);
                        aST11 = aST;
                        this.astFactory.addASTChild(aSTPair, aST10);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 15);
                        aST = aST.getFirstChild();
                        aST4 = aST == ASTNULL ? null : aST;
                        this.propertyRefLhs(aST);
                        aST = this._retTree;
                        aST3 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST6 = aST == ASTNULL ? null : aST;
                        this.propertyName(aST);
                        aST = this._retTree;
                        aST5 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST9;
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = new ObjectTypeAST(aST3, aST5, this.aliasTypes, this.typeComputer);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 86: 
                    case 115: {
                        aST8 = aST == ASTNULL ? null : aST;
                        this.identifier(aST);
                        aST = this._retTree;
                        aST7 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        aSTPair.root = object = new ObjectTypeAST(aST7, this.aliasTypes);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = object;
        this._retTree = aST;
    }

    public final void newValue(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 12: 
                    case 15: 
                    case 20: 
                    case 37: 
                    case 47: 
                    case 51: 
                    case 64: 
                    case 67: 
                    case 71: 
                    case 74: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: {
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 79: {
                        this.query(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void expr(AST aST) throws RecognitionException {
        Object object;
        block14: {
            AST aST2 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            object = null;
            AST aST3 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 15: 
                    case 71: 
                    case 86: 
                    case 115: {
                        aST4 = aST == ASTNULL ? null : aST;
                        this.addrExpr(aST, true);
                        aST = this._retTree;
                        aST3 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        break;
                    }
                    case 85: {
                        AST aST9 = aST;
                        AST aST10 = null;
                        AST aST11 = null;
                        aST10 = this.astFactory.create(aST);
                        aST11 = aST;
                        this.astFactory.addASTChild(aSTPair, aST10);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 85);
                        aST = aST.getFirstChild();
                        while (true) {
                            if (aST == null) {
                                aST = ASTNULL;
                            }
                            if (!_tokenSet_0.member(aST.getType())) break;
                            this.expr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                        }
                        aSTPair = aSTPair2;
                        aST = aST9;
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        break;
                    }
                    case 20: 
                    case 37: 
                    case 47: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 113: 
                    case 114: {
                        this.constant(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        break;
                    }
                    case 51: 
                    case 67: 
                    case 83: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: {
                        aST6 = aST == ASTNULL ? null : aST;
                        this.arithmeticExpr(aST);
                        aST = this._retTree;
                        aST5 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        aSTPair.root = object = this.deriveArithmethicExpr(aST5);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 64: 
                    case 74: {
                        this.functionCall(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        break;
                    }
                    case 111: 
                    case 112: {
                        aST8 = aST == ASTNULL ? null : aST;
                        this.parameter(aST);
                        aST = this._retTree;
                        aST7 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        aSTPair.root = object = this.deriveParamExpr(aST7);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 12: {
                        this.count(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        aSTPair.root = object = new ExprTypeAST(4);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block14;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = object;
        this._retTree = aST;
    }

    public final void selectClause(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            try {
                AST aST8 = aST;
                AST aST9 = null;
                AST aST10 = null;
                aST9 = this.astFactory.create(aST);
                aST10 = aST;
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 43);
                aST = aST.getFirstChild();
                this.handleClauseStart(43);
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 16: {
                        aST4 = aST;
                        Object var13_14 = null;
                        aST5 = this.astFactory.create(aST4);
                        this.match(aST, 16);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 12: 
                    case 15: 
                    case 17: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 32: 
                    case 36: 
                    case 38: 
                    case 51: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 83: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 92: 
                    case 98: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 113: 
                    case 114: 
                    case 115: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aST7 = aST == ASTNULL ? null : aST;
                this.selectExprList(aST);
                aST = this._retTree;
                aST6 = this.returnAST;
                aSTPair = aSTPair2;
                aST = aST8;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                aST2 = this.astFactory.make(new ASTArray(3).add(this.astFactory.create(124, "{select clause}")).add(aST5).add(aST6));
                this.getReturnTypes(aST2, this.stackAliases);
                aSTPair.root = aST2;
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void groupClause(AST aST) throws RecognitionException {
        AST aST2;
        block10: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 24);
                aST = aST.getFirstChild();
                this.handleClauseStart(24);
                int n = 0;
                while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    if (!_tokenSet_0.member(aST.getType())) {
                        if (n >= 1) break;
                        throw new NoViableAltException(aST);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    this.astFactory.addASTChild(aSTPair, this.returnAST);
                    ++n;
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 25: {
                        AST aST7 = aST;
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 25);
                        aST = aST.getFirstChild();
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST7;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block10;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void orderClause(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 39);
                aST = aST.getFirstChild();
                this.handleClauseStart(39);
                this.orderExprs(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void orderExprs(AST aST) throws RecognitionException {
        AST aST2;
        block13: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                this.expr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 8: {
                        AST aST4 = null;
                        AST aST5 = null;
                        aST4 = this.astFactory.create(aST);
                        aST5 = aST;
                        this.astFactory.addASTChild(aSTPair, aST4);
                        this.match(aST, 8);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 14: {
                        AST aST6 = null;
                        AST aST7 = null;
                        aST6 = this.astFactory.create(aST);
                        aST7 = aST;
                        this.astFactory.addASTChild(aSTPair, aST6);
                        this.match(aST, 14);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 3: 
                    case 12: 
                    case 15: 
                    case 20: 
                    case 37: 
                    case 47: 
                    case 51: 
                    case 64: 
                    case 67: 
                    case 71: 
                    case 74: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 12: 
                    case 15: 
                    case 20: 
                    case 37: 
                    case 47: 
                    case 51: 
                    case 64: 
                    case 67: 
                    case 71: 
                    case 74: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: {
                        this.orderExprs(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block13;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void logicalExpr(AST aST) throws RecognitionException {
        AST aST2;
        block9: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 6: {
                        AST aST6 = aST;
                        AST aST7 = null;
                        AST aST8 = null;
                        aST7 = this.astFactory.create(aST);
                        aST8 = aST;
                        this.astFactory.addASTChild(aSTPair, aST7);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 6);
                        aST = aST.getFirstChild();
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST6;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 38: {
                        AST aST9 = aST;
                        AST aST10 = null;
                        AST aST11 = null;
                        aST10 = this.astFactory.create(aST);
                        aST11 = aST;
                        this.astFactory.addASTChild(aSTPair, aST10);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 38);
                        aST = aST.getFirstChild();
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST9;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 36: {
                        AST aST12 = aST;
                        AST aST13 = null;
                        AST aST14 = null;
                        aST13 = this.astFactory.create(aST);
                        aST14 = aST;
                        this.astFactory.addASTChild(aSTPair, aST13);
                        ASTPair aSTPair4 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 36);
                        aST = aST.getFirstChild();
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair4;
                        aST = aST12;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 10: 
                    case 19: 
                    case 26: 
                    case 32: 
                    case 72: 
                    case 73: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 92: 
                    case 98: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: {
                        aST5 = aST == ASTNULL ? null : aST;
                        this.comparisonExpr(aST);
                        aST = this._retTree;
                        aST4 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        aSTPair.root = aST2 = this.deriveLogicalExpr(aST4);
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block9;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void selectExprList(AST aST) throws RecognitionException {
        AST aST2;
        block8: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            boolean bl = this.inSelect;
            this.inSelect = true;
            try {
                int n = 0;
                block6: while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 4: 
                        case 6: 
                        case 10: 
                        case 12: 
                        case 15: 
                        case 17: 
                        case 19: 
                        case 26: 
                        case 27: 
                        case 32: 
                        case 36: 
                        case 38: 
                        case 51: 
                        case 61: 
                        case 64: 
                        case 66: 
                        case 67: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 83: 
                        case 86: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 92: 
                        case 98: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 113: 
                        case 114: 
                        case 115: {
                            this.selectExpr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            break;
                        }
                        case 7: {
                            this.aliasedSelectExpr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            break;
                        }
                        default: {
                            if (n >= 1) break block6;
                            throw new NoViableAltException(aST);
                        }
                    }
                    ++n;
                }
                this.inSelect = bl;
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block8;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void selectExpr(AST aST) throws RecognitionException {
        Object object;
        block15: {
            AST aST2 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            object = null;
            AST aST3 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            AST aST12 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 15: 
                    case 86: 
                    case 115: {
                        aST4 = aST == ASTNULL ? null : aST;
                        this.propertyRef(aST);
                        aST = this._retTree;
                        aST3 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        break;
                    }
                    case 4: {
                        AST aST13 = aST;
                        AST aST14 = null;
                        AST aST15 = null;
                        aST14 = this.astFactory.create(aST);
                        aST15 = aST;
                        this.astFactory.addASTChild(aSTPair, aST14);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 4);
                        aST = aST.getFirstChild();
                        aST6 = aST == ASTNULL ? null : aST;
                        this.aliasRef(aST);
                        aST = this._retTree;
                        aST5 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST13;
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = aST5;
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 61: {
                        AST aST16 = aST;
                        AST aST17 = null;
                        AST aST18 = null;
                        aST17 = this.astFactory.create(aST);
                        aST18 = aST;
                        this.astFactory.addASTChild(aSTPair, aST17);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 61);
                        aST = aST.getFirstChild();
                        aST8 = aST == ASTNULL ? null : aST;
                        this.aliasRef(aST);
                        aST = this._retTree;
                        aST7 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST16;
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = aST7;
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 66: {
                        aST10 = aST == ASTNULL ? null : aST;
                        this.constructor(aST);
                        aST = this._retTree;
                        aST9 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        break;
                    }
                    case 64: 
                    case 74: {
                        this.functionCall(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        break;
                    }
                    case 12: {
                        this.count(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        aSTPair.root = object = new ExprTypeAST(4);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 17: 
                    case 27: {
                        this.collectionFunction(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        break;
                    }
                    case 88: 
                    case 89: 
                    case 90: 
                    case 113: 
                    case 114: {
                        this.literal(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        break;
                    }
                    case 51: 
                    case 67: 
                    case 83: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: {
                        aST12 = aST == ASTNULL ? null : aST;
                        this.arithmeticExpr(aST);
                        aST = this._retTree;
                        aST11 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        aSTPair.root = object = this.deriveArithmethicExpr(aST11);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 6: 
                    case 10: 
                    case 19: 
                    case 26: 
                    case 32: 
                    case 36: 
                    case 38: 
                    case 72: 
                    case 73: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 92: 
                    case 98: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: {
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block15;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = object;
        this._retTree = aST;
    }

    public final void aliasedSelectExpr(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            try {
                AST aST8 = aST;
                AST aST9 = null;
                AST aST10 = null;
                aST9 = this.astFactory.create(aST);
                aST10 = aST;
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 7);
                aST = aST.getFirstChild();
                aST5 = aST == ASTNULL ? null : aST;
                this.selectExpr(aST);
                aST = this._retTree;
                aST4 = this.returnAST;
                aST7 = aST == ASTNULL ? null : aST;
                this.identifier(aST);
                aST = this._retTree;
                aST6 = this.returnAST;
                aSTPair = aSTPair2;
                aST = aST8;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                this.setAlias(aST4, aST6);
                aSTPair.root = aST2 = aST4;
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void identifier(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 115: {
                        AST aST4 = null;
                        AST aST5 = null;
                        aST4 = this.astFactory.create(aST);
                        aST5 = aST;
                        this.astFactory.addASTChild(aSTPair, aST4);
                        this.match(aST, 115);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 86: {
                        AST aST6 = null;
                        AST aST7 = null;
                        aST6 = this.astFactory.create(aST);
                        aST7 = aST;
                        this.astFactory.addASTChild(aSTPair, aST6);
                        this.match(aST, 86);
                        aST = aST.getNextSibling();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void aliasRef(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            try {
                aST5 = aST == ASTNULL ? null : aST;
                this.identifier(aST);
                aST = this._retTree;
                aST4 = this.returnAST;
                aST2 = aSTPair.root;
                aSTPair.root = aST2 = this.astFactory.make(new ASTArray(1).add(this.astFactory.create(127, aST5.getText())));
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void constructor(AST aST) throws RecognitionException {
        AST aST2;
        block8: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            String string = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 66);
                aST = aST.getFirstChild();
                string = this.path(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                block6: while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 4: 
                        case 6: 
                        case 10: 
                        case 12: 
                        case 15: 
                        case 17: 
                        case 19: 
                        case 26: 
                        case 27: 
                        case 32: 
                        case 36: 
                        case 38: 
                        case 51: 
                        case 61: 
                        case 64: 
                        case 66: 
                        case 67: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 83: 
                        case 86: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 92: 
                        case 98: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 113: 
                        case 114: 
                        case 115: {
                            this.selectExpr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            continue block6;
                        }
                        case 7: {
                            this.aliasedSelectExpr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            continue block6;
                        }
                    }
                    break;
                }
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block8;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void functionCall(AST aST) throws RecognitionException {
        AST aST2;
        block14: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 74: {
                        AST aST8 = aST;
                        AST aST9 = null;
                        AST aST10 = null;
                        aST9 = this.astFactory.create(aST);
                        aST10 = aST;
                        this.astFactory.addASTChild(aSTPair, aST9);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 74);
                        aST = aST.getFirstChild();
                        this.inFunctionCall = true;
                        aST5 = aST == ASTNULL ? null : aST;
                        this.pathAsIdent(aST);
                        aST = this._retTree;
                        aST4 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 68: {
                                AST aST11 = aST;
                                aST6 = aST == ASTNULL ? null : aST;
                                Object var14_19 = null;
                                aST7 = this.astFactory.create(aST6);
                                this.astFactory.addASTChild(aSTPair, aST7);
                                ASTPair aSTPair3 = aSTPair.copy();
                                aSTPair.root = aSTPair.child;
                                aSTPair.child = null;
                                this.match(aST, 68);
                                aST = aST.getFirstChild();
                                while (true) {
                                    if (aST == null) {
                                        aST = ASTNULL;
                                    }
                                    if (!_tokenSet_0.member(aST.getType())) break;
                                    this.expr(aST);
                                    aST = this._retTree;
                                    this.astFactory.addASTChild(aSTPair, this.returnAST);
                                }
                                aSTPair = aSTPair3;
                                aST = aST11;
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair2;
                        aST = aST8;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        aSTPair.root = aST2 = this.deriveFunctionCallExpr(aST4, aST7);
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        this.inFunctionCall = false;
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 64: {
                        AST aST12 = aST;
                        AST aST13 = null;
                        AST aST14 = null;
                        aST13 = this.astFactory.create(aST);
                        aST14 = aST;
                        this.astFactory.addASTChild(aSTPair, aST13);
                        ASTPair aSTPair4 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 64);
                        aST = aST.getFirstChild();
                        this.aggregateExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair4;
                        aST = aST12;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block14;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void count(AST aST) throws RecognitionException {
        AST aST2;
        block13: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4;
                AST aST5;
                AST aST6 = aST;
                AST aST7 = null;
                AST aST8 = null;
                aST7 = this.astFactory.create(aST);
                aST8 = aST;
                this.astFactory.addASTChild(aSTPair, aST7);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 12);
                aST = aST.getFirstChild();
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 16: {
                        aST5 = null;
                        aST4 = null;
                        aST5 = this.astFactory.create(aST);
                        aST4 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        this.match(aST, 16);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 4: {
                        aST5 = null;
                        aST4 = null;
                        aST5 = this.astFactory.create(aST);
                        aST4 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        this.match(aST, 4);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 12: 
                    case 15: 
                    case 17: 
                    case 20: 
                    case 27: 
                    case 37: 
                    case 47: 
                    case 51: 
                    case 64: 
                    case 67: 
                    case 71: 
                    case 74: 
                    case 81: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 12: 
                    case 15: 
                    case 17: 
                    case 20: 
                    case 27: 
                    case 37: 
                    case 47: 
                    case 51: 
                    case 64: 
                    case 67: 
                    case 71: 
                    case 74: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: {
                        this.aggregateExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        break;
                    }
                    case 81: {
                        aST5 = null;
                        aST4 = null;
                        aST5 = this.astFactory.create(aST);
                        aST4 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        this.match(aST, 81);
                        aST = aST.getNextSibling();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST6;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block13;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void collectionFunction(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 17: {
                        AST aST12 = aST;
                        aST4 = aST == ASTNULL ? null : aST;
                        Object var14_16 = null;
                        aST5 = this.astFactory.create(aST4);
                        this.astFactory.addASTChild(aSTPair, aST5);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 17);
                        aST = aST.getFirstChild();
                        this.inFunctionCall = true;
                        aST7 = aST == ASTNULL ? null : aST;
                        this.propertyRef(aST);
                        aST = this._retTree;
                        aST6 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST12;
                        aST = aST.getNextSibling();
                        this.inFunctionCall = false;
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 27: {
                        AST aST13 = aST;
                        aST8 = aST == ASTNULL ? null : aST;
                        Object var14_17 = null;
                        aST9 = this.astFactory.create(aST8);
                        this.astFactory.addASTChild(aSTPair, aST9);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 27);
                        aST = aST.getFirstChild();
                        this.inFunctionCall = true;
                        aST11 = aST == ASTNULL ? null : aST;
                        this.propertyRef(aST);
                        aST = this._retTree;
                        aST10 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST13;
                        aST = aST.getNextSibling();
                        this.inFunctionCall = false;
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void literal(AST aST) throws RecognitionException {
        Object object;
        block10: {
            AST aST2 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            object = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 113: {
                        AST aST3 = null;
                        AST aST4 = null;
                        aST3 = this.astFactory.create(aST);
                        aST4 = aST;
                        this.astFactory.addASTChild(aSTPair, aST3);
                        this.match(aST, 113);
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = new ExprTypeAST(4);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 89: {
                        AST aST5 = null;
                        AST aST6 = null;
                        aST5 = this.astFactory.create(aST);
                        aST6 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        this.match(aST, 89);
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = new ExprTypeAST(3);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 90: {
                        AST aST7 = null;
                        AST aST8 = null;
                        aST7 = this.astFactory.create(aST);
                        aST8 = aST;
                        this.astFactory.addASTChild(aSTPair, aST7);
                        this.match(aST, 90);
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = new ExprTypeAST(4);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 88: {
                        AST aST9 = null;
                        AST aST10 = null;
                        aST9 = this.astFactory.create(aST);
                        aST10 = aST;
                        this.astFactory.addASTChild(aSTPair, aST9);
                        this.match(aST, 88);
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = new ExprTypeAST(15);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 114: {
                        AST aST11 = null;
                        AST aST12 = null;
                        aST11 = this.astFactory.create(aST);
                        aST12 = aST;
                        this.astFactory.addASTChild(aSTPair, aST11);
                        this.match(aST, 114);
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = new ExprTypeAST(6);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block10;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = object;
        this._retTree = aST;
    }

    public final void arithmeticExpr(AST aST) throws RecognitionException {
        AST aST2;
        block11: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 105: {
                        AST aST4 = aST;
                        AST aST5 = null;
                        AST aST6 = null;
                        aST5 = this.astFactory.create(aST);
                        aST6 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 105);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST4;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 106: {
                        AST aST7 = aST;
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 106);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST7;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 108: {
                        AST aST10 = aST;
                        AST aST11 = null;
                        AST aST12 = null;
                        aST11 = this.astFactory.create(aST);
                        aST12 = aST;
                        this.astFactory.addASTChild(aSTPair, aST11);
                        ASTPair aSTPair4 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 108);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair4;
                        aST = aST10;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 107: {
                        AST aST13 = aST;
                        AST aST14 = null;
                        AST aST15 = null;
                        aST14 = this.astFactory.create(aST);
                        aST15 = aST;
                        this.astFactory.addASTChild(aSTPair, aST14);
                        ASTPair aSTPair5 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 107);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair5;
                        aST = aST13;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 83: {
                        AST aST16 = aST;
                        AST aST17 = null;
                        AST aST18 = null;
                        aST17 = this.astFactory.create(aST);
                        aST18 = aST;
                        this.astFactory.addASTChild(aSTPair, aST17);
                        ASTPair aSTPair6 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 83);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair6;
                        aST = aST16;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 51: 
                    case 67: {
                        this.caseExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block11;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void aggregateExpr(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 12: 
                    case 15: 
                    case 20: 
                    case 37: 
                    case 47: 
                    case 51: 
                    case 64: 
                    case 67: 
                    case 71: 
                    case 74: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: {
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 17: 
                    case 27: {
                        this.collectionFunction(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void fromElementList(AST aST) throws RecognitionException {
        AST aST2;
        block5: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            boolean bl = this.inFrom;
            this.inFrom = true;
            try {
                int n = 0;
                while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    if (aST.getType() != 30 && aST.getType() != 69 && aST.getType() != 80) {
                        if (n >= 1) break;
                        throw new NoViableAltException(aST);
                    }
                    this.fromElement(aST);
                    aST = this._retTree;
                    this.astFactory.addASTChild(aSTPair, this.returnAST);
                    ++n;
                }
                this.inFrom = bl;
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block5;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void fromElement(AST aST) throws RecognitionException {
        Object var4_4;
        block18: {
            AST aST2 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            var4_4 = null;
            AST aST3 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            AST aST12 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 80: {
                        Object var20_23;
                        AST aST13 = aST;
                        AST aST14 = null;
                        AST aST15 = null;
                        aST14 = this.astFactory.create(aST);
                        aST15 = aST;
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 80);
                        aST = aST.getFirstChild();
                        String string = this.path(aST);
                        aST = this._retTree;
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 65: {
                                aST3 = aST;
                                var20_23 = null;
                                aST4 = this.astFactory.create(aST3);
                                this.match(aST, 65);
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: 
                            case 21: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 21: {
                                aST5 = aST;
                                var20_23 = null;
                                aST6 = this.astFactory.create(aST5);
                                this.match(aST, 21);
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair2;
                        aST = aST13;
                        aST = aST.getNextSibling();
                        this.setAliasType(aST4, string);
                        break;
                    }
                    case 30: {
                        aST8 = aST == ASTNULL ? null : aST;
                        this.joinElement(aST);
                        aST = this._retTree;
                        aST7 = this.returnAST;
                        break;
                    }
                    case 69: {
                        aST9 = aST;
                        Object var16_16 = null;
                        aST10 = this.astFactory.create(aST9);
                        this.match(aST, 69);
                        aST11 = aST = aST.getNextSibling();
                        Object var17_19 = null;
                        aST12 = this.astFactory.create(aST11);
                        this.match(aST, 65);
                        aST = aST.getNextSibling();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block18;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = var4_4;
        this._retTree = aST;
    }

    public final void joinElement(AST aST) throws RecognitionException {
        Object var4_4;
        block27: {
            AST aST2 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            var4_4 = null;
            AST aST3 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            try {
                AST aST7;
                AST aST8;
                AST aST9 = aST;
                AST aST10 = null;
                AST aST11 = null;
                aST10 = this.astFactory.create(aST);
                aST11 = aST;
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 30);
                aST = aST.getFirstChild();
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 23: 
                    case 28: 
                    case 31: 
                    case 42: {
                        this.joinType(aST);
                        aST = this._retTree;
                        break;
                    }
                    case 15: 
                    case 21: 
                    case 86: 
                    case 115: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 21: {
                        aST8 = null;
                        aST7 = null;
                        aST8 = this.astFactory.create(aST);
                        aST7 = aST;
                        this.match(aST, 21);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 15: 
                    case 86: 
                    case 115: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aST4 = aST == ASTNULL ? null : aST;
                this.propertyRef(aST);
                aST = this._retTree;
                aST3 = this.returnAST;
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 65: {
                        aST5 = aST;
                        aST8 = null;
                        aST6 = this.astFactory.create(aST5);
                        this.match(aST, 65);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 3: 
                    case 21: 
                    case 140: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 21: {
                        aST8 = null;
                        aST7 = null;
                        aST8 = this.astFactory.create(aST);
                        aST7 = aST;
                        this.match(aST, 21);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 3: 
                    case 140: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 140: {
                        aST8 = null;
                        aST7 = null;
                        aST8 = this.astFactory.create(aST);
                        aST7 = aST;
                        this.match(aST, 140);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST9;
                aST = aST.getNextSibling();
                this.setAliasType(aST6, ((ObjectTypeAST)aST3).getObjectType());
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block27;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = var4_4;
        this._retTree = aST;
    }

    public final void joinType(AST aST) throws RecognitionException {
        AST aST2;
        block18: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 31: 
                    case 42: {
                        AST aST4;
                        AST aST5;
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 31: {
                                aST5 = null;
                                aST4 = null;
                                aST5 = this.astFactory.create(aST);
                                aST4 = aST;
                                this.astFactory.addASTChild(aSTPair, aST5);
                                this.match(aST, 31);
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 42: {
                                aST5 = null;
                                aST4 = null;
                                aST5 = this.astFactory.create(aST);
                                aST4 = aST;
                                this.astFactory.addASTChild(aSTPair, aST5);
                                this.match(aST, 42);
                                aST = aST.getNextSibling();
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 40: {
                                aST5 = null;
                                aST4 = null;
                                aST5 = this.astFactory.create(aST);
                                aST4 = aST;
                                this.astFactory.addASTChild(aSTPair, aST5);
                                this.match(aST, 40);
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 15: 
                            case 21: 
                            case 86: 
                            case 115: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 23: {
                        AST aST6 = null;
                        AST aST7 = null;
                        aST6 = this.astFactory.create(aST);
                        aST7 = aST;
                        this.astFactory.addASTChild(aSTPair, aST6);
                        this.match(aST, 23);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 28: {
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        this.match(aST, 28);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block18;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void pathAsIdent(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            String string = "?text?";
            try {
                string = this.path(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aST2 = aSTPair.root;
                aSTPair.root = aST2 = this.astFactory.make(new ASTArray(1).add(this.astFactory.create(115, string)));
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void comparisonExpr(AST aST) throws RecognitionException {
        AST aST2;
        block35: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 92: {
                        AST aST4 = aST;
                        AST aST5 = null;
                        AST aST6 = null;
                        aST5 = this.astFactory.create(aST);
                        aST6 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 92);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST4;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 98: {
                        AST aST7 = aST;
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 98);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST7;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 100: {
                        AST aST10 = aST;
                        AST aST11 = null;
                        AST aST12 = null;
                        aST11 = this.astFactory.create(aST);
                        aST12 = aST;
                        this.astFactory.addASTChild(aSTPair, aST11);
                        ASTPair aSTPair4 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 100);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair4;
                        aST = aST10;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 101: {
                        AST aST13 = aST;
                        AST aST14 = null;
                        AST aST15 = null;
                        aST14 = this.astFactory.create(aST);
                        aST15 = aST;
                        this.astFactory.addASTChild(aSTPair, aST14);
                        ASTPair aSTPair5 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 101);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair5;
                        aST = aST13;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 102: {
                        AST aST16 = aST;
                        AST aST17 = null;
                        AST aST18 = null;
                        aST17 = this.astFactory.create(aST);
                        aST18 = aST;
                        this.astFactory.addASTChild(aSTPair, aST17);
                        ASTPair aSTPair6 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 102);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair6;
                        aST = aST16;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 103: {
                        AST aST19 = aST;
                        AST aST20 = null;
                        AST aST21 = null;
                        aST20 = this.astFactory.create(aST);
                        aST21 = aST;
                        this.astFactory.addASTChild(aSTPair, aST20);
                        ASTPair aSTPair7 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 103);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair7;
                        aST = aST19;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 32: {
                        AST aST22 = aST;
                        AST aST23 = null;
                        AST aST24 = null;
                        aST23 = this.astFactory.create(aST);
                        aST24 = aST;
                        this.astFactory.addASTChild(aSTPair, aST23);
                        ASTPair aSTPair8 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 32);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 18: {
                                AST aST25 = aST;
                                AST aST26 = null;
                                AST aST27 = null;
                                aST26 = this.astFactory.create(aST);
                                aST27 = aST;
                                this.astFactory.addASTChild(aSTPair, aST26);
                                ASTPair aSTPair9 = aSTPair.copy();
                                aSTPair.root = aSTPair.child;
                                aSTPair.child = null;
                                this.match(aST, 18);
                                aST = aST.getFirstChild();
                                this.expr(aST);
                                aST = this._retTree;
                                this.astFactory.addASTChild(aSTPair, this.returnAST);
                                aSTPair = aSTPair9;
                                aST = aST25;
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair8;
                        aST = aST22;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 77: {
                        AST aST28 = aST;
                        AST aST29 = null;
                        AST aST30 = null;
                        aST29 = this.astFactory.create(aST);
                        aST30 = aST;
                        this.astFactory.addASTChild(aSTPair, aST29);
                        ASTPair aSTPair10 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 77);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 18: {
                                AST aST31 = aST;
                                AST aST32 = null;
                                AST aST33 = null;
                                aST32 = this.astFactory.create(aST);
                                aST33 = aST;
                                this.astFactory.addASTChild(aSTPair, aST32);
                                ASTPair aSTPair11 = aSTPair.copy();
                                aSTPair.root = aSTPair.child;
                                aSTPair.child = null;
                                this.match(aST, 18);
                                aST = aST.getFirstChild();
                                this.expr(aST);
                                aST = this._retTree;
                                this.astFactory.addASTChild(aSTPair, this.returnAST);
                                aSTPair = aSTPair11;
                                aST = aST31;
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair10;
                        aST = aST28;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 10: {
                        AST aST34 = aST;
                        AST aST35 = null;
                        AST aST36 = null;
                        aST35 = this.astFactory.create(aST);
                        aST36 = aST;
                        this.astFactory.addASTChild(aSTPair, aST35);
                        ASTPair aSTPair12 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 10);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair12;
                        aST = aST34;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 75: {
                        AST aST37 = aST;
                        AST aST38 = null;
                        AST aST39 = null;
                        aST38 = this.astFactory.create(aST);
                        aST39 = aST;
                        this.astFactory.addASTChild(aSTPair, aST38);
                        ASTPair aSTPair13 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 75);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair13;
                        aST = aST37;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 26: {
                        AST aST40 = aST;
                        AST aST41 = null;
                        AST aST42 = null;
                        aST41 = this.astFactory.create(aST);
                        aST42 = aST;
                        this.astFactory.addASTChild(aSTPair, aST41);
                        ASTPair aSTPair14 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 26);
                        aST = aST.getFirstChild();
                        this.inLhs(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.inRhs(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair14;
                        aST = aST40;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 76: {
                        AST aST43 = aST;
                        AST aST44 = null;
                        AST aST45 = null;
                        aST44 = this.astFactory.create(aST);
                        aST45 = aST;
                        this.astFactory.addASTChild(aSTPair, aST44);
                        ASTPair aSTPair15 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 76);
                        aST = aST.getFirstChild();
                        this.inLhs(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.inRhs(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair15;
                        aST = aST43;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 73: {
                        AST aST46 = aST;
                        AST aST47 = null;
                        AST aST48 = null;
                        aST47 = this.astFactory.create(aST);
                        aST48 = aST;
                        this.astFactory.addASTChild(aSTPair, aST47);
                        ASTPair aSTPair16 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 73);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair16;
                        aST = aST46;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 72: {
                        AST aST49 = aST;
                        AST aST50 = null;
                        AST aST51 = null;
                        aST50 = this.astFactory.create(aST);
                        aST51 = aST;
                        this.astFactory.addASTChild(aSTPair, aST50);
                        ASTPair aSTPair17 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 72);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair17;
                        aST = aST49;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 19: {
                        AST aST52 = aST;
                        AST aST53 = null;
                        AST aST54 = null;
                        aST53 = this.astFactory.create(aST);
                        aST54 = aST;
                        this.astFactory.addASTChild(aSTPair, aST53);
                        ASTPair aSTPair18 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 19);
                        aST = aST.getFirstChild();
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 12: 
                            case 15: 
                            case 20: 
                            case 37: 
                            case 47: 
                            case 51: 
                            case 64: 
                            case 67: 
                            case 71: 
                            case 74: 
                            case 83: 
                            case 85: 
                            case 86: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: {
                                this.expr(aST);
                                aST = this._retTree;
                                this.astFactory.addASTChild(aSTPair, this.returnAST);
                                break;
                            }
                            case 17: 
                            case 27: 
                            case 79: {
                                this.collectionFunctionOrSubselect(aST);
                                aST = this._retTree;
                                this.astFactory.addASTChild(aSTPair, this.returnAST);
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair18;
                        aST = aST52;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block35;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void exprOrSubquery(AST aST) throws RecognitionException {
        AST aST2;
        block10: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 12: 
                    case 15: 
                    case 20: 
                    case 37: 
                    case 47: 
                    case 51: 
                    case 64: 
                    case 67: 
                    case 71: 
                    case 74: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: {
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 79: {
                        this.query(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 5: {
                        AST aST4 = aST;
                        AST aST5 = null;
                        AST aST6 = null;
                        aST5 = this.astFactory.create(aST);
                        aST6 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 5);
                        aST = aST.getFirstChild();
                        this.collectionFunctionOrSubselect(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST4;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 4: {
                        AST aST7 = aST;
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 4);
                        aST = aST.getFirstChild();
                        this.collectionFunctionOrSubselect(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST7;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 45: {
                        AST aST10 = aST;
                        AST aST11 = null;
                        AST aST12 = null;
                        aST11 = this.astFactory.create(aST);
                        aST12 = aST;
                        this.astFactory.addASTChild(aSTPair, aST11);
                        ASTPair aSTPair4 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 45);
                        aST = aST.getFirstChild();
                        this.collectionFunctionOrSubselect(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair4;
                        aST = aST10;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block10;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void inLhs(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                this.expr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void inRhs(AST aST) throws RecognitionException {
        AST aST2;
        block9: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 70);
                aST = aST.getFirstChild();
                if (aST == null) {
                    aST = ASTNULL;
                }
                block1 : switch (aST.getType()) {
                    case 17: 
                    case 27: 
                    case 79: {
                        this.collectionFunctionOrSubselect(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        break;
                    }
                    case 3: 
                    case 12: 
                    case 15: 
                    case 20: 
                    case 37: 
                    case 47: 
                    case 51: 
                    case 64: 
                    case 67: 
                    case 71: 
                    case 74: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: {
                        while (true) {
                            if (aST == null) {
                                aST = ASTNULL;
                            }
                            if (!_tokenSet_0.member(aST.getType())) break block1;
                            this.expr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                        }
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block9;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void collectionFunctionOrSubselect(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 17: 
                    case 27: {
                        this.collectionFunction(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 79: {
                        this.query(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void addrExpr(AST aST, boolean bl) throws RecognitionException {
        Object object;
        block8: {
            AST aST2 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            object = null;
            AST aST3 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            AST aST12 = null;
            AST aST13 = null;
            AST aST14 = null;
            AST aST15 = null;
            AST aST16 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 15: {
                        AST aST17 = aST;
                        aST3 = aST == ASTNULL ? null : aST;
                        Object var21_23 = null;
                        aST4 = this.astFactory.create(aST3);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 15);
                        aST = aST.getFirstChild();
                        aST6 = aST == ASTNULL ? null : aST;
                        this.addrExprLhs(aST);
                        aST = this._retTree;
                        aST5 = this.returnAST;
                        aST8 = aST == ASTNULL ? null : aST;
                        this.propertyName(aST);
                        aST = this._retTree;
                        aST7 = this.returnAST;
                        aSTPair = aSTPair2;
                        aST = aST17;
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = new ObjectTypeAST(aST5, aST7, this.aliasTypes, this.typeComputer);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    case 71: {
                        AST aST18 = aST;
                        aST9 = aST == ASTNULL ? null : aST;
                        Object var21_24 = null;
                        aST10 = this.astFactory.create(aST9);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 71);
                        aST = aST.getFirstChild();
                        aST12 = aST == ASTNULL ? null : aST;
                        this.addrExprLhs(aST);
                        aST = this._retTree;
                        aST11 = this.returnAST;
                        aST14 = aST == ASTNULL ? null : aST;
                        this.expr(aST);
                        aST = this._retTree;
                        aST13 = this.returnAST;
                        aSTPair = aSTPair3;
                        aST = aST18;
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = this.astFactory.make(new ASTArray(3).add(aST10).add(aST11).add(aST13));
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    case 86: 
                    case 115: {
                        aST16 = aST == ASTNULL ? null : aST;
                        this.identifier(aST);
                        aST = this._retTree;
                        aST15 = this.returnAST;
                        object = aSTPair.root;
                        aSTPair.root = object = aST15;
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block8;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = object;
        this._retTree = aST;
    }

    public final void constant(AST aST) throws RecognitionException {
        Object object;
        block9: {
            AST aST2 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            object = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 88: 
                    case 89: 
                    case 90: 
                    case 113: 
                    case 114: {
                        this.literal(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        object = aSTPair.root;
                        break;
                    }
                    case 37: {
                        AST aST3 = null;
                        AST aST4 = null;
                        aST3 = this.astFactory.create(aST);
                        aST4 = aST;
                        this.astFactory.addASTChild(aSTPair, aST3);
                        this.match(aST, 37);
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = new ExprTypeAST(-1);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 47: {
                        AST aST5 = null;
                        AST aST6 = null;
                        aST5 = this.astFactory.create(aST);
                        aST6 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        this.match(aST, 47);
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = new ExprTypeAST(16);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    case 20: {
                        AST aST7 = null;
                        AST aST8 = null;
                        aST7 = this.astFactory.create(aST);
                        aST8 = aST;
                        this.astFactory.addASTChild(aSTPair, aST7);
                        this.match(aST, 20);
                        aST = aST.getNextSibling();
                        object = aSTPair.root;
                        aSTPair.root = object = new ExprTypeAST(16);
                        aSTPair.child = object != null && object.getFirstChild() != null ? object.getFirstChild() : object;
                        aSTPair.advanceChildToEnd();
                        object = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block9;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = object;
        this._retTree = aST;
    }

    public final void parameter(AST aST) throws RecognitionException {
        AST aST2;
        block12: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 111: {
                        AST aST10 = aST;
                        AST aST11 = null;
                        AST aST12 = null;
                        aST11 = this.astFactory.create(aST);
                        aST12 = aST;
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 111);
                        aST = aST.getFirstChild();
                        aST5 = aST == ASTNULL ? null : aST;
                        this.identifier(aST);
                        aST = this._retTree;
                        aST4 = this.returnAST;
                        aSTPair = aSTPair2;
                        aST = aST10;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        aSTPair.root = aST2 = this.astFactory.make(new ASTArray(1).add(this.astFactory.create(135, aST5.getText())));
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    case 112: {
                        AST aST13 = aST;
                        aST6 = aST == ASTNULL ? null : aST;
                        Object var12_15 = null;
                        aST7 = this.astFactory.create(aST6);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 112);
                        aST = aST.getFirstChild();
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 113: {
                                aST8 = aST;
                                Object var14_19 = null;
                                aST9 = this.astFactory.create(aST8);
                                this.match(aST, 113);
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair3;
                        aST = aST13;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        aST2 = aST8 != null ? this.astFactory.make(new ASTArray(1).add(this.astFactory.create(135, aST8.getText()))) : this.astFactory.make(new ASTArray(1).add(this.astFactory.create(112, "?")));
                        aSTPair.root = aST2;
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block12;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void caseExpr(AST aST) throws RecognitionException {
        AST aST2;
        block23: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 51: {
                        AST aST4;
                        AST aST5;
                        AST aST6;
                        AST aST7 = aST;
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 51);
                        aST = aST.getFirstChild();
                        this.inCase = true;
                        int n = 0;
                        while (true) {
                            if (aST == null) {
                                aST = ASTNULL;
                            }
                            if (aST.getType() != 55) {
                                if (n >= 1) break;
                                throw new NoViableAltException(aST);
                            }
                            aST6 = aST;
                            aST5 = null;
                            aST4 = null;
                            aST5 = this.astFactory.create(aST);
                            aST4 = aST;
                            this.astFactory.addASTChild(aSTPair, aST5);
                            ASTPair aSTPair3 = aSTPair.copy();
                            aSTPair.root = aSTPair.child;
                            aSTPair.child = null;
                            this.match(aST, 55);
                            aST = aST.getFirstChild();
                            this.logicalExpr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            this.expr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            aSTPair = aSTPair3;
                            aST = aST6;
                            aST = aST.getNextSibling();
                            ++n;
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 53: {
                                AST aST10 = aST;
                                aST6 = null;
                                aST5 = null;
                                aST6 = this.astFactory.create(aST);
                                aST5 = aST;
                                this.astFactory.addASTChild(aSTPair, aST6);
                                aST4 = aSTPair.copy();
                                aSTPair.root = aSTPair.child;
                                aSTPair.child = null;
                                this.match(aST, 53);
                                aST = aST.getFirstChild();
                                this.expr(aST);
                                aST = this._retTree;
                                this.astFactory.addASTChild(aSTPair, this.returnAST);
                                aSTPair = aST4;
                                aST = aST10;
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair2;
                        aST = aST7;
                        aST = aST.getNextSibling();
                        this.inCase = false;
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 67: {
                        AST aST11;
                        AST aST12;
                        AST aST13;
                        AST aST14 = aST;
                        AST aST15 = null;
                        AST aST16 = null;
                        aST15 = this.astFactory.create(aST);
                        aST16 = aST;
                        this.astFactory.addASTChild(aSTPair, aST15);
                        ASTPair aSTPair4 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 67);
                        aST = aST.getFirstChild();
                        this.inCase = true;
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        int n = 0;
                        while (true) {
                            if (aST == null) {
                                aST = ASTNULL;
                            }
                            if (aST.getType() != 55) {
                                if (n >= 1) break;
                                throw new NoViableAltException(aST);
                            }
                            aST13 = aST;
                            aST12 = null;
                            aST11 = null;
                            aST12 = this.astFactory.create(aST);
                            aST11 = aST;
                            this.astFactory.addASTChild(aSTPair, aST12);
                            ASTPair aSTPair5 = aSTPair.copy();
                            aSTPair.root = aSTPair.child;
                            aSTPair.child = null;
                            this.match(aST, 55);
                            aST = aST.getFirstChild();
                            this.expr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            this.expr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            aSTPair = aSTPair5;
                            aST = aST13;
                            aST = aST.getNextSibling();
                            ++n;
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 53: {
                                AST aST17 = aST;
                                aST13 = null;
                                aST12 = null;
                                aST13 = this.astFactory.create(aST);
                                aST12 = aST;
                                this.astFactory.addASTChild(aSTPair, aST13);
                                aST11 = aSTPair.copy();
                                aSTPair.root = aSTPair.child;
                                aSTPair.child = null;
                                this.match(aST, 53);
                                aST = aST.getFirstChild();
                                this.expr(aST);
                                aST = this._retTree;
                                this.astFactory.addASTChild(aSTPair, this.returnAST);
                                aSTPair = aST11;
                                aST = aST17;
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair4;
                        aST = aST14;
                        aST = aST.getNextSibling();
                        this.inCase = false;
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block23;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void addrExprLhs(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                this.addrExpr(aST, false);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void propertyName(AST aST) throws RecognitionException {
        AST aST2;
        block9: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 86: 
                    case 115: {
                        this.identifier(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 11: {
                        AST aST4 = null;
                        AST aST5 = null;
                        aST4 = this.astFactory.create(aST);
                        aST5 = aST;
                        this.astFactory.addASTChild(aSTPair, aST4);
                        this.match(aST, 11);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 17: {
                        AST aST6 = null;
                        AST aST7 = null;
                        aST6 = this.astFactory.create(aST);
                        aST7 = aST;
                        this.astFactory.addASTChild(aSTPair, aST6);
                        this.match(aST, 17);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 27: {
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        this.match(aST, 27);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block9;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void propertyRefLhs(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                this.propertyRef(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void numericInteger(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = null;
                AST aST5 = null;
                aST4 = this.astFactory.create(aST);
                aST5 = aST;
                this.astFactory.addASTChild(aSTPair, aST4);
                this.match(aST, 113);
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    private static final long[] mk_tokenSet_0() {
        long[] lArray = new long[]{2392674742079488L, 4395847612105865L, 0L, 0L};
        return lArray;
    }
}

