/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.hibernate.hql;

import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.db.hibernate.hql.ExprTypeAST;
import org.makumba.db.hibernate.hql.HqlAnalyzeBaseWalker;
import org.makumba.db.hibernate.hql.ParamTypeAST;

public class HqlAnalyzeWalker
extends HqlAnalyzeBaseWalker {
    private List result;

    void setAliasType(AST aST, String string) throws RecognitionException {
        if (this.aliasTypes.get(aST.getText()) != null) {
            throw new SemanticException("alias " + aST.getText() + " defined twice");
        }
        if (this.typeComputer.determineType(string, null) != null) {
            this.aliasTypes.put(aST.getText(), string);
        } else {
            int n;
            int n2 = string.indexOf(46);
            if (n2 == -1) {
                throw new DataDefinitionNotFoundError(string);
            }
            String string2 = string.substring(0, n2);
            String string3 = (String)this.aliasTypes.get(string2);
            if (string3 == null) {
                throw new SemanticException("Unknown label: " + string2 + "\n" + new NoSuchFieldException(string2).getStackTrace());
            }
            do {
                String string4;
                Object object;
                if (!((object = this.typeComputer.determineType(string3, string4 = (n = string.indexOf(46, n2 + 1)) == -1 ? string.substring(n2 + 1) : string.substring(n2 + 1, n))) instanceof String)) {
                    throw new SemanticException("composite type expected in FROM expression " + string + ". " + string4 + " is a non-composite field of type " + string3);
                }
                string3 = (String)object;
                n2 = n;
            } while (n != -1);
            this.aliasTypes.put(aST.getText(), string3);
        }
    }

    AST deriveParamExpr(AST aST) throws SemanticException {
        return new ParamTypeAST(100);
    }

    AST deriveLogicalExpr(AST aST) {
        return new ExprTypeAST(4);
    }

    AST deriveFunctionCallExpr(AST aST, AST aST2) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String string = aST.getText().toUpperCase();
        String[] stringArray = new String[]{"COS", "COSH", "EXP", "LN", "LOG", "SIN", "SINH", "SQRT", "TAN", "TANH", "ACOS", "ASIN", "ATAN"};
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], new Integer(15));
        }
        String[] stringArray2 = new String[]{"CHR", "CONCAT", "INITCAP", "LOWER", "LPAD", "LTRIM", "NLS_INITCAP", "NLS_LOWER", "NLSSORT", "NLS_UPPER", "RPAD", "RTRIM", "SOUNDEX", "SUBSTR", "TRANSLATE", "TREAT", "TRIM", "UPPER"};
        for (int i = 0; i < stringArray2.length; ++i) {
            hashMap.put(stringArray2[i], new Integer(6));
        }
        String[] stringArray3 = new String[]{"ASCII", "INSTR", "LENGTH"};
        for (int i = 0; i < stringArray3.length; ++i) {
            hashMap.put(stringArray3[i], new Integer(4));
        }
        String[] stringArray4 = new String[]{"ADD_MONTHS", "CURRENT_DATE", "CURRENT_TIMESTAMP", "DBTIMEZONE", "EXTRACT", "FROM_TZ", "LAST_DAY", "LOCALTIMESTAMP", "MONTHS_BETWEEN", "NEW_TIME", "NEXT_DAY", "NUMTODSINTERVAL", "NUMTOYMINTERVAL", "ROUND", "SESSIONTIMEZONE", "SYS_EXTRACT_UTC", "SYSDATE", "SYSTIMESTAMP", "TO_DSINTERVAL", "TO_TIMESTAMP", "TO_TIMESTAMP_TZ", "TO_YMINTERVAL", "TRUNC", "TZ_OFFSET", "DAYOFWEEK", "WEEKDAY", "DAYOFMONTH", "DAYOFYEAR", "MONTH", "DAYNAME", "MONTHNAME", "QUARTER", "WEEK", "YEARWEEK", "HOUR", "MINUTE", "SECOND", "PERIOD_ADD", "PERIOD_DIFF", "DATE_ADD", "DATE_SUB", "ADDDATE", "SUBDATE", "TO_DAYS", "FROM_DAYS", "DATE_FORMAT", "TIME_FORMAT", "CURDATE", "NOW", "UNIX_TIMESTAMP", "SEC_TO_TIME", "TIME_TO_SEC"};
        for (int i = 0; i < stringArray4.length; ++i) {
            hashMap.put(stringArray4[i], new Integer(9));
        }
        return new ExprTypeAST((Integer)hashMap.get(string));
    }

    AST deriveArithmethicExpr(AST aST) throws SemanticException {
        String string = aST.getText();
        ExprTypeAST exprTypeAST = null;
        ExprTypeAST exprTypeAST2 = null;
        exprTypeAST = (ExprTypeAST)aST.getFirstChild();
        exprTypeAST2 = (ExprTypeAST)exprTypeAST.getNextSibling();
        if (exprTypeAST.getObjectType() != null || exprTypeAST2.getObjectType() != null) {
            throw new SemanticException("Cannot perform operation " + string + " on elements " + exprTypeAST.getText() + " and " + exprTypeAST2.getText());
        }
        if (exprTypeAST.getDataType() == 100 || exprTypeAST2.getDataType() == 100) {
            return new ExprTypeAST(100);
        }
        return new ExprTypeAST(exprTypeAST.getDataType() > exprTypeAST2.getDataType() ? exprTypeAST.getDataType() : exprTypeAST2.getDataType());
    }

    protected void setAlias(AST aST, AST aST2) {
        if (aST instanceof ExprTypeAST) {
            ((ExprTypeAST)aST).setIdentifier(aST2.getText());
        }
    }

    void getReturnTypes(AST aST, Stack stack) throws RecognitionException {
        if (this.isSubQuery()) {
            return;
        }
        this.result = new ArrayList();
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            this.result.add(aST2);
        }
    }

    void beforeStatement(String string, int n) {
        super.beforeStatement(string, n);
        this.stackAliases.push(this.aliasTypes);
        this.aliasTypes = new HashMap();
    }

    void afterStatementCompletion(String string) {
        super.afterStatementCompletion(string);
        this.aliasTypes = (HashMap)this.stackAliases.pop();
    }

    public Map getLabelTypes() {
        return this.aliasTypes;
    }

    public List getResult() {
        return this.result;
    }
}

