/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.hibernate.hql;

import antlr.ANTLRException;
import antlr.collections.AST;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.hibernate.hql.ast.HqlParser;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaSystem;
import org.makumba.OQLAnalyzer;
import org.makumba.OQLParseError;
import org.makumba.db.hibernate.hql.ExprTypeAST;
import org.makumba.db.hibernate.hql.HqlAnalyzeWalker;
import org.makumba.db.hibernate.hql.MddObjectType;

public class HqlAnalyzer
implements OQLAnalyzer {
    private DataDefinition result;
    private static final Map integerTypeMap = new HashMap();
    private String query;
    private HqlAnalyzeWalker walker;

    public HqlAnalyzer(String string) {
        block4: {
            this.query = string;
            HqlParser hqlParser = HqlParser.getInstance((String)string);
            try {
                hqlParser.statement();
                AST aST = hqlParser.getAST();
                if (aST == null) break block4;
                this.walker = new HqlAnalyzeWalker();
                this.walker.typeComputer = new MddObjectType();
                try {
                    this.walker.statement(aST);
                }
                catch (RuntimeException runtimeException) {
                    throw new OQLParseError("during analysis of query: " + string, runtimeException);
                }
            }
            catch (ANTLRException aNTLRException) {
                throw new OQLParseError("during analysis of query: " + string, aNTLRException);
            }
        }
    }

    public String getOQL() {
        return this.query;
    }

    public synchronized DataDefinition getProjectionType() {
        if (this.result != null) {
            return this.result;
        }
        this.result = MakumbaSystem.getTemporaryDataDefinition("Projections for " + this.query);
        try {
            for (int i = 0; i < this.walker.getResult().size(); ++i) {
                ExprTypeAST exprTypeAST = (ExprTypeAST)((Object)this.walker.getResult().get(i));
                String string = exprTypeAST.getIdentifier();
                if (string == null) {
                    string = "col" + (i + 1);
                }
                FieldDefinition fieldDefinition = null;
                fieldDefinition = exprTypeAST.getObjectType() == null ? (exprTypeAST.getExtraTypeInfo() != null ? MakumbaSystem.makeFieldWithName(string, (FieldDefinition)exprTypeAST.getExtraTypeInfo(), exprTypeAST.getDescription()) : MakumbaSystem.makeFieldOfType(string, this.getTypeName(exprTypeAST.getDataType()), exprTypeAST.getDescription())) : MakumbaSystem.makeFieldDefinition(string, "ptr " + exprTypeAST.getObjectType() + ";" + exprTypeAST.getDescription());
                this.result.addField(fieldDefinition);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new OQLParseError("during analysis of query: " + this.query, runtimeException);
        }
        return this.result;
    }

    public DataDefinition getLabelType(String string) {
        return MakumbaSystem.getDataDefinition((String)this.walker.getLabelTypes().get(string));
    }

    public DataDefinition getParameterTypes() {
        throw new UnsupportedOperationException("getParameterTypes");
    }

    public int parameterNumber() {
        throw new UnsupportedOperationException("getParameterNumber");
    }

    public int parameterAt(int n) {
        throw new UnsupportedOperationException("parameterAt");
    }

    String getTypeName(int n) {
        return (String)integerTypeMap.get(new Integer(n));
    }

    public String toString() {
        String string = "Query:\n" + this.getOQL() + "\n";
        Vector vector = this.getProjectionType().getFieldNames();
        string = string + "Number of projections: " + vector.size() + "\n";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + i + " FieldDef Name: " + this.getProjectionType().getFieldDefinition(i).getName() + "\n";
            string = string + i + " FieldDef Type: " + this.getProjectionType().getFieldDefinition(i).getType() + "\n";
            string = string + i + " FieldDef Comment: " + this.getProjectionType().getFieldDefinition(i).getDescription() + "\n";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        String string = "SELECT p as bullshit FROM test.Person p)";
        HqlAnalyzer hqlAnalyzer = MakumbaSystem.getHqlAnalyzer(string);
        System.out.println(hqlAnalyzer.toString());
    }

    static {
        integerTypeMap.put(new Integer(0), "ptr");
        integerTypeMap.put(new Integer(1), "ptrRel");
        integerTypeMap.put(new Integer(2), "ptrOne");
        integerTypeMap.put(new Integer(3), "ptrIndex");
        integerTypeMap.put(new Integer(4), "int");
        integerTypeMap.put(new Integer(5), "intEnum");
        integerTypeMap.put(new Integer(6), "char");
        integerTypeMap.put(new Integer(7), "charEnum");
        integerTypeMap.put(new Integer(8), "text");
        integerTypeMap.put(new Integer(9), "date");
        integerTypeMap.put(new Integer(10), "dateCreate");
        integerTypeMap.put(new Integer(11), "dateModify");
        integerTypeMap.put(new Integer(12), "set");
        integerTypeMap.put(new Integer(13), "setComplex");
        integerTypeMap.put(new Integer(14), "nil");
        integerTypeMap.put(new Integer(15), "real");
        integerTypeMap.put(new Integer(16), "setcharEnum");
        integerTypeMap.put(new Integer(17), "setintEnum");
        integerTypeMap.put(new Integer(100), "parameter");
    }
}

