/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.Transaction;
import org.makumba.util.ClassResource;

public class ObjectImporter {
    Properties markers = new Properties();
    protected DataDefinition dd;
    protected boolean ignored;
    protected boolean ignoreNotFound;
    protected String begin;
    protected String end;
    MakumbaError configError;
    Properties replaceFile;
    boolean canError = true;
    boolean noWarning = false;
    String nothing;
    Vector formats = new Vector();
    String joinField;
    String select;
    int index = -1;
    int nchar = -1;
    boolean noMarkers = false;
    static String[][] htmlEscape = new String[][]{{"&quot;", "&amp;", "<br>"}, {"\"", "&", "\n"}};

    public String getMarker(String string) {
        return this.markers.getProperty(string);
    }

    public ObjectImporter(DataDefinition dataDefinition) {
        this(dataDefinition, false);
    }

    public ObjectImporter(DataDefinition dataDefinition, boolean bl) {
        Object object;
        Object object2;
        this.dd = dataDefinition;
        this.noMarkers = bl;
        String string = dataDefinition.getName().replace('.', '/') + ".mark";
        URL uRL = null;
        try {
            uRL = ClassResource.get("dataDefinitions/" + string);
            this.markers.load(uRL.openStream());
        }
        catch (Exception exception) {
            try {
                uRL = ClassResource.get(string);
                this.markers.load(uRL.openStream());
            }
            catch (Exception exception2) {
                throw new MakumbaError(exception2);
            }
        }
        Object object3 = this.dd.getFieldNames().elements();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            this.configureField((String)object2, this.markers);
        }
        object3 = new Vector();
        object2 = this.dd.getFieldNames().elements();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            if (this.isMarked((String)object) || this.isIgnored((String)object)) continue;
            ((Vector)object3).addElement(object);
        }
        if (((Vector)object3).size() > 0) {
            MakumbaSystem.getMakumbaLogger("import").warning("marker file " + uRL + " does not contain markers for:\n " + object3 + "\nUse \"<fieldname>.ignore=true\" in the marked file if you are shure you don't want the field to be imported");
        }
        boolean bl2 = false;
        object = this.dd.getFieldNames().elements();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            if (this.configError == null || this.isIgnored(string2)) continue;
            if (!bl2) {
                bl2 = true;
                MakumbaSystem.getMakumbaLogger("import").warning("marker file " + uRL + " contains errors. Erroneous fields will be ignored.");
            }
            this.ignored = true;
            MakumbaSystem.getMakumbaLogger("import").severe(this.configError.toString());
        }
    }

    Object getValue(String string, String string2, Transaction transaction, Pointer[] pointerArray) {
        if (this.isIgnored(string)) {
            return null;
        }
        return this.getFieldValue(string, this.replaceField(string, string2), transaction, pointerArray);
    }

    protected boolean isMarked(String string) {
        if (this.isFieldMarked(string)) {
            return true;
        }
        if (this.noMarkers) {
            String string2 = this.begin;
            this.begin = "x";
            boolean bl = this.isFieldMarked(string);
            this.begin = string2;
            return bl;
        }
        return false;
    }

    protected boolean usesHidden() {
        return true;
    }

    public Dictionary importFrom(String string, Transaction transaction, Pointer[] pointerArray) {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.dd.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            this.importFieldTo(string2, hashtable, string, transaction, pointerArray);
        }
        return hashtable;
    }

    public static void main(String[] stringArray) throws Throwable {
        ObjectImporter objectImporter = new ObjectImporter(MakumbaSystem.getDataDefinition(stringArray[0]));
        File file = new File(stringArray[1]);
        String[] stringArray2 = file.list();
        char[] cArray = new char[8196];
        for (int i = 0; i < stringArray2.length; ++i) {
            int n;
            MakumbaSystem.getMakumbaLogger("import").finest(stringArray2[i]);
            FileReader fileReader = new FileReader(new File(file, stringArray2[i]));
            StringWriter stringWriter = new StringWriter();
            while ((n = fileReader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            String string = stringWriter.toString().toString();
            MakumbaSystem.getMakumbaLogger("import").finest(objectImporter.importFrom(string, null, null).toString());
        }
    }

    public Object getFieldValue(String string, String string2, Transaction transaction, Pointer[] pointerArray) {
        switch (this.dd.getFieldDefinition(string).getIntegerType()) {
            case 0: {
                return this.get_ptr_FieldValue(string, string2, transaction, pointerArray);
            }
        }
        return this.base_getFieldValue(string, string2, transaction, pointerArray);
    }

    public Object base_getFieldValue(String string, String string2, Transaction transaction, Pointer[] pointerArray) {
        return this.getFieldValue(string, string2);
    }

    public Object get_ptr_FieldValue(String string, String string2, Transaction transaction, Pointer[] pointerArray) {
        if (this.index != -1) {
            return pointerArray[this.index];
        }
        if (string2.length() == 0) {
            return null;
        }
        String string3 = string2;
        if (this.select != null) {
            Vector vector = transaction.executeQuery(this.select, string3);
            if (vector.size() > 1) {
                this.warningField(string, "too many join results for \"" + string2 + "\": " + vector);
                return null;
            }
            if (vector.size() == 1) {
                return (Pointer)((Dictionary)vector.elementAt(0)).get("col1");
            }
            this.warningField(string, "no join results for \"" + string2 + "\"");
            return null;
        }
        String string4 = null;
        string4 = "SELECT p, p." + this.joinField + " FROM " + this.dd.getFieldDefinition(string).getForeignTable().getName() + " p WHERE p." + this.joinField + "=$1";
        Vector vector = transaction.executeQuery(string4, string3);
        if (vector.size() > 1) {
            this.warningField(string, "too many join results for \"" + string2 + "\": " + vector);
            return null;
        }
        if (vector.size() == 1) {
            return (Pointer)((Dictionary)vector.elementAt(0)).get("col1");
        }
        if (this.nchar == -1) {
            this.warningField(string, "no join results for \"" + string2 + "\"");
            return null;
        }
        string4 = "SELECT p, p." + this.joinField + " FROM " + this.dd.getFieldDefinition(string).getForeignTable().getName() + " p WHERE p." + this.joinField + " like $1";
        vector = transaction.executeQuery(string4, string3 = string2.length() < this.nchar ? string2 : string2.substring(0, this.nchar) + "%");
        if (vector.size() > 1) {
            this.warningField(string, "too many join results for \"" + string2 + "\": " + vector);
            return null;
        }
        if (vector.size() == 0) {
            this.warningField(string, "no join results for \"" + string2 + "\"");
            return null;
        }
        return (Pointer)((Dictionary)vector.elementAt(0)).get("col1");
    }

    public Object getFieldValue(String string, String string2) {
        switch (this.dd.getFieldDefinition(string).getIntegerType()) {
            case 9: 
            case 10: 
            case 11: {
                return this.get_date_FieldValue(string, string2);
            }
            case 4: {
                return this.get_int_FieldValue(string, string2);
            }
            case 5: {
                return this.get_intEnum_FieldValue(string, string2);
            }
        }
        return this.base_getFieldValue(string, string2);
    }

    public Object base_getFieldValue(String string, String string2) {
        return string2;
    }

    public Object get_date_FieldValue(String string, String string2) {
        if (string2.trim().length() == 0) {
            return null;
        }
        ParseException parseException = null;
        Enumeration enumeration = this.formats.elements();
        while (enumeration.hasMoreElements()) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)enumeration.nextElement();
            try {
                return simpleDateFormat.parse(string2);
            }
            catch (ParseException parseException2) {
                parseException = parseException2;
            }
        }
        this.warningField(string, parseException);
        return null;
    }

    public Object get_intEnum_FieldValue(String string, String string2) {
        if ((string2 = (String)this.base_getFieldValue(string, string2)).trim().length() == 0) {
            return null;
        }
        Enumeration enumeration = this.dd.getFieldDefinition(string).getValues();
        Enumeration enumeration2 = this.dd.getFieldDefinition(string).getNames();
        while (enumeration2.hasMoreElements()) {
            String string3 = (String)enumeration2.nextElement();
            Integer n = (Integer)enumeration.nextElement();
            if (!string3.equals(string2)) continue;
            return n;
        }
        this.warningField(string, "illegal value: \"" + string2 + "\"");
        return null;
    }

    public Object get_int_FieldValue(String string, String string2) {
        if ((string2 = (String)this.base_getFieldValue(string, string2)).trim().length() == 0) {
            return null;
        }
        try {
            return new Integer(Integer.parseInt((String)this.base_getFieldValue(string, string2)));
        }
        catch (Exception exception) {
            this.warningField(string, exception);
            return null;
        }
    }

    public boolean isIgnored(String string) {
        if (this.dd.getFieldDefinition(string).getType().startsWith("set")) {
            return true;
        }
        switch (this.dd.getFieldDefinition(string).getIntegerType()) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return this.ignored;
    }

    public boolean isFieldMarked(String string) {
        switch (this.dd.getFieldDefinition(string).getIntegerType()) {
            case 0: {
                return this.joinField != null || this.index != -1 || this.select != null;
            }
        }
        return this.begin != null;
    }

    String replaceField(String string, String string2) {
        if (string2 != null) {
            String string3 = this.getFieldMarker(string, "replace." + string2);
            if (string3 != null) {
                string2 = string3;
            } else {
                String string4 = string2.replace(' ', '_').replace('=', '_');
                string3 = this.getFieldMarker(string, "replace." + string4);
                if (string3 != null) {
                    string2 = string3;
                } else if (this.replaceFile != null) {
                    string3 = this.replaceFile.getProperty(string2);
                    if (string3 != null) {
                        string2 = string3;
                    } else {
                        string3 = this.replaceFile.getProperty(string4);
                        if (string3 != null) {
                            string2 = string3;
                        }
                    }
                }
            }
        }
        return string2;
    }

    String getFieldMarker(String string, String string2) {
        String string3 = this.markers.getProperty(string + "." + string2);
        if (string3 != null) {
            return string3.trim();
        }
        return null;
    }

    public String canonicalFieldName(String string) {
        return this.dd.getName() + "#" + string;
    }

    void warningField(String string, String string2) {
        String string3 = this.canonicalFieldName(string) + " " + string2;
        if (!this.canError) {
            throw new MakumbaError(string3);
        }
        MakumbaSystem.getMakumbaLogger("import").warning(string3);
    }

    void warningField(String string, Throwable throwable) {
        String string2 = this.canonicalFieldName(string);
        if (!this.canError) {
            throw new MakumbaError(throwable, string2);
        }
        MakumbaSystem.getMakumbaLogger("import").warning(string2 + " " + throwable.toString());
    }

    MakumbaError makeFieldError(String string, String string2) {
        return new MakumbaError(this.canonicalFieldName(string) + " " + string2);
    }

    MakumbaError makeFieldError(String string, Throwable throwable) {
        return new MakumbaError(throwable, this.canonicalFieldName(string));
    }

    static String escapeField(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block0: for (int i = 0; i < string2.length(); ++i) {
            for (int j = 0; j < htmlEscape[0].length; ++j) {
                if (string2.length() - i < htmlEscape[0][j].length() || !string2.substring(i, i + htmlEscape[0][j].length()).toLowerCase().equals(htmlEscape[0][j])) continue;
                stringBuffer.append(htmlEscape[1][j]);
                i += htmlEscape[0][j].length() - 1;
                continue block0;
            }
            stringBuffer.append(string2.charAt(i));
        }
        return stringBuffer.toString();
    }

    public boolean shouldEscapeField(String string) {
        switch (this.dd.getFieldDefinition(string).getIntegerType()) {
            case 4: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    public boolean shouldDecomposeURL(String string) {
        return this.dd.getFieldDefinition(string).getType().equals("char");
    }

    static String decomposeURL(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (!string2.startsWith("<a")) {
            return string2;
        }
        int n = string2.indexOf(34);
        if (n == -1 || string2.length() == n + 1) {
            return string2;
        }
        int n2 = string2.indexOf(34, n + 1);
        if (n2 == -1 || string2.length() == n2 + 1) {
            return string2;
        }
        String string3 = string2.substring(n + 1, n2);
        n = string2.indexOf(">");
        if (n == -1 || string2.length() == n + 1) {
            return string2;
        }
        n2 = string2.indexOf("</a>");
        if (n2 == -1) {
            return string2;
        }
        try {
            if (!string3.equals(string2.substring(n + 1, n2))) {
                return string2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            MakumbaSystem.getMakumbaLogger("import").severe("EEEE " + string2 + " " + string3);
            return string2;
        }
        if (!string3.startsWith("http")) {
            string3 = "http://" + string3;
        }
        return string3;
    }

    /*
     * Unable to fully structure code
     */
    public void importFieldTo(String var1_1, Dictionary var2_2, String var3_3, Transaction var4_4, Pointer[] var5_5) {
        try {
            if (this.isIgnored(var1_1) || !this.isFieldMarked(var1_1)) {
                return;
            }
            var6_6 = null;
            if (this.begin != null) {
                var7_8 = var3_3.indexOf(this.begin);
                if (var7_8 != -1) {
                    var7_8 += this.begin.length();
                    try {
                        var6_6 = var3_3.substring(var7_8, var3_3.indexOf(this.end, var7_8));
                        if (!this.noWarning) ** GOTO lbl19
                        this.warningField(var1_1, " found value for unfrequent field: " + var6_6);
                    }
                    catch (Exception var8_10) {
                        this.warningField(var1_1, "no end found");
                        return;
                    }
                } else if (!this.ignoreNotFound && !this.noWarning) {
                    this.warningField(var1_1, "begin not found");
                }
            }
lbl19:
            // 7 sources

            var7_9 = null;
            if (this.shouldEscapeField(var1_1)) {
                var6_6 = ObjectImporter.escapeField(var1_1, var6_6);
            }
            var6_6 = this.replaceField(var1_1, var6_6);
            if (this.shouldDecomposeURL(var1_1)) {
                var6_6 = ObjectImporter.decomposeURL(var1_1, var6_6);
            }
            if (this.begin == null || var6_6 != null) {
                var7_9 = this.getValue(var1_1, var6_6, var4_4, var5_5);
            }
            if (var7_9 != null) {
                if (this.nothing != null && var7_9.equals(this.getFieldValue(var1_1, this.nothing))) {
                    return;
                }
                var2_2.put(var1_1, var7_9);
            }
        }
        catch (RuntimeException var6_7) {
            throw this.makeFieldError(var1_1, var6_7);
        }
    }

    public void configureField(String string, Properties properties) {
        if (this.dd.getFieldDefinition(string).getType().startsWith("set")) {
            this.configure_none_Field(string, properties);
        } else {
            switch (this.dd.getFieldDefinition(string).getIntegerType()) {
                case 0: {
                    this.configure_ptr_Field(string, properties);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.configure_date_Field(string, properties);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.configure_none_Field(string, properties);
                    break;
                }
                default: {
                    this.base_configureField(string, properties);
                }
            }
        }
    }

    public void base_configureField(String string, Properties properties) {
        this.markers = properties;
        String string2 = this.getFieldMarker(string, "ignore");
        boolean bl = this.ignored = string2 != null && string2.equals("true");
        if (this.ignored) {
            return;
        }
        string2 = this.getFieldMarker(string, "ignoreNotFound");
        this.ignoreNotFound = string2 != null && string2.equals("true");
        this.begin = this.getFieldMarker(string, "begin");
        this.nothing = this.getFieldMarker(string, "nothing");
        String string3 = this.getFieldMarker(string, "replaceFile");
        if (string3 != null) {
            this.replaceFile = new Properties();
            try {
                this.replaceFile.load(new FileInputStream(string3));
            }
            catch (IOException iOException) {
                this.configError = new MakumbaError(iOException);
            }
        }
        this.noWarning = this.getFieldMarker(string, "noWarning") != null;
        this.end = this.getFieldMarker(string, "end");
        if (this.end == null) {
            this.end = properties.getProperty("end");
        }
    }

    public void configure_date_Field(String string, Properties properties) {
        this.base_configureField(string, properties);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string + ".format")) continue;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(properties.getProperty(string2).trim(), MakumbaSystem.getLocale());
            simpleDateFormat.setTimeZone(MakumbaSystem.getTimeZone());
            simpleDateFormat.setLenient(false);
            this.formats.addElement(simpleDateFormat);
        }
        if (this.formats.size() == 0) {
            this.configError = this.makeFieldError(string, "has no format indicated. Use \"" + string + ".format=MM yy dd\" in the marker file.\nSee the class java.text.SimpleDateFormat to see how to compose the formatter");
        }
    }

    public void configure_none_Field(String string, Properties properties) {
        this.base_configureField(string, properties);
        if (this.begin != null) {
            throw new MakumbaError("You cannot have markers for fields of type " + this.dd.getFieldDefinition(string).getType());
        }
    }

    public void configure_ptr_Field(String string, Properties properties) {
        this.base_configureField(string, properties);
        if (this.ignored) {
            return;
        }
        this.joinField = this.getFieldMarker(string, "joinField");
        this.select = this.getFieldMarker(string, "select");
        try {
            this.index = Integer.parseInt(this.getFieldMarker(string, "index"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (this.index != -1) {
            if (this.begin != null || this.joinField != null || this.select != null) {
                this.configError = this.makeFieldError(string, "if pointer index is indicated, begin, end or joinfield are not needed");
            }
        } else if (this.joinField != null) {
            String string2;
            if (this.index != -1 || this.select != null) {
                this.configError = this.makeFieldError(string, "if join field is indicated, begin and end are needed, index not");
            }
            if ((string2 = this.getFieldMarker(string, "joinChars")) != null) {
                this.nchar = Integer.parseInt(string2);
            }
        } else if (this.select != null) {
            if (this.index != -1 || this.joinField != null) {
                this.configError = this.makeFieldError(string, "if select is indicated, begin and end are needed, index not");
            }
        } else {
            this.configError = this.makeFieldError(string, "join field or pointer index must be indicated for pointers");
        }
    }
}

