/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.view;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.hibernate.CacheMode;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.type.Type;
import org.makumba.Attributes;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.HibernateSFManager;
import org.makumba.LogicException;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.ProgrammerError;
import org.makumba.db.hibernate.HibernatePointer;
import org.makumba.db.hibernate.hql.HqlAnalyzer;
import org.makumba.db.sql.SQLPointer;
import org.makumba.util.ArrayMap;
import org.makumba.view.AbstractQueryRunner;

public class HibernateQueryRunner
extends AbstractQueryRunner {
    Session session;
    Transaction transaction;

    public Vector execute(String string, Object[] objectArray, int n, int n2) {
        return null;
    }

    public Vector executeDirect(String string, Attributes attributes, int n, int n2) throws LogicException {
        int n3;
        Object object;
        MakumbaSystem.getLogger("hibernate").info("Executing hibernate query " + string);
        HqlAnalyzer hqlAnalyzer = MakumbaSystem.getHqlAnalyzer(string);
        DataDefinition dataDefinition = hqlAnalyzer.getProjectionType();
        for (int i = 0; i < dataDefinition.getFieldNames().size(); ++i) {
            object = dataDefinition.getFieldDefinition(i);
            if (!object.getType().equals("ptr") || object.getDescription().equalsIgnoreCase("ID") || object.getDescription().startsWith("hibernate_")) continue;
            throw new ProgrammerError("Invalid HQL query - you must not select the whole object '" + object.getDescription() + "' in the query'" + string + "'!\nYou have to select '" + object.getDescription() + ".id' instead.");
        }
        this.session = HibernateSFManager.getSF().openSession();
        this.session.setCacheMode(CacheMode.IGNORE);
        this.transaction = this.session.beginTransaction();
        Query query = this.session.createQuery(string);
        query.setCacheable(false);
        query.setFirstResult(n);
        if (n2 != -1) {
            query.setMaxResults(n2);
        }
        if (attributes != null) {
            object = query.getNamedParameters();
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (attributes.getAttribute((String)object[i]) instanceof Vector) {
                    query.setParameterList((String)object[i], (Collection)attributes.getAttribute((String)object[i]));
                    continue;
                }
                if (attributes.getAttribute((String)object[i]) instanceof Date) {
                    query.setParameter((String)object[i], attributes.getAttribute((String)object[i]), (Type)Hibernate.DATE);
                    continue;
                }
                if (attributes.getAttribute((String)object[i]) instanceof Integer) {
                    query.setParameter((String)object[i], attributes.getAttribute((String)object[i]), (Type)Hibernate.INTEGER);
                    continue;
                }
                query.setParameter((String)object[i], attributes.getAttribute((String)object[i]));
            }
        }
        object = query.list();
        Vector<ArrayMap> vector = new Vector<ArrayMap>(object.size());
        Object[] objectArray = dataDefinition.getFieldNames().toArray();
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>(objectArray.length);
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            ((Dictionary)hashtable).put(objectArray[n3], new Integer(n3));
        }
        n3 = 1;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object[] objectArray2 = !(e instanceof Object[]) ? new Object[]{e} : (Object[])e;
            for (int i = 0; i < objectArray2.length; ++i) {
                if (objectArray2[i] == null) continue;
                FieldDefinition fieldDefinition = dataDefinition.getFieldDefinition(i);
                if (fieldDefinition.getType().equals("ptr")) {
                    String string2 = fieldDefinition.getPointedType().getName();
                    if (objectArray2[i] instanceof Pointer) {
                        objectArray2[i] = new HibernatePointer(string2, ((Pointer)objectArray2[i]).getUid());
                        continue;
                    }
                    objectArray2[i] = new HibernatePointer(string2, ((Integer)objectArray2[i]).intValue());
                    continue;
                }
                objectArray2[i] = objectArray2[i];
            }
            ArrayMap arrayMap = new ArrayMap(hashtable, objectArray2);
            vector.add(arrayMap);
            ++n3;
        }
        return vector;
    }

    public void close() {
        if (this.session != null) {
            this.transaction.commit();
            this.session.close();
        }
    }

    public static void main(String[] stringArray) throws LogicException {
        HibernateSFManager.getSF();
        HibernateQueryRunner hibernateQueryRunner = new HibernateQueryRunner();
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(1));
        vector.add(new Integer(2));
        vector.add(new Integer(3));
        vector.add(new Integer(4));
        MyAttributes myAttributes = hibernateQueryRunner.new MyAttributes();
        myAttributes.setAttribute("date", new Timestamp(new GregorianCalendar(1970, 1, 1).getTimeInMillis()));
        myAttributes.setAttribute("name", "Cristian");
        myAttributes.setAttribute("someInt", new Integer(1));
        myAttributes.setAttribute("someSet", vector);
        myAttributes.setAttribute("generalPerson", new SQLPointer("general.Person", 151022406L));
        myAttributes.setAttribute("someDouble", new Double(2.0));
        String string = "SELECT p.id as ID, p.name as name, p.surname as surname, p.birthdate as date, p.T_shirt as shirtSize FROM general.Person p where p.name = :name AND p.birthdate is not null AND p.birthdate > :date AND p.T_shirt = :someInt";
        String string2 = "SELECT p.id as ID, p.name as name, p.surname as surname, p.birthdate as date, p.T_shirt as shirtSize FROM general.Person p where p.name = :name AND p.birthdate is not null AND p.birthdate > :date and p.T_shirt in (:someSet) order by p.surname DESC";
        String string3 = "SELECT e.subject as subject, e.spamLevel AS spamLevel from general.archive.Email e WHERE e.spamLevel = :someDouble";
        String[] stringArray2 = new String[]{string, string2, string3};
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println("Query " + stringArray2[i] + " ==> \n" + HibernateQueryRunner.printQueryResults(hibernateQueryRunner.executeDirect(stringArray2[i], myAttributes, 0, 50)) + "\n\n");
        }
    }

    public static String printQueryResults(Vector vector) {
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + "Row " + i + ":" + vector.elementAt(i) + "\n";
        }
        return string;
    }

    class MyAttributes
    implements Attributes {
        Hashtable attr = new Hashtable();

        MyAttributes() {
        }

        public Object getAttribute(String string) throws LogicException {
            return this.attr.get(string);
        }

        public Object setAttribute(String string, Object object) throws LogicException {
            if (object != null) {
                return this.attr.put(string, object);
            }
            throw new LogicException("No value for " + string);
        }
    }
}

