/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.view.jsptaglib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.ProgrammerError;
import org.makumba.util.JspParseData;
import org.makumba.util.MultipleKey;
import org.makumba.view.ComposedQuery;
import org.makumba.view.ComposedSubquery;
import org.makumba.view.jsptaglib.MakumbaTag;
import org.makumba.view.jsptaglib.QueryTag;

public class MakumbaJspAnalyzer
implements JspParseData.JspAnalyzer {
    static String[] tags = new String[]{"value", "org.makumba.view.jsptaglib.ValueTag", "list", "org.makumba.view.jsptaglib.QueryTag", "object", "org.makumba.view.jsptaglib.ObjectTag", "form", "org.makumba.view.jsptaglib.FormTagBase", "newForm", "org.makumba.view.jsptaglib.NewTag", "addForm", "org.makumba.view.jsptaglib.AddTag", "editForm", "org.makumba.view.jsptaglib.EditTag", "deleteLink", "org.makumba.view.jsptaglib.DeleteTag", "delete", "org.makumba.view.jsptaglib.DeleteTag", "input", "org.makumba.view.jsptaglib.InputTag", "action", "org.makumba.view.jsptaglib.ActionTag", "option", "org.makumba.view.jsptaglib.OptionTag", "if", "org.makumba.view.jsptaglib.IfTag"};
    static final Map tagClasses = new HashMap();

    private MakumbaJspAnalyzer() {
    }

    public static JspParseData.JspAnalyzer getInstance() {
        return SingletonHolder.singleton;
    }

    public void systemTag(JspParseData.TagData tagData, Object object) {
        if (tagData.name.equals("taglib") && tagData.attributes.get("uri") != null && tagData.attributes.get("uri").toString().startsWith("http://www.makumba.org/")) {
            ((ParseStatus)object).makumbaPrefix = (String)tagData.attributes.get("prefix");
            ((ParseStatus)object).makumbaURI = (String)tagData.attributes.get("uri");
            ((ParseStatus)object).pageCache.usesHQL = !((ParseStatus)object).makumbaURI.equals("http://www.makumba.org/presentation");
        }
    }

    public void simpleTag(JspParseData.TagData tagData, Object object) {
        String string = ((ParseStatus)object).makumbaPrefix + ":";
        if (!tagData.name.startsWith(string)) {
            return;
        }
        Class clazz = (Class)tagClasses.get(tagData.name.substring(string.length()));
        if (clazz == null) {
            return;
        }
        MakumbaTag.analyzedTag.set(tagData);
        MakumbaTag makumbaTag = null;
        try {
            makumbaTag = (MakumbaTag)((Object)clazz.newInstance());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        tagData.tagObject = makumbaTag;
        makumbaTag.setTagDataAtAnalysis(tagData);
        ((ParseStatus)object).addTag(makumbaTag, tagData);
        MakumbaTag.analyzedTag.set(null);
    }

    public void startTag(JspParseData.TagData tagData, Object object) {
        this.simpleTag(tagData, object);
        ((ParseStatus)object).start((MakumbaTag)((Object)tagData.tagObject));
    }

    public void endTag(JspParseData.TagData tagData, Object object) {
        MakumbaTag.analyzedTag.set(tagData);
        ((ParseStatus)object).end(tagData);
        MakumbaTag.analyzedTag.set(null);
    }

    public Object makeStatusHolder(Object object) {
        return new ParseStatus();
    }

    public Object endPage(Object object) {
        ((ParseStatus)object).endPage();
        return ((ParseStatus)object).pageCache;
    }

    static {
        for (int i = 0; i < tags.length; i += 2) {
            try {
                tagClasses.put(tags[i], Class.forName(tags[i + 1]));
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static final class SingletonHolder {
        static final JspParseData.JspAnalyzer singleton = new MakumbaJspAnalyzer();

        private SingletonHolder() {
        }
    }

    class ParseStatus {
        String makumbaPrefix;
        String makumbaURI;
        List tags = new ArrayList();
        List parents = new ArrayList();
        PageCache pageCache = new PageCache();

        ParseStatus() {
        }

        void addTag(MakumbaTag makumbaTag, JspParseData.TagData tagData) {
            if (!this.parents.isEmpty()) {
                makumbaTag.setParent((Tag)((MakumbaTag)((Object)this.parents.get(this.parents.size() - 1))));
            } else {
                makumbaTag.setParent(null);
            }
            JspParseData.fill((Tag)makumbaTag, tagData.attributes);
            makumbaTag.setTagKey(this.pageCache);
            if (makumbaTag.getTagKey() != null && !makumbaTag.allowsIdenticalKey()) {
                MakumbaTag makumbaTag2 = (MakumbaTag)((Object)this.pageCache.tags.get(makumbaTag.getTagKey()));
                if (makumbaTag2 != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Due to limitations of the JSP standard, Makumba cannot make\n").append("a difference between the following two tags: \n");
                    makumbaTag2.addTagText(stringBuffer);
                    stringBuffer.append("\n");
                    makumbaTag.addTagText(stringBuffer);
                    stringBuffer.append("\nTo address this, add an id= attribute to one of the tags, and make sure that id is unique within the page.");
                    throw new ProgrammerError(stringBuffer.toString());
                }
                this.pageCache.tags.put(makumbaTag.getTagKey(), makumbaTag);
            }
            this.pageCache.tagData.put(makumbaTag.getTagKey(), tagData);
            makumbaTag.doStartAnalyze(this.pageCache);
            this.tags.add(makumbaTag);
        }

        public void start(MakumbaTag makumbaTag) {
            if (makumbaTag == null) {
                return;
            }
            if (!(makumbaTag instanceof BodyTag) && !(makumbaTag instanceof QueryTag)) {
                throw new ProgrammerError("This type of tag cannot have a body:\n " + makumbaTag.getTagText());
            }
            this.parents.add(makumbaTag);
        }

        public void end(JspParseData.TagData tagData) {
            String string = tagData.name;
            if (!string.startsWith(this.makumbaPrefix)) {
                return;
            }
            if (this.parents.isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Error: Closing tag never opened:\ntag \"").append(tagData.name).append("\" at line ");
                JspParseData.tagDataLine(tagData, stringBuffer);
                throw new ProgrammerError(stringBuffer.toString());
            }
            string = string.substring(this.makumbaPrefix.length() + 1);
            MakumbaTag makumbaTag = (MakumbaTag)((Object)this.parents.get(this.parents.size() - 1));
            if (!((Object)((Object)makumbaTag)).getClass().equals(tagClasses.get(string))) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Body tag nesting error:\ntag \"").append(tagData.name).append("\" at line ");
                JspParseData.tagDataLine(tagData, stringBuffer);
                stringBuffer.append("\n\ngot incorrect closing \"").append(tagData.name).append("\" at line ");
                JspParseData.tagDataLine(tagData, stringBuffer);
                throw new ProgrammerError(stringBuffer.toString());
            }
            this.parents.remove(this.parents.size() - 1);
        }

        public void endPage() {
            Iterator iterator = this.tags.iterator();
            while (iterator.hasNext()) {
                MakumbaTag makumbaTag = (MakumbaTag)((Object)iterator.next());
                MakumbaTag.analyzedTag.set(makumbaTag.tagData);
                makumbaTag.doEndAnalyze(this.pageCache);
                MakumbaTag.analyzedTag.set(null);
            }
        }
    }

    public class PageCache {
        HashMap formatters = new HashMap();
        HashMap valueComputers = new HashMap();
        Types types = new Types();
        HashMap queries = new HashMap();
        HashMap inputTypes = new HashMap();
        HashMap basePointerTypes = new HashMap();
        HashMap tags = new HashMap();
        HashMap tagData = new HashMap();
        boolean usesHQL = false;

        public ComposedQuery getQuery(MultipleKey multipleKey) {
            ComposedQuery composedQuery = (ComposedQuery)this.queries.get(multipleKey);
            if (composedQuery == null) {
                throw new MakumbaError("unknown query for key " + multipleKey);
            }
            return composedQuery;
        }

        public ComposedQuery cacheQuery(MultipleKey multipleKey, String[] stringArray, MultipleKey multipleKey2) {
            ComposedQuery composedQuery = (ComposedQuery)this.queries.get(multipleKey);
            if (composedQuery != null) {
                return composedQuery;
            }
            composedQuery = multipleKey2 == null ? new ComposedQuery(stringArray, this.usesHQL) : new ComposedSubquery(stringArray, this.getQuery(multipleKey2), this.usesHQL);
            composedQuery.init();
            this.queries.put(multipleKey, composedQuery);
            return composedQuery;
        }
    }

    class Types
    extends HashMap {
        private static final long serialVersionUID = 1L;

        Types() {
        }

        public void setType(String string, FieldDefinition fieldDefinition, MakumbaTag makumbaTag) {
            Object[] objectArray = (Object[])this.get(string);
            FieldDefinition fieldDefinition2 = null;
            if (objectArray != null) {
                fieldDefinition2 = (FieldDefinition)objectArray[0];
            }
            if (fieldDefinition2 != null && fieldDefinition.getType().equals("nil")) {
                return;
            }
            MakumbaTag.analyzedTag.set(makumbaTag.tagData);
            if (fieldDefinition2 != null && !fieldDefinition.isAssignableFrom(fieldDefinition2)) {
                throw new ProgrammerError("Attribute type changing within the page: in tag\n" + ((MakumbaTag)((Object)objectArray[1])).getTagText() + " attribute " + string + " was determined to have type " + fieldDefinition2 + " and the from this tag results the incompatible type " + fieldDefinition);
            }
            MakumbaTag.analyzedTag.set(null);
            Object[] objectArray2 = new Object[]{fieldDefinition, makumbaTag};
            this.put(string, objectArray2);
        }
    }
}

