/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import javax.xml.transform.TransformerConfigurationException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.makumba.MakumbaSystem;
import org.makumba.db.hibernate.MddToClass;
import org.makumba.db.hibernate.MddToMapping;
import org.makumba.util.ClassResource;
import org.xml.sax.SAXException;

public class HibernateSFManager {
    private static final String PREFIX = "makumbaGeneratedMappings";
    private static final String SEED = "SEED.txt";
    private static SessionFactory sessionFactory;

    public static String findClassesRootFolder(String string) {
        String string2 = "";
        try {
            string2 = new File(ClassResource.get(string).getFile()).getParentFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string2;
    }

    public static SessionFactory getSF(String string) {
        if (sessionFactory == null) {
            Vector vector;
            Object object;
            Configuration configuration = new Configuration().configure(string);
            String string2 = configuration.getProperty("makumba.seed");
            if (string2 == null) {
                string2 = SEED;
            }
            String string3 = HibernateSFManager.findClassesRootFolder(string2);
            System.out.println("Generating classes under " + string3);
            String string4 = configuration.getProperty("makumba.prefix");
            if (string4 == null) {
                string4 = PREFIX;
            }
            System.out.println("Generating mappings under " + string3 + File.separator + string4);
            String string5 = configuration.getProperty("makumba.mdd.list");
            if (string5 == null) {
                object = configuration.getProperty("makumba.mdd.root");
                if (object == null) {
                    object = "dataDefinitions";
                }
                System.out.println("Working with the MDDs under " + (String)object);
                vector = MakumbaSystem.mddsInDirectory((String)object);
            } else {
                vector = new Vector();
                System.out.println("Working with the MDDs " + string5);
                object = new StringTokenizer(string5, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    vector.addElement(((StringTokenizer)object).nextToken().trim());
                }
            }
            System.out.println(new Date() + " generating classes");
            try {
                object = new MddToClass(vector, string3);
            }
            catch (CannotCompileException cannotCompileException) {
                cannotCompileException.printStackTrace();
            }
            catch (NotFoundException notFoundException) {
                notFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            System.out.println(new Date() + " generating mappings");
            try {
                object = new MddToMapping(vector, configuration, HibernateSFManager.findClassesRootFolder(string2), string4);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                transformerConfigurationException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            System.out.println(new Date() + " building session factory");
            sessionFactory = configuration.buildSessionFactory();
            if ("true".equals(configuration.getProperty("makumba.schemaUpdate"))) {
                System.out.println(new Date() + " peforming schema update");
                object = new SchemaUpdate(configuration);
                object.execute(true, true);
                System.out.println(new Date() + " finished");
            } else {
                System.out.println(new Date() + " skipping schema update");
            }
        }
        return sessionFactory;
    }

    public static synchronized SessionFactory getSF() {
        if (sessionFactory == null) {
            String string = MakumbaSystem.getDefaultDatabaseName() == null ? "default.cfg.xml" : MakumbaSystem.getDefaultDatabaseName() + ".cfg.xml";
            System.out.println("Initializing configuration from " + string);
            return HibernateSFManager.getSF(string);
        }
        return sessionFactory;
    }

    public static Configuration getConfiguration(String string) {
        Configuration configuration = new Configuration().configure(string);
        return configuration;
    }
}

