/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class HtmlTagEnumerator {
    Reader source;
    StringBuffer tag;
    StringBuffer string;
    String lastString;
    String lastTag;
    boolean inTag = false;
    boolean ended = false;

    void init() {
        this.tag = new StringBuffer();
        this.string = new StringBuffer();
    }

    public HtmlTagEnumerator(Reader reader) {
        this.source = reader;
        this.init();
    }

    public boolean next() throws IOException {
        int n;
        if (this.ended) {
            return false;
        }
        while ((n = this.source.read()) != -1) {
            if (n == 60) {
                this.lastString = this.string.toString();
                this.inTag = true;
                this.string = new StringBuffer();
                continue;
            }
            if (n == 62 && this.inTag) {
                this.lastTag = this.tag.toString();
                this.tag = new StringBuffer();
                this.inTag = false;
                return true;
            }
            if (this.inTag) {
                this.tag.append((char)n);
                continue;
            }
            this.string.append((char)n);
        }
        this.source.close();
        this.ended = true;
        return false;
    }

    public String getNonHtml() {
        return this.lastString;
    }

    public String getTag() {
        return this.lastTag;
    }

    public String getTagType() {
        String string = this.lastTag.trim();
        int n = 0;
        if (string.startsWith("/")) {
            n = 1;
        }
        while (n < string.length() && Character.isLetter(string.charAt(n))) {
            ++n;
        }
        return string.substring(0, n);
    }

    public static void main(String[] stringArray) throws IOException {
        HtmlTagEnumerator htmlTagEnumerator = new HtmlTagEnumerator(new FileReader(stringArray[0]));
        while (htmlTagEnumerator.next()) {
            System.out.println(htmlTagEnumerator.getNonHtml() + " " + htmlTagEnumerator.getTag() + " " + htmlTagEnumerator.getTagType());
        }
    }
}

