/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.util;

import java.io.File;
import org.makumba.util.SourceSyntaxPoints;

public abstract class SyntaxPoint
implements Comparable {
    int position;
    int offset = 0;
    boolean begin;
    int line;
    int column;
    SourceSyntaxPoints sourceFile;

    public SyntaxPoint(int n, boolean bl) {
        this.position = n;
        this.begin = bl;
    }

    public SyntaxPoint(int n) {
        this.position = n;
        this.begin = true;
    }

    public int getPosition() {
        return this.position;
    }

    public int getIncludeOffset() {
        return this.offset;
    }

    public int getOriginalPosition() {
        return this.getPosition() - this.getIncludeOffset();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getOriginalColumn(int n) {
        if (this.getColumn() > n + 1) {
            return this.getColumn() - this.getIncludeOffset();
        }
        return this.getColumn();
    }

    public boolean isBegin() {
        return this.begin;
    }

    public abstract String getType();

    public Object getOtherInfo() {
        return null;
    }

    public File getFile() {
        return this.sourceFile.file;
    }

    public static SyntaxPoint makeEnd(SyntaxPoint syntaxPoint, int n) {
        return new End(syntaxPoint, n);
    }

    void moveByInclude(int n) {
        this.position += n;
        this.offset += n;
    }

    public int compareTo(Object object) {
        SyntaxPoint syntaxPoint = (SyntaxPoint)object;
        int n = this.position - syntaxPoint.position;
        if (n != 0) {
            return n;
        }
        if (this.begin == syntaxPoint.begin) {
            if (syntaxPoint.getType().equals("TextLine")) {
                return syntaxPoint.begin ? 1 : -1;
            }
            if (this.getType().equals("TextLine")) {
                return this.begin ? -1 : 1;
            }
            return this.getType().compareTo(syntaxPoint.getType());
        }
        return this.begin ? 1 : -1;
    }

    public boolean equals(Object object) {
        SyntaxPoint syntaxPoint = (SyntaxPoint)object;
        return syntaxPoint != null && this.position == syntaxPoint.position && this.begin == syntaxPoint.begin && this.getType() == syntaxPoint.getType();
    }

    public int hashCode() {
        return this.position * this.getType().hashCode() * (this.begin ? 1 : -1);
    }

    public String toString() {
        return "" + this.position + ":" + (this.begin ? "<" + this.getType() : this.getType() + ">");
    }

    public static class End
    extends SyntaxPoint {
        SyntaxPoint _begin;

        public End(SyntaxPoint syntaxPoint, int n) {
            super(n, false);
            this._begin = syntaxPoint;
        }

        public Object getOtherInfo() {
            return this._begin;
        }

        public String getType() {
            return this._begin.getType();
        }
    }
}

