/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons.attributes;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.makumba.Text;
import org.makumba.commons.attributes.HttpParameters;

public class MultipartHttpParameters
extends HttpParameters {
    Hashtable<String, Object> parameters = new Hashtable();

    void computeAtStart() {
    }

    public boolean knownAtStart(String s) {
        return this.parameters.get(s) != null;
    }

    public MultipartHttpParameters(HttpServletRequest req) {
        super(req);
        Logger.getLogger("org.makumba.fileUpload").fine("\n\n---- code with apache.commons.fileupload  ------\n");
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List items = null;
        try {
            items = upload.parseRequest(this.request);
        }
        catch (FileUploadException e1) {
            e1.printStackTrace();
        }
        for (FileItem item : items) {
            if (item.isFormField()) {
                if (!item.isFormField()) continue;
                String name = item.getFieldName();
                String value = item.getString();
                this.addParameter(name, value);
                continue;
            }
            if (item.isFormField()) continue;
            String name = item.getFieldName();
            String fileName = item.getName();
            if (fileName != null) {
                fileName = FilenameUtils.getName((String)fileName);
            }
            String type = item.getContentType();
            Text contentToSave = new Text(item.get());
            int contentSize = contentToSave.length();
            this.parameters.put(name + "_contentType", type);
            this.parameters.put(name + "_filename", fileName);
            this.parameters.put(name + "_contentLength", new Integer(contentSize));
            this.parameters.put(name, contentToSave);
            Logger.getLogger("org.makumba.fileUpload").fine("Parameters set: contentType=" + type + ", fileName=" + fileName + ", contentSize=" + contentSize);
        }
    }

    void addParameter(String name, String value) {
        Object o = this.parameters.get(name);
        if (o != null) {
            if (o instanceof Vector) {
                ((Vector)o).addElement(value);
            } else {
                Vector<Object> v = new Vector<Object>();
                v.addElement(o);
                v.addElement(value);
                this.parameters.put(name, v);
            }
        } else {
            this.parameters.put(name, value);
        }
    }

    public Object getParameter(String s) {
        return MultipartHttpParameters.compose(this.parameters.get(s), super.getParameter(s));
    }

    static Object compose(Object a1, Object a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        if (a1 instanceof Vector) {
            if (a2 instanceof Vector) {
                Enumeration e = ((Vector)a2).elements();
                while (e.hasMoreElements()) {
                    ((Vector)a1).addElement(e.nextElement());
                }
                return a1;
            }
            ((Vector)a1).addElement(a2);
            return a1;
        }
        if (a2 instanceof Vector) {
            ((Vector)a2).addElement(a1);
            return a2;
        }
        Vector<Object> v = new Vector<Object>();
        v.addElement(a1);
        v.addElement(a2);
        return v;
    }
}

