/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons.formatters;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.commons.formatters.FieldFormatter;
import org.makumba.commons.formatters.dateFormatter;
import org.makumba.commons.formatters.intEnumFormatter;
import org.makumba.commons.formatters.ptrFormatter;
import org.makumba.commons.formatters.timestampFormatter;

public class RecordFormatter
implements Serializable {
    public DataDefinition dd;
    public String[] expr;
    protected transient FieldFormatter[] formatterArray;
    protected boolean isSearchForm;
    private String formResponderValue;
    private static final long serialVersionUID = 1L;

    public RecordFormatter() {
    }

    public RecordFormatter(DataDefinition dd, Hashtable names, boolean isSearchForm, String formResponderValue) {
        this.dd = dd;
        this.isSearchForm = isSearchForm;
        this.formResponderValue = formResponderValue;
        this.initFormatters();
        this.expr = new String[dd.getFieldNames().size()];
        for (int i = 0; i < dd.getFieldNames().size(); ++i) {
            this.expr[i] = (String)names.get(dd.getFieldDefinition(i).getName());
        }
    }

    protected String applyParameters(FieldFormatter ff, Dictionary formatParams, String s) {
        return s;
    }

    public String format(int i, Object value, Dictionary formatParams) {
        this.formatterArray[i].checkParams(this, i, formatParams);
        return this.applyParameters(this.formatterArray[i], formatParams, this.formatterArray[i].format(this, i, value, formatParams));
    }

    protected void initFormatters() {
        this.formatterArray = new FieldFormatter[this.dd.getFieldNames().size()];
        block6: for (int i = 0; i < this.dd.getFieldNames().size(); ++i) {
            FieldDefinition fd = this.dd.getFieldDefinition(i);
            switch (fd.getIntegerType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.formatterArray[i] = ptrFormatter.getInstance();
                    continue block6;
                }
                case 5: {
                    this.formatterArray[i] = intEnumFormatter.getInstance();
                    continue block6;
                }
                case 9: {
                    this.formatterArray[i] = dateFormatter.getInstance();
                    continue block6;
                }
                case 10: 
                case 11: {
                    this.formatterArray[i] = timestampFormatter.getInstance();
                    continue block6;
                }
                default: {
                    this.formatterArray[i] = FieldFormatter.getInstance();
                }
            }
        }
    }

    public String getFormResponderValue() {
        return this.formResponderValue;
    }
}

