/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.providers.Configuration;
import org.makumba.providers.DataDefinitionProviderInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDefinitionProvider
implements DataDefinitionProviderInterface {
    private DataDefinitionProviderInterface dataDefinitionProviderImplementation;
    private static DataDefinitionProvider singleton;

    public static DataDefinitionProvider getInstance() {
        if (singleton == null) {
            singleton = new DataDefinitionProvider();
        }
        return singleton;
    }

    private DataDefinitionProvider() {
        this(new Configuration());
    }

    public DataDefinitionProvider(Configuration c) {
        try {
            this.dataDefinitionProviderImplementation = (DataDefinitionProviderInterface)Class.forName(c.getDataDefinitionProviderClass()).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DataDefinition getDataDefinition(String typeName) {
        return this.dataDefinitionProviderImplementation.getDataDefinition(typeName);
    }

    @Override
    public Vector<String> getDataDefinitionsInLocation(String location) {
        return this.dataDefinitionProviderImplementation.getDataDefinitionsInLocation(location);
    }

    @Override
    public DataDefinition getVirtualDataDefinition(String name) {
        return this.dataDefinitionProviderImplementation.getVirtualDataDefinition(name);
    }

    @Override
    public FieldDefinition makeFieldDefinition(String name, String definition) {
        return this.dataDefinitionProviderImplementation.makeFieldDefinition(name, definition);
    }

    @Override
    public FieldDefinition makeFieldOfType(String name, String type) {
        return this.dataDefinitionProviderImplementation.makeFieldOfType(name, type);
    }

    @Override
    public FieldDefinition makeFieldOfType(String name, String type, String description) {
        return this.dataDefinitionProviderImplementation.makeFieldOfType(name, type, description);
    }

    @Override
    public FieldDefinition makeFieldWithName(String name, FieldDefinition type) {
        return this.dataDefinitionProviderImplementation.makeFieldWithName(name, type);
    }

    @Override
    public FieldDefinition makeFieldWithName(String name, FieldDefinition type, String description) {
        return this.dataDefinitionProviderImplementation.makeFieldWithName(name, type, description);
    }

    public static final FieldDefinition getFieldDefinition(DataDefinition dd, String fieldName, String lineWithDefinition) throws DataDefinitionParseError {
        DataDefinition checkedDataDef = dd;
        int indexOf = -1;
        while ((indexOf = fieldName.indexOf(".")) != -1) {
            String subFieldName = fieldName.substring(0, indexOf);
            fieldName = fieldName.substring(indexOf + 1);
            checkedDataDef = checkedDataDef.getFieldDefinition(subFieldName).getPointedType();
        }
        FieldDefinition fd = checkedDataDef.getFieldDefinition(fieldName);
        if (fd == null) {
            throw new DataDefinitionParseError(checkedDataDef.getName(), "Field '" + fieldName + "' not defined in type " + dd.getName() + "!", lineWithDefinition);
        }
        return fd;
    }
}

