/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidFieldTypeException;
import org.makumba.NoSuchFieldException;
import org.makumba.NoSuchLabelException;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.QueryAnalysisProvider;

public abstract class QueryProvider {
    private static String[] queryProviders = new String[]{"oql", "org.makumba.db.makumba.OQLQueryProvider", "hql", "org.makumba.db.hibernate.HQLQueryProvider"};
    static final Map<String, Class<?>> providerClasses = new HashMap();
    static final Map<Class<?>, String> providerClassesReverse = new HashMap();
    private String dataSource;
    private QueryAnalysisProvider qap;

    public QueryProvider() {
        try {
            if (this.getQueryAnalysisProviderClass() != null && this.qap == null) {
                this.qap = (QueryAnalysisProvider)Class.forName(this.getQueryAnalysisProviderClass()).newInstance();
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected String getQueryAnalysisProviderClass() {
        return null;
    }

    public static QueryProvider makeQueryAnalzyer(String name) {
        try {
            return (QueryProvider)providerClasses.get(name).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static QueryProvider makeQueryRunner(String dataSource, String name) {
        QueryProvider qeep = QueryProvider.makeQueryAnalzyer(name);
        qeep.init(dataSource);
        return qeep;
    }

    public void init(String dataSource) {
        this.dataSource = dataSource;
    }

    public abstract Vector execute(String var1, Map var2, int var3, int var4);

    public String preprocessMDDFunctionsAtExecute(String query) {
        return query;
    }

    public abstract void close();

    public abstract String getPrimaryKeyNotation(String var1);

    public QueryAnalysis getQueryAnalysis(String query) {
        return this.qap.getQueryAnalysis(this.preprocessMDDFunctionsAtQueryAnalysis(query));
    }

    public String preprocessMDDFunctionsAtQueryAnalysis(String query) {
        return query;
    }

    public Object checkExprSetOrNullable(String from, String expr) {
        if (expr.toLowerCase().indexOf(" from ") != -1) {
            return null;
        }
        String query = "SELECT " + expr + " FROM " + from;
        query = this.preprocessMDDFunctionsAtQueryAnalysis(query);
        expr = query.substring(7);
        expr = expr.substring(0, expr.indexOf("FROM"));
        int n = 0;
        int m = 0;
        while (true) {
            if (n < expr.length() && !QueryProvider.isMakId(expr.charAt(n))) {
                ++n;
                continue;
            }
            if (n == expr.length()) {
                return null;
            }
            m = n;
            while (n < expr.length() && QueryProvider.isMakId(expr.charAt(n))) {
                ++n;
            }
            Object nl = this.checkLabelSetOrNullable(from, expr.substring(m, n));
            if (nl != null) {
                return nl;
            }
            if (n == expr.length()) break;
        }
        return null;
    }

    static boolean isMakId(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.';
    }

    public Object checkLabelSetOrNullable(String from, String referenceSequence) {
        int dot = referenceSequence.indexOf(".");
        if (dot == -1) {
            return null;
        }
        String substring = referenceSequence.substring(0, dot);
        try {
            Integer.parseInt(substring);
            return null;
        }
        catch (NumberFormatException e) {
            DataDefinition dd = this.getQueryAnalysis("SELECT 1 FROM " + from).getLabelType(substring);
            if (dd == null) {
                throw new NoSuchLabelException("no such label '" + substring + "'.");
            }
            while (true) {
                int dot1;
                if ((dot1 = referenceSequence.indexOf(".", dot + 1)) == -1) {
                    String fn = referenceSequence.substring(dot + 1);
                    FieldDefinition fd = dd.getFieldDefinition(fn);
                    if (fd == null && (fd = this.getAlternativeField(dd, fn)) == null) {
                        throw new NoSuchFieldException(dd, fn);
                    }
                    if (fd.getType().equals("set")) {
                        return fd;
                    }
                    return null;
                }
                FieldDefinition fd = dd.getFieldDefinition(referenceSequence.substring(dot + 1, dot1));
                if (fd == null) {
                    throw new NoSuchFieldException(dd, referenceSequence.substring(dot + 1, dot1));
                }
                if (!fd.getType().startsWith("ptr")) {
                    throw new InvalidFieldTypeException(fd, "pointer");
                }
                if (!fd.isNotNull()) {
                    return referenceSequence.substring(0, dot1);
                }
                dd = fd.getPointedType();
                dot = dot1;
            }
        }
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public abstract boolean selectGroupOrOrderAsLabels();

    public abstract FieldDefinition getAlternativeField(DataDefinition var1, String var2);

    static {
        for (int i = 0; i < queryProviders.length; i += 2) {
            try {
                providerClasses.put(queryProviders[i], Class.forName(queryProviders[i + 1]));
                providerClassesReverse.put(Class.forName(queryProviders[i + 1]), queryProviders[i]);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

