/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidFieldTypeException;
import org.makumba.NoSuchFieldException;
import org.makumba.NoSuchLabelException;
import org.makumba.ProgrammerError;
import org.makumba.providers.QueryProvider;

public class FunctionInliner {
    public static String NAME = "[a-zA-Z]\\w*";
    public static final String PATTERN_FUNCTION_CALL_BEGIN = "((" + NAME + ")(" + "[\\s]*" + "\\." + "[\\s]*" + NAME + ")+)" + "[\\s]*" + "\\(";
    public static final Pattern functionBegin = Pattern.compile(PATTERN_FUNCTION_CALL_BEGIN);
    private String from;
    private String beforeFunction;
    private String afterFunction;
    private String functionText;
    private ArrayList<String> parameterExpr = new ArrayList();
    private ArrayList<String> parameterInline = new ArrayList();
    private DataDefinition.QueryFragmentFunction functionDefinition;
    private String inlinedFunction;
    private String functionObject;

    public FunctionInliner(String query, QueryProvider qp) {
        this(query, FunctionInliner.findFrom(query), qp);
    }

    public FunctionInliner(String query, String from, QueryProvider qp) {
        this.findFunctionComponents(query, from, qp);
        if (this.functionText != null) {
            if (this.functionDefinition.getParameters().getFieldNames().size() != this.parameterExpr.size()) {
                throw new ProgrammerError("parameter number " + this.parameterExpr + " does not match function " + this.functionDefinition);
            }
            int n = 0;
            for (String parameter : this.parameterExpr) {
                String inlineParameter = FunctionInliner.inline(parameter, from, qp);
                this.parameterInline.add(inlineParameter);
                this.checkParameter(n, parameter, inlineParameter, qp);
                ++n;
            }
            this.doInline();
        }
    }

    private void doInline() {
        this.inlinedFunction = "(" + this.functionDefinition.getQueryFragment() + ")";
        for (int i = 0; i < this.parameterExpr.size(); ++i) {
            this.inlinedFunction = this.inlinedFunction.replaceAll(this.functionDefinition.getParameters().getFieldDefinition(i).getName(), "(" + this.parameterInline.get(i) + ")");
        }
        this.inlinedFunction = this.inlinedFunction.replaceAll("this", this.functionObject);
    }

    private void checkParameter(int n, String parameter, String inlineParameter, QueryProvider qp) {
        FieldDefinition actual;
        FieldDefinition fieldDefinition = this.functionDefinition.getParameters().getFieldDefinition(n);
        if (!fieldDefinition.isAssignableFrom(actual = qp.getQueryAnalysis("SELECT " + inlineParameter + " FROM " + this.from).getProjectionType().getFieldDefinition(0))) {
            throw new ProgrammerError("formal paramter " + fieldDefinition.getName() + " of type " + fieldDefinition.getDataType() + " is not matched by the actual value given " + parameter + " of type " + actual.getDataType() + " for function " + this.functionDefinition);
        }
    }

    private String inline() {
        if (this.functionText == null) {
            return this.beforeFunction;
        }
        return this.beforeFunction + this.inlinedFunction;
    }

    private void findFunctionComponents(String query, String from, QueryProvider qp) {
        Matcher m = functionBegin.matcher(query);
        if (!m.find()) {
            this.beforeFunction = query;
            this.afterFunction = null;
        } else {
            this.from = from;
            this.beforeFunction = query.substring(0, m.start());
            int parLevel = 1;
            int index = m.end();
            int lastParam = m.end();
            while (parLevel > 0) {
                char c = query.charAt(index);
                if (c == ')') {
                    if (parLevel == 1 && index != lastParam) {
                        this.parameterExpr.add(query.substring(lastParam, index));
                    }
                    --parLevel;
                } else if (c == '(') {
                    ++parLevel;
                }
                if (parLevel == 1 && c == ',') {
                    this.parameterExpr.add(query.substring(lastParam, index));
                    lastParam = index + 1;
                }
                ++index;
            }
            this.afterFunction = query.substring(index);
            this.functionText = query.substring(m.start(), index);
            DataDefinition dd = qp.getQueryAnalysis("SELECT 1 FROM " + from).getLabelType(m.group(2));
            if (dd == null) {
                throw new NoSuchLabelException("no such label '" + m.group(2) + "'.");
            }
            String referenceSequence = m.group(1);
            int dot = referenceSequence.indexOf(".");
            while (true) {
                int dot1;
                if ((dot1 = referenceSequence.indexOf(".", dot + 1)) == -1) {
                    String fn = referenceSequence.substring(dot + 1);
                    this.functionDefinition = dd.getFunction(fn);
                    if (this.functionDefinition == null) {
                        throw new ProgrammerError(fn + " is not a function in " + dd.getName());
                    }
                    this.functionObject = referenceSequence.substring(0, dot);
                    break;
                }
                FieldDefinition fd = dd.getFieldDefinition(referenceSequence.substring(dot + 1, dot1));
                if (fd == null) {
                    throw new NoSuchFieldException(dd, referenceSequence.substring(dot + 1, dot1));
                }
                if (!fd.getType().startsWith("ptr")) {
                    throw new InvalidFieldTypeException(fd, "pointer");
                }
                dd = fd.getPointedType();
                dot = dot1;
            }
        }
    }

    public String getBeforeFunction() {
        return this.beforeFunction;
    }

    public String getAfterFunction() {
        return this.afterFunction;
    }

    public String toString() {
        return this.beforeFunction + " [" + this.functionText + ":" + this.parameterInline + ":" + this.functionDefinition + ":" + this.functionObject + ":" + this.inline() + "] " + this.afterFunction;
    }

    public static String findFrom(String query) {
        String lower = query.toLowerCase();
        int parLevel = 0;
        int fromBegin = -1;
        int index = 0;
        while (true) {
            String toRighty = lower.substring(index);
            if (parLevel == 0 && toRighty.startsWith(" from ")) {
                fromBegin = index + 6;
            }
            if (parLevel == 0 && (toRighty.length() == 0 || toRighty.startsWith(" where ") || toRighty.startsWith(" group by ") || toRighty.startsWith(" order by"))) {
                return query.substring(fromBegin, index);
            }
            char c = query.charAt(index);
            if (c == ')') {
                --parLevel;
            } else if (c == '(') {
                ++parLevel;
            }
            ++index;
        }
    }

    public static String inline(String query, QueryProvider qp) {
        return FunctionInliner.inline(query, FunctionInliner.findFrom(query), qp);
    }

    public static String inline(String expression, String from, QueryProvider qp) {
        boolean didInline;
        String inlinedQuery = expression;
        do {
            StringBuffer inlined = new StringBuffer();
            didInline = false;
            String toRight = inlinedQuery;
            while (true) {
                FunctionInliner fi = new FunctionInliner(toRight, from, qp);
                toRight = fi.getAfterFunction();
                inlined.append(fi.inline());
                if (toRight == null) break;
                didInline = true;
            }
            inlinedQuery = inlined.toString();
        } while (didInline);
        return inlinedQuery;
    }

    public static void main(String[] args) throws Exception {
        String[] queries = new String[]{"SELECT p FROM test.Person p WHERE p.nameMin3CharsLong()", "SELECT p as p, p.indiv as indiv FROM test.Person p WHERE p.nameMin3CharsLong()", "SELECT p AS  p, p.indiv   AS    indiv FROM test.Person p WHERE p.nameMin3CharsLong()", "SELECT p FROM test.Person p WHERE p.nameMin3CharsLong() AND p.nameMin2CharsLong() AND p.name<>NIL", "SELECT p FROM test.Person p WHERE p.name<>NIL OR p.nameMin3CharsLong() AND p.nameMin2CharsLong()", "SELECT p.nameMin3CharsLong() FROM test.Person p", "SELECT p.indiv.name AS col1,character_length(p.indiv.name) AS col2 FROM test.Person p WHERE p.someFunctionWithParams(2,5,7)"};
        for (int i = 0; i < queries.length; ++i) {
            System.out.println(queries[i] + "\n -> " + FunctionInliner.inline(queries[i], QueryProvider.makeQueryAnalzyer("oql")));
        }
    }
}

