/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.collection.BasicCollectionJoinWalker;
import org.hibernate.loader.collection.CollectionLoader;
import org.hibernate.persister.collection.QueryableCollection;

public class BasicCollectionLoader
extends CollectionLoader {
    private static final Log log = LogFactory.getLog((Class)BasicCollectionLoader.class);

    public BasicCollectionLoader(QueryableCollection collectionPersister, SessionFactoryImplementor session, Map enabledFilters) throws MappingException {
        this(collectionPersister, 1, session, enabledFilters);
    }

    public BasicCollectionLoader(QueryableCollection collectionPersister, int batchSize, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        this(collectionPersister, batchSize, null, factory, enabledFilters);
    }

    protected BasicCollectionLoader(QueryableCollection collectionPersister, int batchSize, String subquery, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        super(collectionPersister, factory, enabledFilters);
        BasicCollectionJoinWalker walker = new BasicCollectionJoinWalker(collectionPersister, batchSize, subquery, factory, enabledFilters);
        this.initFromWalker(walker);
        this.postInstantiate();
        log.debug((Object)("Static select for collection " + collectionPersister.getRole() + ": " + this.getSQLString()));
    }
}

