/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.responder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.makumba.CompositeValidationException;
import org.makumba.DataDefinition;
import org.makumba.InvalidValueException;
import org.makumba.LogicException;
import org.makumba.MakumbaError;
import org.makumba.Pointer;
import org.makumba.commons.attributes.RequestAttributes;
import org.makumba.forms.responder.ResponderCacheManager;
import org.makumba.forms.responder.ResponderFactory;
import org.makumba.forms.responder.ResponderOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Responder
implements Serializable {
    public static final String responderName = "__makumba__responder__";
    public static final String originatingPageName = "__makumba__originatingPage__";
    public static final String formSessionName = "__makumba__formSession__";
    public static final String FORM_RESULTS = "org.makumba.formResults";
    public static final String anonymousResult = "___mak___edited___";
    public static final String defaultMessage = "changes done";
    public static final String defaultMessageSearchForm = "Search done!";
    public static final String basePointerName = "__makumba__base__";
    protected transient ResponderFactory factory;
    protected int identity;
    protected transient Object controller;
    protected String controllerClassname;
    protected String database;
    protected String message = "changes done";
    protected String multipleSubmitErrorMsg;
    protected String clientSideValidation;
    protected boolean reloadFormOnError;
    private boolean showFormAnnotated;
    protected String resultAttribute = "___mak___edited___";
    protected String handler;
    protected String afterHandler;
    protected String basePointerType;
    protected String searchType;
    protected String formName;
    protected String newType;
    protected String addField;
    protected String operation;
    protected ResponderOperation op;
    protected ArrayList<String> formOrder;
    transient int groupCounter = 0;
    protected transient String storedSuffix = "";
    protected transient String storedParentSuffix = "";
    private Hashtable<String, String[]> multiFieldSearchMapping = new Hashtable();
    protected static final char suffixSeparator = '_';

    public String getHandler() {
        return this.handler;
    }

    public String getAfterHandler() {
        return this.afterHandler;
    }

    public String getAddField() {
        return this.addField;
    }

    public String getBasePointerType() {
        return this.basePointerType;
    }

    public Object getController() {
        return this.controller;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getNewType() {
        return this.newType;
    }

    public String getSearchType() {
        return this.searchType;
    }

    public String getFormName() {
        return this.formName;
    }

    public ArrayList<String> getFormOrder() {
        return this.formOrder;
    }

    public void setHttpRequest(HttpServletRequest req) throws LogicException {
        this.controller = RequestAttributes.getAttributes(req).getRequestController();
        this.database = RequestAttributes.getAttributes(req).getRequestDatabase();
    }

    public void setOperation(String operation, ResponderOperation op) {
        this.operation = operation;
        this.op = op;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMultipleSubmitErrorMsg(String multipleSubmitErrorMsg) {
        this.multipleSubmitErrorMsg = multipleSubmitErrorMsg;
    }

    public void setReloadFormOnError(boolean reloadFormOnError) {
        this.reloadFormOnError = reloadFormOnError;
    }

    public boolean getReloadFormOnError() {
        return this.reloadFormOnError;
    }

    public void setShowFormAnnotated(boolean showFormAnnotated) {
        this.showFormAnnotated = showFormAnnotated;
    }

    public boolean getShowFormAnnotated() {
        return this.showFormAnnotated;
    }

    public void setClientSideValidation(String clientSideValidation) {
        this.clientSideValidation = clientSideValidation;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public void setAfterHandler(String afterHandler) {
        this.afterHandler = afterHandler;
    }

    public void setBasePointerType(String basePointerType) {
        this.basePointerType = basePointerType;
    }

    public void setResultAttribute(String resultAttribute) {
        this.resultAttribute = resultAttribute;
    }

    public void setAddField(String s) {
        this.addField = s;
    }

    public void setNewType(DataDefinition dd) {
        this.newType = dd.getName();
    }

    public void setSearchType(DataDefinition dd) {
        this.searchType = dd.getName();
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public void setResponderOrder(ArrayList<String> formOrder) {
        this.formOrder = formOrder;
    }

    protected abstract void postDeserializaton();

    public String responderKey() {
        return this.basePointerType + this.message + this.multipleSubmitErrorMsg + this.resultAttribute + this.database + this.operation + this.controller.getClass().getName() + this.handler + this.addField + this.newType + this.reloadFormOnError + this.showFormAnnotated + this.clientSideValidation;
    }

    public int getPrototype() {
        String s = this.op.verify(this);
        if (s != null) {
            throw new MakumbaError("Bad responder configuration " + s);
        }
        return this.factory.getResponderIdentity(this);
    }

    public void setParentResponder(Responder resp, Responder root) {
        this.storedSuffix = "_" + ++root.groupCounter;
        this.storedParentSuffix = resp.storedSuffix;
    }

    public String getSuffix() {
        return this.storedSuffix;
    }

    public static String errorMessage(Throwable t) {
        return Responder.errorMessage(t.getMessage());
    }

    public static String errorMessage(String message) {
        return "<font color=red>" + message + "</font>";
    }

    public Pointer getHttpBasePointer(HttpServletRequest req, String suffix) {
        return new Pointer(this.basePointerType, (String)RequestAttributes.getParameters(req).getParameter(basePointerName + suffix));
    }

    public abstract Dictionary<String, Object> getHttpData(HttpServletRequest var1, String var2);

    public abstract ArrayList<InvalidValueException> getUnassignedExceptions(CompositeValidationException var1, ArrayList<InvalidValueException> var2, String var3);

    public ResponderFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ResponderFactory factory) {
        this.factory = factory;
    }

    public void addMultiFieldSearchMapping(String name, String[] allFieldNames) {
        this.multiFieldSearchMapping.put(name, allFieldNames);
    }

    public String[] getMultiFieldSearchCriterion(String name) {
        return this.multiFieldSearchMapping.get(name);
    }

    public void saveResponderToDisc() {
        String fileName = ResponderCacheManager.validResponderFilename(this.identity);
        File file = new File(fileName);
        try {
            this.controllerClassname = this.controller.getClass().getName();
            ObjectOutputStream objectOut = new ObjectOutputStream(new FileOutputStream(file));
            objectOut.writeObject(this);
            objectOut.close();
        }
        catch (IOException e) {
            Logger.getLogger("org.makumba.controller").log(Level.SEVERE, "Error while writing responder to HDD, deleting file " + fileName, e);
            file.delete();
        }
    }
}

