/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import org.makumba.commons.ClassResource;

public class Configuration
implements Serializable {
    private static final String PLACEHOLDER_CONTEXT_PATH = "_CONTEXT_PATH_";
    public static String defaultClientSideValidation = "live";
    public static boolean defaultReloadFormOnError = true;
    private static boolean defaultCalendarEditor = true;
    private static String defaultCalendarEditorLink = "<img border=\"0\" src=\"_CONTEXT_PATH_/makumbaResources/image/calendar.gif\">";
    private static final long serialVersionUID = 1L;
    private static final String defaultDataDefinitionProvider = "org.makumba.providers.datadefinition.makumba.MakumbaDataDefinitionFactory";
    private String defaultTransactionProvider = "org.makumba.db.makumba.MakumbaTransactionProvider";
    private static Properties controllerConfig = new Properties();
    private String dataDefinitionProvider = null;

    public Configuration() {
        if (controllerConfig != null) {
            this.defaultTransactionProvider = controllerConfig.getProperty("defaultTransactionProvider", this.defaultTransactionProvider);
        }
    }

    private String getDefaultDataDefinitionProviderClass() {
        return defaultDataDefinitionProvider;
    }

    public String getDataDefinitionProviderClass() {
        return this.dataDefinitionProvider == null ? this.getDefaultDataDefinitionProviderClass() : this.dataDefinitionProvider;
    }

    public String getDefaultTransactionProviderClass() {
        return this.defaultTransactionProvider;
    }

    public void setDataDefinitionProvider(String ddp) {
        this.dataDefinitionProvider = ddp;
    }

    public void setDefaultTransactionProvider(String defaultTransactionProvider) {
        this.defaultTransactionProvider = defaultTransactionProvider;
    }

    public static String getClientSideValidationDefault() {
        return defaultClientSideValidation;
    }

    public static boolean getReloadFormOnErrorDefault() {
        return defaultReloadFormOnError;
    }

    public static boolean getCalendarEditorDefault() {
        return defaultCalendarEditor;
    }

    public static String getDefaultCalendarEditorLink(String contextPath) {
        return defaultCalendarEditorLink.replaceAll(PLACEHOLDER_CONTEXT_PATH, contextPath);
    }

    static {
        try {
            URL controllerURL = ClassResource.get("MakumbaController.properties");
            controllerConfig.load(controllerURL.openStream());
            defaultClientSideValidation = controllerConfig.getProperty("defaultClientSideValidation", defaultClientSideValidation);
            defaultReloadFormOnError = Boolean.parseBoolean(controllerConfig.getProperty("defaultReloadFormOnError", String.valueOf(defaultReloadFormOnError)));
            defaultCalendarEditorLink = controllerConfig.getProperty("defaultCalendarEditorLink", defaultCalendarEditorLink);
            defaultCalendarEditor = Boolean.parseBoolean(controllerConfig.getProperty("defaultCalendarEditor", String.valueOf(defaultCalendarEditor)));
        }
        catch (Exception e) {
            controllerConfig = null;
        }
    }
}

