/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.makumba.HtmlUtils;
import org.makumba.ProgrammerError;

public class HtmlChoiceWriter
extends HtmlUtils {
    private static String NEWL = "\n";
    private static String[] EMPTY_ARRAY = new String[0];
    private String _name = null;
    private Iterator _values = null;
    private Iterator _labels = null;
    private String[] _selectedValues = EMPTY_ARRAY;
    private String[] _deprecatedValues = EMPTY_ARRAY;
    private boolean _ismultiple = false;
    private int _size = 1;
    private int _convert2Html = NO_CONV;
    private String _literalHtml = "";
    private String _tickLabelSeparator = " ";
    private String[] _optionSeparator = new String[]{" "};
    public static int NO_CONV = 0;
    public static int TXT2HTML = 1;

    public HtmlChoiceWriter() {
    }

    public HtmlChoiceWriter(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setValues(List values) {
        this._values = values.iterator();
    }

    public void setValues(String[] values) {
        this._values = Arrays.asList(values).iterator();
    }

    public void setValues(Iterator values) {
        this._values = values;
    }

    public void setLabels(List labels) {
        this._labels = labels.iterator();
    }

    public void setLabels(String[] labels) {
        this._labels = Arrays.asList(labels).iterator();
    }

    public void setLabels(Iterator labels) {
        this._labels = labels;
    }

    public void setSelectedValues(String selected) {
        if (selected != null) {
            String[] ss = new String[]{selected};
            this._selectedValues = ss;
        } else {
            this._selectedValues = EMPTY_ARRAY;
        }
    }

    public void setSelectedValues(String[] selected) {
        if (selected != null) {
            this._selectedValues = selected;
            Arrays.sort(selected);
        } else {
            this._selectedValues = EMPTY_ARRAY;
        }
    }

    public void setSelectedValues(List selected) {
        if (selected != null) {
            this._selectedValues = (String[])selected.toArray();
            Arrays.sort(this._selectedValues);
        } else {
            this._selectedValues = EMPTY_ARRAY;
        }
    }

    public void setDeprecatedValues(String[] deprecated) {
        if (deprecated != null) {
            this._deprecatedValues = deprecated;
            Arrays.sort(deprecated);
        } else {
            this._deprecatedValues = EMPTY_ARRAY;
        }
    }

    public void setDeprecatedValues(List deprecated) {
        if (deprecated != null) {
            this._deprecatedValues = (String[])deprecated.toArray();
            Arrays.sort(this._deprecatedValues);
        } else {
            this._deprecatedValues = EMPTY_ARRAY;
        }
    }

    public void setMultiple(boolean yn) {
        this._ismultiple = yn;
    }

    public void setMultiple(String mult) {
        this._ismultiple = mult != null && mult.indexOf("multiple") >= 0;
    }

    public void setSize(int n) {
        if (n > 0) {
            this._size = n;
        }
    }

    public void setConvert2Html(int n) {
        this._convert2Html = n;
    }

    public void setLiteralHtml(String html) {
        this._literalHtml = html;
    }

    public void setTickLabelSeparator(String s) {
        this._tickLabelSeparator = s;
    }

    public void setOptionSeparator(String s) {
        String[] ss = new String[]{s};
        this._optionSeparator = ss;
    }

    public void setOptionSeparator(String[] s) {
        if (s != null && s.length > 0) {
            this._optionSeparator = s;
        }
    }

    public void setOptionSeparator(List s) {
        if (s != null && s.size() > 0) {
            this._optionSeparator = (String[])s.toArray();
        }
    }

    public String getSelect() {
        if (this._ismultiple) {
            return this.getSelectMultiple();
        }
        return this.getSelectOne();
    }

    public String getSelectOne() {
        boolean yn_convert2Html = this._convert2Html == TXT2HTML;
        String selectedValue = this._selectedValues.length != 0 ? this._selectedValues[0] : null;
        Iterator itv = this._values;
        Iterator itl = this._labels;
        StringBuffer selectStatement = new StringBuffer(512);
        selectStatement.append("<SELECT NAME=\"" + this._name + "\" SIZE=" + this._size + " " + this._literalHtml + ">\n");
        while (itv.hasNext() && itl.hasNext()) {
            Object val = itv.next();
            String label = (String)itl.next();
            if (val == null) {
                throw new ProgrammerError("Non-option text " + label + " found. Non-otion text cannot break simple SELECTs. Use type=\"tickbox\" instead");
            }
            String value = val.toString();
            boolean yn_selected = value.equals(selectedValue);
            if (!yn_selected && Arrays.binarySearch(this._deprecatedValues, value) >= 0) continue;
            if (yn_convert2Html) {
                value = HtmlUtils.string2html(value);
                label = HtmlUtils.string2html(label);
            }
            String selected = yn_selected ? " SELECTED" : "";
            selectStatement.append("\t<OPTION value=\"" + value + "\"" + selected + ">" + label + "</OPTION>\n");
        }
        selectStatement.append("</SELECT>");
        return selectStatement.toString();
    }

    public String getSelectMultiple() {
        boolean yn_convert2Html = this._convert2Html == TXT2HTML;
        Iterator itv = this._values;
        Iterator itl = this._labels;
        StringBuffer selectStatement = new StringBuffer(512);
        String selectString = "<SELECT MULTIPLE NAME=\"" + this._name + "\" SIZE=" + this._size + " " + this._literalHtml + ">\n";
        boolean selectStarted = false;
        while (itv.hasNext() && itl.hasNext()) {
            boolean yn_selected;
            Object val = itv.next();
            String label = (String)itl.next();
            if (val == null) {
                selectStatement.append(label);
                if (selectStarted) {
                    selectStatement.append("</SELECT>");
                }
                selectStarted = false;
                continue;
            }
            if (!selectStarted) {
                selectStatement.append(selectString);
            }
            selectStarted = true;
            String value = val.toString();
            boolean bl = yn_selected = Arrays.binarySearch(this._selectedValues, value) >= 0;
            if (!yn_selected && Arrays.binarySearch(this._deprecatedValues, value) >= 0) continue;
            if (yn_convert2Html) {
                value = HtmlUtils.string2html(value);
                label = HtmlUtils.string2html(label);
            }
            String selected = yn_selected ? " SELECTED" : "";
            selectStatement.append("\t<OPTION VALUE=\"" + value + "\"" + selected + ">" + label + "</OPTION>\n");
        }
        selectStatement.append("</SELECT>");
        return selectStatement.toString();
    }

    private String makeCheckboxOrRadio(String type) {
        boolean yn_convert2Html = this._convert2Html == TXT2HTML;
        Iterator itv = this._values;
        Iterator itl = this._labels;
        StringBuffer inputStatement = new StringBuffer(512);
        int j = -1;
        String sep = "";
        while (itv.hasNext() && itl.hasNext()) {
            boolean yn_selected;
            inputStatement.append(sep);
            String label = (String)itl.next();
            Object val = itv.next();
            if (val == null) {
                inputStatement.append(label);
                continue;
            }
            String value = val.toString();
            boolean bl = yn_selected = Arrays.binarySearch(this._selectedValues, value) >= 0;
            if (!yn_selected && Arrays.binarySearch(this._deprecatedValues, value) >= 0) continue;
            if (yn_convert2Html) {
                value = HtmlUtils.string2html(value);
                label = HtmlUtils.string2html(label);
            }
            String selected = yn_selected ? " CHECKED " : " ";
            j = (j + 1) % this._optionSeparator.length;
            sep = this._optionSeparator[j];
            String id = "AutoLabel_" + Long.toString(Math.round(Math.random() * 1.0E8));
            inputStatement.append("<INPUT TYPE=" + type + " NAME=\"" + this._name + "\" " + this._literalHtml + " ");
            inputStatement.append("VALUE=\"" + value + "\"" + selected + " id=\"" + id + "\">" + this._tickLabelSeparator + "<LABEL for=\"" + id + "\">" + label + "</LABEL>");
        }
        return inputStatement.toString();
    }

    public String getRadioSelect() {
        return this.makeCheckboxOrRadio("RADIO");
    }

    public String getCheckboxSelect() {
        return this.makeCheckboxOrRadio("CHECKBOX");
    }

    public static String makeHtmlSelectOne(String name, List values, List labels, String selectedValue, String literalHtml, int convert2Html) {
        if (values.size() != labels.size()) {
            throw new IllegalArgumentException("error: values, labels not equal length");
        }
        boolean yn_convert2Html = convert2Html == TXT2HTML;
        StringBuffer selectStatement = new StringBuffer(512);
        selectStatement.append("<SELECT NAME=\"" + name + "\" " + literalHtml + ">\n");
        Iterator itv = values.iterator();
        Iterator itl = labels.iterator();
        while (itv.hasNext()) {
            String value = itv.next().toString();
            String label = (String)itl.next();
            if (yn_convert2Html) {
                value = HtmlUtils.string2html(value);
                label = HtmlUtils.string2html(label);
            }
            String selected = value.equals(selectedValue) ? " SELECTED" : "";
            selectStatement.append("\t<OPTION value=\"" + value + "\"" + selected + ">" + label + "</OPTION>\n");
        }
        selectStatement.append("</SELECT>");
        return selectStatement.toString();
    }

    public static String makeHtmlSelectOne(String name, String[] values, String[] labels, String selectedValue, String literalHtml, int convert2Html) {
        if (values.length != labels.length) {
            throw new IllegalArgumentException("error: values, labels not equal length");
        }
        boolean yn_convert2Html = convert2Html == TXT2HTML;
        StringBuffer selectStatement = new StringBuffer(512);
        selectStatement.append("<SELECT NAME=\"" + name + "\" " + literalHtml + ">\n");
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            String label = labels[i];
            if (yn_convert2Html) {
                value = HtmlUtils.string2html(value);
                label = HtmlUtils.string2html(label);
            }
            String selected = value.equals(selectedValue) ? " SELECTED" : "";
            selectStatement.append("\t<OPTION value=\"" + value + "\"" + selected + ">" + label + "</OPTION>\n");
        }
        selectStatement.append("</SELECT>");
        return selectStatement.toString();
    }

    public static String makeHtmlSelectMultiple(String name, String[] values, String[] labels, String[] selectedValues, int size, String literalHtml, int convert2Html) {
        if (values.length != labels.length) {
            throw new IllegalArgumentException("error: values, labels not equal length");
        }
        if (selectedValues == null) {
            selectedValues = EMPTY_ARRAY;
        } else {
            Arrays.sort(selectedValues);
        }
        boolean yn_convert2Html = convert2Html == TXT2HTML;
        StringBuffer selectStatement = new StringBuffer(512);
        selectStatement.append("<SELECT MULTIPLE NAME=\"" + name + "\" SIZE=" + size + " " + literalHtml + ">\n");
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            String label = labels[i];
            if (yn_convert2Html) {
                value = HtmlUtils.string2html(value);
                label = HtmlUtils.string2html(label);
            }
            String selected = Arrays.binarySearch(selectedValues, value) < 0 ? "" : " SELECTED";
            selectStatement.append("\t<OPTION VALUE=\"" + value + "\"" + selected + ">" + label + "</OPTION>\n");
        }
        selectStatement.append("</SELECT>");
        return selectStatement.toString();
    }

    public static String makeHtmlRadioSelect(String name, String[] values, String[] labels, String selectedValue, String checkboxLabelSeparator, String[] optionSeparator, String literalHtml, int convert2Html) {
        String[] selectedValues = new String[]{selectedValue};
        return HtmlChoiceWriter.makeHtmlCheckboxOrRadioStatement(name, values, labels, selectedValues, checkboxLabelSeparator, optionSeparator, literalHtml, convert2Html, "RADIO");
    }

    public static String makeHtmlCheckboxSelect(String name, String[] values, String[] labels, String[] selectedValues, String checkboxLabelSeparator, String[] optionSeparator, String literalHtml, int convert2Html) {
        return HtmlChoiceWriter.makeHtmlCheckboxOrRadioStatement(name, values, labels, selectedValues, checkboxLabelSeparator, optionSeparator, literalHtml, convert2Html, "CHECKBOX");
    }

    private static String makeHtmlCheckboxOrRadioStatement(String name, String[] values, String[] labels, String[] selectedValues, String checkboxLabelSeparator, String[] optionSeparator, String literalHtml, int convert2Html, String type) {
        if (values.length != labels.length) {
            throw new IllegalArgumentException("error: values, labels not equal length");
        }
        if (selectedValues == null) {
            selectedValues = EMPTY_ARRAY;
        } else {
            Arrays.sort(selectedValues);
        }
        boolean yn_convert2Html = convert2Html == TXT2HTML;
        StringBuffer inputStatement = new StringBuffer(512);
        int j = -1;
        for (int i = 0; i < values.length; ++i) {
            j = (j + 1) % optionSeparator.length;
            inputStatement.append("<INPUT TYPE=" + type + " NAME=\"" + name + "\" " + literalHtml + " ");
            String value = values[i];
            String label = labels[i];
            if (yn_convert2Html) {
                value = HtmlUtils.string2html(value);
                label = HtmlUtils.string2html(label);
            }
            String selected = Arrays.binarySearch(selectedValues, value) < 0 ? " " : " CHECKED ";
            inputStatement.append("VALUE=\"" + value + "\"" + selected + ">" + checkboxLabelSeparator + label + optionSeparator[j]);
        }
        return inputStatement.substring(0, inputStatement.length() - optionSeparator[j].length());
    }

    public static String makeHtmlRadioSelect(String name, String[] values, String[] labels, String selectedValue, String checkboxLabelSeparator, String optionSeparator, String literalHtml, int convert2Html) {
        String[] optionSeparatorArray = new String[]{optionSeparator};
        return HtmlChoiceWriter.makeHtmlRadioSelect(name, values, labels, selectedValue, checkboxLabelSeparator, optionSeparatorArray, literalHtml, convert2Html);
    }

    public static String makeHtmlCheckboxSelect(String name, String[] values, String[] labels, String[] selectedValues, String checkboxLabelSeparator, String optionSeparator, String literalHtml, int convert2Html) {
        String[] optionSeparatorArray = new String[]{optionSeparator};
        return HtmlChoiceWriter.makeHtmlCheckboxSelect(name, values, labels, selectedValues, checkboxLabelSeparator, optionSeparatorArray, literalHtml, convert2Html);
    }
}

